
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/mediastream/media_stream.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class MediaStreamTrackMetricsHost_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<MediaStreamTrackMetricsHost, MediaStreamTrackMetricsHost.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<MediaStreamTrackMetricsHost, MediaStreamTrackMetricsHost.Proxy>() {

        @Override
        public String getName() {
            return "blink.mojom.MediaStreamTrackMetricsHost";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, MediaStreamTrackMetricsHost impl) {
            return new Stub(core, impl);
        }

        @Override
        public MediaStreamTrackMetricsHost[] buildArray(int size) {
          return new MediaStreamTrackMetricsHost[size];
        }
    };


    private static final int ADD_TRACK_ORDINAL = 0;

    private static final int REMOVE_TRACK_ORDINAL = 1;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements MediaStreamTrackMetricsHost.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void addTrack(
long id, boolean isAudio, boolean isRemote) {

            MediaStreamTrackMetricsHostAddTrackParams _message = new MediaStreamTrackMetricsHostAddTrackParams();

            _message.id = id;

            _message.isAudio = isAudio;

            _message.isRemote = isRemote;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ADD_TRACK_ORDINAL)));

        }


        @Override
        public void removeTrack(
long id) {

            MediaStreamTrackMetricsHostRemoveTrackParams _message = new MediaStreamTrackMetricsHostRemoveTrackParams();

            _message.id = id;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(REMOVE_TRACK_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<MediaStreamTrackMetricsHost> {

        Stub(com.vccorp.mojo.system.Core core, MediaStreamTrackMetricsHost impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                MediaStreamTrackMetricsHost_Internal.MANAGER, messageWithHeader);





                    case ADD_TRACK_ORDINAL: {

                        MediaStreamTrackMetricsHostAddTrackParams data =
                                MediaStreamTrackMetricsHostAddTrackParams.deserialize(messageWithHeader.getPayload());

                        getImpl().addTrack(data.id, data.isAudio, data.isRemote);
                        return true;
                    }





                    case REMOVE_TRACK_ORDINAL: {

                        MediaStreamTrackMetricsHostRemoveTrackParams data =
                                MediaStreamTrackMetricsHostRemoveTrackParams.deserialize(messageWithHeader.getPayload());

                        getImpl().removeTrack(data.id);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), MediaStreamTrackMetricsHost_Internal.MANAGER, messageWithHeader, receiver);






                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class MediaStreamTrackMetricsHostAddTrackParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public long id;
        public boolean isAudio;
        public boolean isRemote;

        private MediaStreamTrackMetricsHostAddTrackParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public MediaStreamTrackMetricsHostAddTrackParams() {
            this(0);
        }

        public static MediaStreamTrackMetricsHostAddTrackParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static MediaStreamTrackMetricsHostAddTrackParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static MediaStreamTrackMetricsHostAddTrackParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            MediaStreamTrackMetricsHostAddTrackParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new MediaStreamTrackMetricsHostAddTrackParams(elementsOrVersion);
                    {
                        
                    result.id = decoder0.readLong(8);
                    }
                    {
                        
                    result.isAudio = decoder0.readBoolean(16, 0);
                    }
                    {
                        
                    result.isRemote = decoder0.readBoolean(16, 1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.id, 8);
            
            encoder0.encode(this.isAudio, 16, 0);
            
            encoder0.encode(this.isRemote, 16, 1);
        }
    }



    
    static final class MediaStreamTrackMetricsHostRemoveTrackParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public long id;

        private MediaStreamTrackMetricsHostRemoveTrackParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public MediaStreamTrackMetricsHostRemoveTrackParams() {
            this(0);
        }

        public static MediaStreamTrackMetricsHostRemoveTrackParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static MediaStreamTrackMetricsHostRemoveTrackParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static MediaStreamTrackMetricsHostRemoveTrackParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            MediaStreamTrackMetricsHostRemoveTrackParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new MediaStreamTrackMetricsHostRemoveTrackParams(elementsOrVersion);
                    {
                        
                    result.id = decoder0.readLong(8);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.id, 8);
        }
    }



}
