
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/mediastream/media_stream.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class MediaStreamDispatcherHost_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<MediaStreamDispatcherHost, MediaStreamDispatcherHost.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<MediaStreamDispatcherHost, MediaStreamDispatcherHost.Proxy>() {

        @Override
        public String getName() {
            return "blink.mojom.MediaStreamDispatcherHost";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, MediaStreamDispatcherHost impl) {
            return new Stub(core, impl);
        }

        @Override
        public MediaStreamDispatcherHost[] buildArray(int size) {
          return new MediaStreamDispatcherHost[size];
        }
    };


    private static final int GENERATE_STREAM_ORDINAL = 0;

    private static final int CANCEL_REQUEST_ORDINAL = 1;

    private static final int STOP_STREAM_DEVICE_ORDINAL = 2;

    private static final int OPEN_DEVICE_ORDINAL = 3;

    private static final int CLOSE_DEVICE_ORDINAL = 4;

    private static final int SET_CAPTURING_LINK_SECURED_ORDINAL = 5;

    private static final int ON_STREAM_STARTED_ORDINAL = 6;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements MediaStreamDispatcherHost.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void generateStream(
int requestId, StreamControls controls, boolean userGesture, 
GenerateStreamResponse callback) {

            MediaStreamDispatcherHostGenerateStreamParams _message = new MediaStreamDispatcherHostGenerateStreamParams();

            _message.requestId = requestId;

            _message.controls = controls;

            _message.userGesture = userGesture;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GENERATE_STREAM_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new MediaStreamDispatcherHostGenerateStreamResponseParamsForwardToCallback(callback));

        }


        @Override
        public void cancelRequest(
int requestId) {

            MediaStreamDispatcherHostCancelRequestParams _message = new MediaStreamDispatcherHostCancelRequestParams();

            _message.requestId = requestId;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(CANCEL_REQUEST_ORDINAL)));

        }


        @Override
        public void stopStreamDevice(
String deviceId, int sessionId) {

            MediaStreamDispatcherHostStopStreamDeviceParams _message = new MediaStreamDispatcherHostStopStreamDeviceParams();

            _message.deviceId = deviceId;

            _message.sessionId = sessionId;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(STOP_STREAM_DEVICE_ORDINAL)));

        }


        @Override
        public void openDevice(
int requestId, String deviceId, int type, 
OpenDeviceResponse callback) {

            MediaStreamDispatcherHostOpenDeviceParams _message = new MediaStreamDispatcherHostOpenDeviceParams();

            _message.requestId = requestId;

            _message.deviceId = deviceId;

            _message.type = type;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    OPEN_DEVICE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new MediaStreamDispatcherHostOpenDeviceResponseParamsForwardToCallback(callback));

        }


        @Override
        public void closeDevice(
String label) {

            MediaStreamDispatcherHostCloseDeviceParams _message = new MediaStreamDispatcherHostCloseDeviceParams();

            _message.label = label;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(CLOSE_DEVICE_ORDINAL)));

        }


        @Override
        public void setCapturingLinkSecured(
int sessionId, int type, boolean isSecure) {

            MediaStreamDispatcherHostSetCapturingLinkSecuredParams _message = new MediaStreamDispatcherHostSetCapturingLinkSecuredParams();

            _message.sessionId = sessionId;

            _message.type = type;

            _message.isSecure = isSecure;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(SET_CAPTURING_LINK_SECURED_ORDINAL)));

        }


        @Override
        public void onStreamStarted(
String label) {

            MediaStreamDispatcherHostOnStreamStartedParams _message = new MediaStreamDispatcherHostOnStreamStartedParams();

            _message.label = label;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_STREAM_STARTED_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<MediaStreamDispatcherHost> {

        Stub(com.vccorp.mojo.system.Core core, MediaStreamDispatcherHost impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                MediaStreamDispatcherHost_Internal.MANAGER, messageWithHeader);







                    case CANCEL_REQUEST_ORDINAL: {

                        MediaStreamDispatcherHostCancelRequestParams data =
                                MediaStreamDispatcherHostCancelRequestParams.deserialize(messageWithHeader.getPayload());

                        getImpl().cancelRequest(data.requestId);
                        return true;
                    }





                    case STOP_STREAM_DEVICE_ORDINAL: {

                        MediaStreamDispatcherHostStopStreamDeviceParams data =
                                MediaStreamDispatcherHostStopStreamDeviceParams.deserialize(messageWithHeader.getPayload());

                        getImpl().stopStreamDevice(data.deviceId, data.sessionId);
                        return true;
                    }







                    case CLOSE_DEVICE_ORDINAL: {

                        MediaStreamDispatcherHostCloseDeviceParams data =
                                MediaStreamDispatcherHostCloseDeviceParams.deserialize(messageWithHeader.getPayload());

                        getImpl().closeDevice(data.label);
                        return true;
                    }





                    case SET_CAPTURING_LINK_SECURED_ORDINAL: {

                        MediaStreamDispatcherHostSetCapturingLinkSecuredParams data =
                                MediaStreamDispatcherHostSetCapturingLinkSecuredParams.deserialize(messageWithHeader.getPayload());

                        getImpl().setCapturingLinkSecured(data.sessionId, data.type, data.isSecure);
                        return true;
                    }





                    case ON_STREAM_STARTED_ORDINAL: {

                        MediaStreamDispatcherHostOnStreamStartedParams data =
                                MediaStreamDispatcherHostOnStreamStartedParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onStreamStarted(data.label);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), MediaStreamDispatcherHost_Internal.MANAGER, messageWithHeader, receiver);







                    case GENERATE_STREAM_ORDINAL: {

                        MediaStreamDispatcherHostGenerateStreamParams data =
                                MediaStreamDispatcherHostGenerateStreamParams.deserialize(messageWithHeader.getPayload());

                        getImpl().generateStream(data.requestId, data.controls, data.userGesture, new MediaStreamDispatcherHostGenerateStreamResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }











                    case OPEN_DEVICE_ORDINAL: {

                        MediaStreamDispatcherHostOpenDeviceParams data =
                                MediaStreamDispatcherHostOpenDeviceParams.deserialize(messageWithHeader.getPayload());

                        getImpl().openDevice(data.requestId, data.deviceId, data.type, new MediaStreamDispatcherHostOpenDeviceResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }








                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class MediaStreamDispatcherHostGenerateStreamParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int requestId;
        public StreamControls controls;
        public boolean userGesture;

        private MediaStreamDispatcherHostGenerateStreamParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public MediaStreamDispatcherHostGenerateStreamParams() {
            this(0);
        }

        public static MediaStreamDispatcherHostGenerateStreamParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static MediaStreamDispatcherHostGenerateStreamParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static MediaStreamDispatcherHostGenerateStreamParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            MediaStreamDispatcherHostGenerateStreamParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new MediaStreamDispatcherHostGenerateStreamParams(elementsOrVersion);
                    {
                        
                    result.requestId = decoder0.readInt(8);
                    }
                    {
                        
                    result.userGesture = decoder0.readBoolean(12, 0);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.controls = StreamControls.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.requestId, 8);
            
            encoder0.encode(this.userGesture, 12, 0);
            
            encoder0.encode(this.controls, 16, false);
        }
    }



    
    static final class MediaStreamDispatcherHostGenerateStreamResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 40;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(40, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int result;
        public String label;
        public MediaStreamDevice[] audioDevices;
        public MediaStreamDevice[] videoDevices;

        private MediaStreamDispatcherHostGenerateStreamResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public MediaStreamDispatcherHostGenerateStreamResponseParams() {
            this(0);
        }

        public static MediaStreamDispatcherHostGenerateStreamResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static MediaStreamDispatcherHostGenerateStreamResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static MediaStreamDispatcherHostGenerateStreamResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            MediaStreamDispatcherHostGenerateStreamResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new MediaStreamDispatcherHostGenerateStreamResponseParams(elementsOrVersion);
                    {
                        
                    result.result = decoder0.readInt(8);
                        MediaStreamRequestResult.validate(result.result);
                    }
                    {
                        
                    result.label = decoder0.readString(16, false);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                    {
                        com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        result.audioDevices = new MediaStreamDevice[si1.elementsOrVersion];
                        for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                            
                            com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                            result.audioDevices[i1] = MediaStreamDevice.decode(decoder2);
                        }
                    }
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(32, false);
                    {
                        com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        result.videoDevices = new MediaStreamDevice[si1.elementsOrVersion];
                        for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                            
                            com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                            result.videoDevices[i1] = MediaStreamDevice.decode(decoder2);
                        }
                    }
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.result, 8);
            
            encoder0.encode(this.label, 16, false);
            
            if (this.audioDevices == null) {
                encoder0.encodeNullPointer(24, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.audioDevices.length, 24, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < this.audioDevices.length; ++i0) {
                    
                    encoder1.encode(this.audioDevices[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
            
            if (this.videoDevices == null) {
                encoder0.encodeNullPointer(32, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.videoDevices.length, 32, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < this.videoDevices.length; ++i0) {
                    
                    encoder1.encode(this.videoDevices[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
        }
    }

    static class MediaStreamDispatcherHostGenerateStreamResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final MediaStreamDispatcherHost.GenerateStreamResponse mCallback;

        MediaStreamDispatcherHostGenerateStreamResponseParamsForwardToCallback(MediaStreamDispatcherHost.GenerateStreamResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(GENERATE_STREAM_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                MediaStreamDispatcherHostGenerateStreamResponseParams response = MediaStreamDispatcherHostGenerateStreamResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.result, response.label, response.audioDevices, response.videoDevices);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class MediaStreamDispatcherHostGenerateStreamResponseParamsProxyToResponder implements MediaStreamDispatcherHost.GenerateStreamResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        MediaStreamDispatcherHostGenerateStreamResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer result, String label, MediaStreamDevice[] audioDevices, MediaStreamDevice[] videoDevices) {
            MediaStreamDispatcherHostGenerateStreamResponseParams _response = new MediaStreamDispatcherHostGenerateStreamResponseParams();

            _response.result = result;

            _response.label = label;

            _response.audioDevices = audioDevices;

            _response.videoDevices = videoDevices;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GENERATE_STREAM_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class MediaStreamDispatcherHostCancelRequestParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int requestId;

        private MediaStreamDispatcherHostCancelRequestParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public MediaStreamDispatcherHostCancelRequestParams() {
            this(0);
        }

        public static MediaStreamDispatcherHostCancelRequestParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static MediaStreamDispatcherHostCancelRequestParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static MediaStreamDispatcherHostCancelRequestParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            MediaStreamDispatcherHostCancelRequestParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new MediaStreamDispatcherHostCancelRequestParams(elementsOrVersion);
                    {
                        
                    result.requestId = decoder0.readInt(8);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.requestId, 8);
        }
    }



    
    static final class MediaStreamDispatcherHostStopStreamDeviceParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String deviceId;
        public int sessionId;

        private MediaStreamDispatcherHostStopStreamDeviceParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public MediaStreamDispatcherHostStopStreamDeviceParams() {
            this(0);
        }

        public static MediaStreamDispatcherHostStopStreamDeviceParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static MediaStreamDispatcherHostStopStreamDeviceParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static MediaStreamDispatcherHostStopStreamDeviceParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            MediaStreamDispatcherHostStopStreamDeviceParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new MediaStreamDispatcherHostStopStreamDeviceParams(elementsOrVersion);
                    {
                        
                    result.deviceId = decoder0.readString(8, false);
                    }
                    {
                        
                    result.sessionId = decoder0.readInt(16);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.deviceId, 8, false);
            
            encoder0.encode(this.sessionId, 16);
        }
    }



    
    static final class MediaStreamDispatcherHostOpenDeviceParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int requestId;
        public String deviceId;
        public int type;

        private MediaStreamDispatcherHostOpenDeviceParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public MediaStreamDispatcherHostOpenDeviceParams() {
            this(0);
        }

        public static MediaStreamDispatcherHostOpenDeviceParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static MediaStreamDispatcherHostOpenDeviceParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static MediaStreamDispatcherHostOpenDeviceParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            MediaStreamDispatcherHostOpenDeviceParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new MediaStreamDispatcherHostOpenDeviceParams(elementsOrVersion);
                    {
                        
                    result.requestId = decoder0.readInt(8);
                    }
                    {
                        
                    result.type = decoder0.readInt(12);
                        MediaStreamType.validate(result.type);
                    }
                    {
                        
                    result.deviceId = decoder0.readString(16, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.requestId, 8);
            
            encoder0.encode(this.type, 12);
            
            encoder0.encode(this.deviceId, 16, false);
        }
    }



    
    static final class MediaStreamDispatcherHostOpenDeviceResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 32;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(32, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public boolean success;
        public String label;
        public MediaStreamDevice device;

        private MediaStreamDispatcherHostOpenDeviceResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public MediaStreamDispatcherHostOpenDeviceResponseParams() {
            this(0);
        }

        public static MediaStreamDispatcherHostOpenDeviceResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static MediaStreamDispatcherHostOpenDeviceResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static MediaStreamDispatcherHostOpenDeviceResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            MediaStreamDispatcherHostOpenDeviceResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new MediaStreamDispatcherHostOpenDeviceResponseParams(elementsOrVersion);
                    {
                        
                    result.success = decoder0.readBoolean(8, 0);
                    }
                    {
                        
                    result.label = decoder0.readString(16, false);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                    result.device = MediaStreamDevice.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.success, 8, 0);
            
            encoder0.encode(this.label, 16, false);
            
            encoder0.encode(this.device, 24, false);
        }
    }

    static class MediaStreamDispatcherHostOpenDeviceResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final MediaStreamDispatcherHost.OpenDeviceResponse mCallback;

        MediaStreamDispatcherHostOpenDeviceResponseParamsForwardToCallback(MediaStreamDispatcherHost.OpenDeviceResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(OPEN_DEVICE_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                MediaStreamDispatcherHostOpenDeviceResponseParams response = MediaStreamDispatcherHostOpenDeviceResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.success, response.label, response.device);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class MediaStreamDispatcherHostOpenDeviceResponseParamsProxyToResponder implements MediaStreamDispatcherHost.OpenDeviceResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        MediaStreamDispatcherHostOpenDeviceResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Boolean success, String label, MediaStreamDevice device) {
            MediaStreamDispatcherHostOpenDeviceResponseParams _response = new MediaStreamDispatcherHostOpenDeviceResponseParams();

            _response.success = success;

            _response.label = label;

            _response.device = device;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    OPEN_DEVICE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class MediaStreamDispatcherHostCloseDeviceParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String label;

        private MediaStreamDispatcherHostCloseDeviceParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public MediaStreamDispatcherHostCloseDeviceParams() {
            this(0);
        }

        public static MediaStreamDispatcherHostCloseDeviceParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static MediaStreamDispatcherHostCloseDeviceParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static MediaStreamDispatcherHostCloseDeviceParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            MediaStreamDispatcherHostCloseDeviceParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new MediaStreamDispatcherHostCloseDeviceParams(elementsOrVersion);
                    {
                        
                    result.label = decoder0.readString(8, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.label, 8, false);
        }
    }



    
    static final class MediaStreamDispatcherHostSetCapturingLinkSecuredParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int sessionId;
        public int type;
        public boolean isSecure;

        private MediaStreamDispatcherHostSetCapturingLinkSecuredParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public MediaStreamDispatcherHostSetCapturingLinkSecuredParams() {
            this(0);
        }

        public static MediaStreamDispatcherHostSetCapturingLinkSecuredParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static MediaStreamDispatcherHostSetCapturingLinkSecuredParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static MediaStreamDispatcherHostSetCapturingLinkSecuredParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            MediaStreamDispatcherHostSetCapturingLinkSecuredParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new MediaStreamDispatcherHostSetCapturingLinkSecuredParams(elementsOrVersion);
                    {
                        
                    result.sessionId = decoder0.readInt(8);
                    }
                    {
                        
                    result.type = decoder0.readInt(12);
                        MediaStreamType.validate(result.type);
                    }
                    {
                        
                    result.isSecure = decoder0.readBoolean(16, 0);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.sessionId, 8);
            
            encoder0.encode(this.type, 12);
            
            encoder0.encode(this.isSecure, 16, 0);
        }
    }



    
    static final class MediaStreamDispatcherHostOnStreamStartedParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String label;

        private MediaStreamDispatcherHostOnStreamStartedParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public MediaStreamDispatcherHostOnStreamStartedParams() {
            this(0);
        }

        public static MediaStreamDispatcherHostOnStreamStartedParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static MediaStreamDispatcherHostOnStreamStartedParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static MediaStreamDispatcherHostOnStreamStartedParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            MediaStreamDispatcherHostOnStreamStartedParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new MediaStreamDispatcherHostOnStreamStartedParams(elementsOrVersion);
                    {
                        
                    result.label = decoder0.readString(8, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.label, 8, false);
        }
    }



}
