
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/service_worker/embedded_worker.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class EmbeddedWorkerInstanceHost_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<EmbeddedWorkerInstanceHost, EmbeddedWorkerInstanceHost.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<EmbeddedWorkerInstanceHost, EmbeddedWorkerInstanceHost.Proxy>() {

        @Override
        public String getName() {
            return "blink.mojom.EmbeddedWorkerInstanceHost";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, EmbeddedWorkerInstanceHost impl) {
            return new Stub(core, impl);
        }

        @Override
        public EmbeddedWorkerInstanceHost[] buildArray(int size) {
          return new EmbeddedWorkerInstanceHost[size];
        }
    };


    private static final int REQUEST_TERMINATION_ORDINAL = 0;

    private static final int COUNT_FEATURE_ORDINAL = 1;

    private static final int ON_READY_FOR_INSPECTION_ORDINAL = 2;

    private static final int ON_SCRIPT_LOADED_ORDINAL = 3;

    private static final int ON_SCRIPT_EVALUATION_START_ORDINAL = 4;

    private static final int ON_STARTED_ORDINAL = 5;

    private static final int ON_REPORT_EXCEPTION_ORDINAL = 6;

    private static final int ON_REPORT_CONSOLE_MESSAGE_ORDINAL = 7;

    private static final int ON_STOPPED_ORDINAL = 8;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements EmbeddedWorkerInstanceHost.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void requestTermination(

RequestTerminationResponse callback) {

            EmbeddedWorkerInstanceHostRequestTerminationParams _message = new EmbeddedWorkerInstanceHostRequestTerminationParams();


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    REQUEST_TERMINATION_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new EmbeddedWorkerInstanceHostRequestTerminationResponseParamsForwardToCallback(callback));

        }


        @Override
        public void countFeature(
int feature) {

            EmbeddedWorkerInstanceHostCountFeatureParams _message = new EmbeddedWorkerInstanceHostCountFeatureParams();

            _message.feature = feature;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(COUNT_FEATURE_ORDINAL)));

        }


        @Override
        public void onReadyForInspection(
) {

            EmbeddedWorkerInstanceHostOnReadyForInspectionParams _message = new EmbeddedWorkerInstanceHostOnReadyForInspectionParams();


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_READY_FOR_INSPECTION_ORDINAL)));

        }


        @Override
        public void onScriptLoaded(
) {

            EmbeddedWorkerInstanceHostOnScriptLoadedParams _message = new EmbeddedWorkerInstanceHostOnScriptLoadedParams();


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_SCRIPT_LOADED_ORDINAL)));

        }


        @Override
        public void onScriptEvaluationStart(
) {

            EmbeddedWorkerInstanceHostOnScriptEvaluationStartParams _message = new EmbeddedWorkerInstanceHostOnScriptEvaluationStartParams();


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_SCRIPT_EVALUATION_START_ORDINAL)));

        }


        @Override
        public void onStarted(
int status, int threadId, EmbeddedWorkerStartTiming startTiming) {

            EmbeddedWorkerInstanceHostOnStartedParams _message = new EmbeddedWorkerInstanceHostOnStartedParams();

            _message.status = status;

            _message.threadId = threadId;

            _message.startTiming = startTiming;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_STARTED_ORDINAL)));

        }


        @Override
        public void onReportException(
com.vccorp.mojo_base.mojom.String16 errorMessage, int lineNumber, int columnNumber, com.vccorp.url.mojom.Url sourceUrl) {

            EmbeddedWorkerInstanceHostOnReportExceptionParams _message = new EmbeddedWorkerInstanceHostOnReportExceptionParams();

            _message.errorMessage = errorMessage;

            _message.lineNumber = lineNumber;

            _message.columnNumber = columnNumber;

            _message.sourceUrl = sourceUrl;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_REPORT_EXCEPTION_ORDINAL)));

        }


        @Override
        public void onReportConsoleMessage(
int source, int messageLevel, com.vccorp.mojo_base.mojom.String16 message, int lineNumber, com.vccorp.url.mojom.Url sourceUrl) {

            EmbeddedWorkerInstanceHostOnReportConsoleMessageParams _message = new EmbeddedWorkerInstanceHostOnReportConsoleMessageParams();

            _message.source = source;

            _message.messageLevel = messageLevel;

            _message.message = message;

            _message.lineNumber = lineNumber;

            _message.sourceUrl = sourceUrl;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_REPORT_CONSOLE_MESSAGE_ORDINAL)));

        }


        @Override
        public void onStopped(
) {

            EmbeddedWorkerInstanceHostOnStoppedParams _message = new EmbeddedWorkerInstanceHostOnStoppedParams();


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_STOPPED_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<EmbeddedWorkerInstanceHost> {

        Stub(com.vccorp.mojo.system.Core core, EmbeddedWorkerInstanceHost impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                EmbeddedWorkerInstanceHost_Internal.MANAGER, messageWithHeader);







                    case COUNT_FEATURE_ORDINAL: {

                        EmbeddedWorkerInstanceHostCountFeatureParams data =
                                EmbeddedWorkerInstanceHostCountFeatureParams.deserialize(messageWithHeader.getPayload());

                        getImpl().countFeature(data.feature);
                        return true;
                    }





                    case ON_READY_FOR_INSPECTION_ORDINAL: {

                        EmbeddedWorkerInstanceHostOnReadyForInspectionParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onReadyForInspection();
                        return true;
                    }





                    case ON_SCRIPT_LOADED_ORDINAL: {

                        EmbeddedWorkerInstanceHostOnScriptLoadedParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onScriptLoaded();
                        return true;
                    }





                    case ON_SCRIPT_EVALUATION_START_ORDINAL: {

                        EmbeddedWorkerInstanceHostOnScriptEvaluationStartParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onScriptEvaluationStart();
                        return true;
                    }





                    case ON_STARTED_ORDINAL: {

                        EmbeddedWorkerInstanceHostOnStartedParams data =
                                EmbeddedWorkerInstanceHostOnStartedParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onStarted(data.status, data.threadId, data.startTiming);
                        return true;
                    }





                    case ON_REPORT_EXCEPTION_ORDINAL: {

                        EmbeddedWorkerInstanceHostOnReportExceptionParams data =
                                EmbeddedWorkerInstanceHostOnReportExceptionParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onReportException(data.errorMessage, data.lineNumber, data.columnNumber, data.sourceUrl);
                        return true;
                    }





                    case ON_REPORT_CONSOLE_MESSAGE_ORDINAL: {

                        EmbeddedWorkerInstanceHostOnReportConsoleMessageParams data =
                                EmbeddedWorkerInstanceHostOnReportConsoleMessageParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onReportConsoleMessage(data.source, data.messageLevel, data.message, data.lineNumber, data.sourceUrl);
                        return true;
                    }





                    case ON_STOPPED_ORDINAL: {

                        EmbeddedWorkerInstanceHostOnStoppedParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onStopped();
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), EmbeddedWorkerInstanceHost_Internal.MANAGER, messageWithHeader, receiver);







                    case REQUEST_TERMINATION_ORDINAL: {

                        EmbeddedWorkerInstanceHostRequestTerminationParams.deserialize(messageWithHeader.getPayload());

                        getImpl().requestTermination(new EmbeddedWorkerInstanceHostRequestTerminationResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }


















                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class EmbeddedWorkerInstanceHostRequestTerminationParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private EmbeddedWorkerInstanceHostRequestTerminationParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public EmbeddedWorkerInstanceHostRequestTerminationParams() {
            this(0);
        }

        public static EmbeddedWorkerInstanceHostRequestTerminationParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static EmbeddedWorkerInstanceHostRequestTerminationParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static EmbeddedWorkerInstanceHostRequestTerminationParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            EmbeddedWorkerInstanceHostRequestTerminationParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new EmbeddedWorkerInstanceHostRequestTerminationParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class EmbeddedWorkerInstanceHostRequestTerminationResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public boolean willBeTerminated;

        private EmbeddedWorkerInstanceHostRequestTerminationResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public EmbeddedWorkerInstanceHostRequestTerminationResponseParams() {
            this(0);
        }

        public static EmbeddedWorkerInstanceHostRequestTerminationResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static EmbeddedWorkerInstanceHostRequestTerminationResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static EmbeddedWorkerInstanceHostRequestTerminationResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            EmbeddedWorkerInstanceHostRequestTerminationResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new EmbeddedWorkerInstanceHostRequestTerminationResponseParams(elementsOrVersion);
                    {
                        
                    result.willBeTerminated = decoder0.readBoolean(8, 0);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.willBeTerminated, 8, 0);
        }
    }

    static class EmbeddedWorkerInstanceHostRequestTerminationResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final EmbeddedWorkerInstanceHost.RequestTerminationResponse mCallback;

        EmbeddedWorkerInstanceHostRequestTerminationResponseParamsForwardToCallback(EmbeddedWorkerInstanceHost.RequestTerminationResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(REQUEST_TERMINATION_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                EmbeddedWorkerInstanceHostRequestTerminationResponseParams response = EmbeddedWorkerInstanceHostRequestTerminationResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.willBeTerminated);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class EmbeddedWorkerInstanceHostRequestTerminationResponseParamsProxyToResponder implements EmbeddedWorkerInstanceHost.RequestTerminationResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        EmbeddedWorkerInstanceHostRequestTerminationResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Boolean willBeTerminated) {
            EmbeddedWorkerInstanceHostRequestTerminationResponseParams _response = new EmbeddedWorkerInstanceHostRequestTerminationResponseParams();

            _response.willBeTerminated = willBeTerminated;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    REQUEST_TERMINATION_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class EmbeddedWorkerInstanceHostCountFeatureParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int feature;

        private EmbeddedWorkerInstanceHostCountFeatureParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public EmbeddedWorkerInstanceHostCountFeatureParams() {
            this(0);
        }

        public static EmbeddedWorkerInstanceHostCountFeatureParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static EmbeddedWorkerInstanceHostCountFeatureParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static EmbeddedWorkerInstanceHostCountFeatureParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            EmbeddedWorkerInstanceHostCountFeatureParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new EmbeddedWorkerInstanceHostCountFeatureParams(elementsOrVersion);
                    {
                        
                    result.feature = decoder0.readInt(8);
                        WebFeature.validate(result.feature);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.feature, 8);
        }
    }



    
    static final class EmbeddedWorkerInstanceHostOnReadyForInspectionParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private EmbeddedWorkerInstanceHostOnReadyForInspectionParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public EmbeddedWorkerInstanceHostOnReadyForInspectionParams() {
            this(0);
        }

        public static EmbeddedWorkerInstanceHostOnReadyForInspectionParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static EmbeddedWorkerInstanceHostOnReadyForInspectionParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static EmbeddedWorkerInstanceHostOnReadyForInspectionParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            EmbeddedWorkerInstanceHostOnReadyForInspectionParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new EmbeddedWorkerInstanceHostOnReadyForInspectionParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class EmbeddedWorkerInstanceHostOnScriptLoadedParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private EmbeddedWorkerInstanceHostOnScriptLoadedParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public EmbeddedWorkerInstanceHostOnScriptLoadedParams() {
            this(0);
        }

        public static EmbeddedWorkerInstanceHostOnScriptLoadedParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static EmbeddedWorkerInstanceHostOnScriptLoadedParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static EmbeddedWorkerInstanceHostOnScriptLoadedParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            EmbeddedWorkerInstanceHostOnScriptLoadedParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new EmbeddedWorkerInstanceHostOnScriptLoadedParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class EmbeddedWorkerInstanceHostOnScriptEvaluationStartParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private EmbeddedWorkerInstanceHostOnScriptEvaluationStartParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public EmbeddedWorkerInstanceHostOnScriptEvaluationStartParams() {
            this(0);
        }

        public static EmbeddedWorkerInstanceHostOnScriptEvaluationStartParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static EmbeddedWorkerInstanceHostOnScriptEvaluationStartParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static EmbeddedWorkerInstanceHostOnScriptEvaluationStartParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            EmbeddedWorkerInstanceHostOnScriptEvaluationStartParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new EmbeddedWorkerInstanceHostOnScriptEvaluationStartParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class EmbeddedWorkerInstanceHostOnStartedParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int status;
        public int threadId;
        public EmbeddedWorkerStartTiming startTiming;

        private EmbeddedWorkerInstanceHostOnStartedParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public EmbeddedWorkerInstanceHostOnStartedParams() {
            this(0);
        }

        public static EmbeddedWorkerInstanceHostOnStartedParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static EmbeddedWorkerInstanceHostOnStartedParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static EmbeddedWorkerInstanceHostOnStartedParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            EmbeddedWorkerInstanceHostOnStartedParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new EmbeddedWorkerInstanceHostOnStartedParams(elementsOrVersion);
                    {
                        
                    result.status = decoder0.readInt(8);
                        ServiceWorkerStartStatus.validate(result.status);
                    }
                    {
                        
                    result.threadId = decoder0.readInt(12);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.startTiming = EmbeddedWorkerStartTiming.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.status, 8);
            
            encoder0.encode(this.threadId, 12);
            
            encoder0.encode(this.startTiming, 16, false);
        }
    }



    
    static final class EmbeddedWorkerInstanceHostOnReportExceptionParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 32;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(32, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo_base.mojom.String16 errorMessage;
        public int lineNumber;
        public int columnNumber;
        public com.vccorp.url.mojom.Url sourceUrl;

        private EmbeddedWorkerInstanceHostOnReportExceptionParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public EmbeddedWorkerInstanceHostOnReportExceptionParams() {
            this(0);
        }

        public static EmbeddedWorkerInstanceHostOnReportExceptionParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static EmbeddedWorkerInstanceHostOnReportExceptionParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static EmbeddedWorkerInstanceHostOnReportExceptionParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            EmbeddedWorkerInstanceHostOnReportExceptionParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new EmbeddedWorkerInstanceHostOnReportExceptionParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.errorMessage = com.vccorp.mojo_base.mojom.String16.decode(decoder1);
                    }
                    {
                        
                    result.lineNumber = decoder0.readInt(16);
                    }
                    {
                        
                    result.columnNumber = decoder0.readInt(20);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                    result.sourceUrl = com.vccorp.url.mojom.Url.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.errorMessage, 8, false);
            
            encoder0.encode(this.lineNumber, 16);
            
            encoder0.encode(this.columnNumber, 20);
            
            encoder0.encode(this.sourceUrl, 24, false);
        }
    }



    
    static final class EmbeddedWorkerInstanceHostOnReportConsoleMessageParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 40;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(40, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int source;
        public int messageLevel;
        public com.vccorp.mojo_base.mojom.String16 message;
        public int lineNumber;
        public com.vccorp.url.mojom.Url sourceUrl;

        private EmbeddedWorkerInstanceHostOnReportConsoleMessageParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public EmbeddedWorkerInstanceHostOnReportConsoleMessageParams() {
            this(0);
        }

        public static EmbeddedWorkerInstanceHostOnReportConsoleMessageParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static EmbeddedWorkerInstanceHostOnReportConsoleMessageParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static EmbeddedWorkerInstanceHostOnReportConsoleMessageParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            EmbeddedWorkerInstanceHostOnReportConsoleMessageParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new EmbeddedWorkerInstanceHostOnReportConsoleMessageParams(elementsOrVersion);
                    {
                        
                    result.source = decoder0.readInt(8);
                        ConsoleMessageSource.validate(result.source);
                    }
                    {
                        
                    result.messageLevel = decoder0.readInt(12);
                        ConsoleMessageLevel.validate(result.messageLevel);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.message = com.vccorp.mojo_base.mojom.String16.decode(decoder1);
                    }
                    {
                        
                    result.lineNumber = decoder0.readInt(24);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(32, false);
                    result.sourceUrl = com.vccorp.url.mojom.Url.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.source, 8);
            
            encoder0.encode(this.messageLevel, 12);
            
            encoder0.encode(this.message, 16, false);
            
            encoder0.encode(this.lineNumber, 24);
            
            encoder0.encode(this.sourceUrl, 32, false);
        }
    }



    
    static final class EmbeddedWorkerInstanceHostOnStoppedParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private EmbeddedWorkerInstanceHostOnStoppedParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public EmbeddedWorkerInstanceHostOnStoppedParams() {
            this(0);
        }

        public static EmbeddedWorkerInstanceHostOnStoppedParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static EmbeddedWorkerInstanceHostOnStoppedParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static EmbeddedWorkerInstanceHostOnStoppedParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            EmbeddedWorkerInstanceHostOnStoppedParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new EmbeddedWorkerInstanceHostOnStoppedParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



}
