
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/loader/code_cache.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class CodeCacheHost_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<CodeCacheHost, CodeCacheHost.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<CodeCacheHost, CodeCacheHost.Proxy>() {

        @Override
        public String getName() {
            return "blink.mojom.CodeCacheHost";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, CodeCacheHost impl) {
            return new Stub(core, impl);
        }

        @Override
        public CodeCacheHost[] buildArray(int size) {
          return new CodeCacheHost[size];
        }
    };


    private static final int DID_GENERATE_CACHEABLE_METADATA_ORDINAL = 0;

    private static final int FETCH_CACHED_CODE_ORDINAL = 1;

    private static final int CLEAR_CODE_CACHE_ENTRY_ORDINAL = 2;

    private static final int DID_GENERATE_CACHEABLE_METADATA_IN_CACHE_STORAGE_ORDINAL = 3;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements CodeCacheHost.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void didGenerateCacheableMetadata(
int cacheType, com.vccorp.url.mojom.Url url, com.vccorp.mojo_base.mojom.Time expectedResponseTime, byte[] data) {

            CodeCacheHostDidGenerateCacheableMetadataParams _message = new CodeCacheHostDidGenerateCacheableMetadataParams();

            _message.cacheType = cacheType;

            _message.url = url;

            _message.expectedResponseTime = expectedResponseTime;

            _message.data = data;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(DID_GENERATE_CACHEABLE_METADATA_ORDINAL)));

        }


        @Override
        public void fetchCachedCode(
int cacheType, com.vccorp.url.mojom.Url url,
FetchCachedCodeResponse callback) {

            CodeCacheHostFetchCachedCodeParams _message = new CodeCacheHostFetchCachedCodeParams();

            _message.cacheType = cacheType;

            _message.url = url;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    FETCH_CACHED_CODE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new CodeCacheHostFetchCachedCodeResponseParamsForwardToCallback(callback));

        }


        @Override
        public void clearCodeCacheEntry(
int cacheType, com.vccorp.url.mojom.Url url) {

            CodeCacheHostClearCodeCacheEntryParams _message = new CodeCacheHostClearCodeCacheEntryParams();

            _message.cacheType = cacheType;

            _message.url = url;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(CLEAR_CODE_CACHE_ENTRY_ORDINAL)));

        }


        @Override
        public void didGenerateCacheableMetadataInCacheStorage(
com.vccorp.url.mojom.Url url, com.vccorp.mojo_base.mojom.Time expectedResponseTime, byte[] data, com.vccorp.url.mojom.Origin cacheStorageOrigin, String cacheStorageCacheName) {

            CodeCacheHostDidGenerateCacheableMetadataInCacheStorageParams _message = new CodeCacheHostDidGenerateCacheableMetadataInCacheStorageParams();

            _message.url = url;

            _message.expectedResponseTime = expectedResponseTime;

            _message.data = data;

            _message.cacheStorageOrigin = cacheStorageOrigin;

            _message.cacheStorageCacheName = cacheStorageCacheName;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(DID_GENERATE_CACHEABLE_METADATA_IN_CACHE_STORAGE_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<CodeCacheHost> {

        Stub(com.vccorp.mojo.system.Core core, CodeCacheHost impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                CodeCacheHost_Internal.MANAGER, messageWithHeader);





                    case DID_GENERATE_CACHEABLE_METADATA_ORDINAL: {

                        CodeCacheHostDidGenerateCacheableMetadataParams data =
                                CodeCacheHostDidGenerateCacheableMetadataParams.deserialize(messageWithHeader.getPayload());

                        getImpl().didGenerateCacheableMetadata(data.cacheType, data.url, data.expectedResponseTime, data.data);
                        return true;
                    }







                    case CLEAR_CODE_CACHE_ENTRY_ORDINAL: {

                        CodeCacheHostClearCodeCacheEntryParams data =
                                CodeCacheHostClearCodeCacheEntryParams.deserialize(messageWithHeader.getPayload());

                        getImpl().clearCodeCacheEntry(data.cacheType, data.url);
                        return true;
                    }





                    case DID_GENERATE_CACHEABLE_METADATA_IN_CACHE_STORAGE_ORDINAL: {

                        CodeCacheHostDidGenerateCacheableMetadataInCacheStorageParams data =
                                CodeCacheHostDidGenerateCacheableMetadataInCacheStorageParams.deserialize(messageWithHeader.getPayload());

                        getImpl().didGenerateCacheableMetadataInCacheStorage(data.url, data.expectedResponseTime, data.data, data.cacheStorageOrigin, data.cacheStorageCacheName);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), CodeCacheHost_Internal.MANAGER, messageWithHeader, receiver);









                    case FETCH_CACHED_CODE_ORDINAL: {

                        CodeCacheHostFetchCachedCodeParams data =
                                CodeCacheHostFetchCachedCodeParams.deserialize(messageWithHeader.getPayload());

                        getImpl().fetchCachedCode(data.cacheType, data.url, new CodeCacheHostFetchCachedCodeResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }






                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class CodeCacheHostDidGenerateCacheableMetadataParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 40;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(40, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int cacheType;
        public com.vccorp.url.mojom.Url url;
        public com.vccorp.mojo_base.mojom.Time expectedResponseTime;
        public byte[] data;

        private CodeCacheHostDidGenerateCacheableMetadataParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public CodeCacheHostDidGenerateCacheableMetadataParams() {
            this(0);
        }

        public static CodeCacheHostDidGenerateCacheableMetadataParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static CodeCacheHostDidGenerateCacheableMetadataParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static CodeCacheHostDidGenerateCacheableMetadataParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            CodeCacheHostDidGenerateCacheableMetadataParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new CodeCacheHostDidGenerateCacheableMetadataParams(elementsOrVersion);
                    {
                        
                    result.cacheType = decoder0.readInt(8);
                        CodeCacheType.validate(result.cacheType);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.url = com.vccorp.url.mojom.Url.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                    result.expectedResponseTime = com.vccorp.mojo_base.mojom.Time.decode(decoder1);
                    }
                    {
                        
                    result.data = decoder0.readBytes(32, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.cacheType, 8);
            
            encoder0.encode(this.url, 16, false);
            
            encoder0.encode(this.expectedResponseTime, 24, false);
            
            encoder0.encode(this.data, 32, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
        }
    }



    
    static final class CodeCacheHostFetchCachedCodeParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int cacheType;
        public com.vccorp.url.mojom.Url url;

        private CodeCacheHostFetchCachedCodeParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public CodeCacheHostFetchCachedCodeParams() {
            this(0);
        }

        public static CodeCacheHostFetchCachedCodeParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static CodeCacheHostFetchCachedCodeParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static CodeCacheHostFetchCachedCodeParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            CodeCacheHostFetchCachedCodeParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new CodeCacheHostFetchCachedCodeParams(elementsOrVersion);
                    {
                        
                    result.cacheType = decoder0.readInt(8);
                        CodeCacheType.validate(result.cacheType);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.url = com.vccorp.url.mojom.Url.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.cacheType, 8);
            
            encoder0.encode(this.url, 16, false);
        }
    }



    
    static final class CodeCacheHostFetchCachedCodeResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo_base.mojom.Time responseTime;
        public byte[] data;

        private CodeCacheHostFetchCachedCodeResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public CodeCacheHostFetchCachedCodeResponseParams() {
            this(0);
        }

        public static CodeCacheHostFetchCachedCodeResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static CodeCacheHostFetchCachedCodeResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static CodeCacheHostFetchCachedCodeResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            CodeCacheHostFetchCachedCodeResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new CodeCacheHostFetchCachedCodeResponseParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.responseTime = com.vccorp.mojo_base.mojom.Time.decode(decoder1);
                    }
                    {
                        
                    result.data = decoder0.readBytes(16, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.responseTime, 8, false);
            
            encoder0.encode(this.data, 16, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
        }
    }

    static class CodeCacheHostFetchCachedCodeResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final CodeCacheHost.FetchCachedCodeResponse mCallback;

        CodeCacheHostFetchCachedCodeResponseParamsForwardToCallback(CodeCacheHost.FetchCachedCodeResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(FETCH_CACHED_CODE_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                CodeCacheHostFetchCachedCodeResponseParams response = CodeCacheHostFetchCachedCodeResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.responseTime, response.data);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class CodeCacheHostFetchCachedCodeResponseParamsProxyToResponder implements CodeCacheHost.FetchCachedCodeResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        CodeCacheHostFetchCachedCodeResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(com.vccorp.mojo_base.mojom.Time responseTime, byte[] data) {
            CodeCacheHostFetchCachedCodeResponseParams _response = new CodeCacheHostFetchCachedCodeResponseParams();

            _response.responseTime = responseTime;

            _response.data = data;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    FETCH_CACHED_CODE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class CodeCacheHostClearCodeCacheEntryParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int cacheType;
        public com.vccorp.url.mojom.Url url;

        private CodeCacheHostClearCodeCacheEntryParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public CodeCacheHostClearCodeCacheEntryParams() {
            this(0);
        }

        public static CodeCacheHostClearCodeCacheEntryParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static CodeCacheHostClearCodeCacheEntryParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static CodeCacheHostClearCodeCacheEntryParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            CodeCacheHostClearCodeCacheEntryParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new CodeCacheHostClearCodeCacheEntryParams(elementsOrVersion);
                    {
                        
                    result.cacheType = decoder0.readInt(8);
                        CodeCacheType.validate(result.cacheType);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.url = com.vccorp.url.mojom.Url.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.cacheType, 8);
            
            encoder0.encode(this.url, 16, false);
        }
    }



    
    static final class CodeCacheHostDidGenerateCacheableMetadataInCacheStorageParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 48;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(48, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.url.mojom.Url url;
        public com.vccorp.mojo_base.mojom.Time expectedResponseTime;
        public byte[] data;
        public com.vccorp.url.mojom.Origin cacheStorageOrigin;
        public String cacheStorageCacheName;

        private CodeCacheHostDidGenerateCacheableMetadataInCacheStorageParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public CodeCacheHostDidGenerateCacheableMetadataInCacheStorageParams() {
            this(0);
        }

        public static CodeCacheHostDidGenerateCacheableMetadataInCacheStorageParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static CodeCacheHostDidGenerateCacheableMetadataInCacheStorageParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static CodeCacheHostDidGenerateCacheableMetadataInCacheStorageParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            CodeCacheHostDidGenerateCacheableMetadataInCacheStorageParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new CodeCacheHostDidGenerateCacheableMetadataInCacheStorageParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.url = com.vccorp.url.mojom.Url.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.expectedResponseTime = com.vccorp.mojo_base.mojom.Time.decode(decoder1);
                    }
                    {
                        
                    result.data = decoder0.readBytes(24, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(32, false);
                    result.cacheStorageOrigin = com.vccorp.url.mojom.Origin.decode(decoder1);
                    }
                    {
                        
                    result.cacheStorageCacheName = decoder0.readString(40, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.url, 8, false);
            
            encoder0.encode(this.expectedResponseTime, 16, false);
            
            encoder0.encode(this.data, 24, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
            
            encoder0.encode(this.cacheStorageOrigin, 32, false);
            
            encoder0.encode(this.cacheStorageCacheName, 40, false);
        }
    }



}
