
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/background_fetch/background_fetch.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class BackgroundFetchRegistrationService_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<BackgroundFetchRegistrationService, BackgroundFetchRegistrationService.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<BackgroundFetchRegistrationService, BackgroundFetchRegistrationService.Proxy>() {

        @Override
        public String getName() {
            return "blink.mojom.BackgroundFetchRegistrationService";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, BackgroundFetchRegistrationService impl) {
            return new Stub(core, impl);
        }

        @Override
        public BackgroundFetchRegistrationService[] buildArray(int size) {
          return new BackgroundFetchRegistrationService[size];
        }
    };


    private static final int UPDATE_UI_ORDINAL = 0;

    private static final int ABORT_ORDINAL = 1;

    private static final int MATCH_REQUESTS_ORDINAL = 2;

    private static final int ADD_REGISTRATION_OBSERVER_ORDINAL = 3;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements BackgroundFetchRegistrationService.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void updateUi(
String title, com.vccorp.skia.mojom.Bitmap icon,
UpdateUiResponse callback) {

            BackgroundFetchRegistrationServiceUpdateUiParams _message = new BackgroundFetchRegistrationServiceUpdateUiParams();

            _message.title = title;

            _message.icon = icon;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    UPDATE_UI_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new BackgroundFetchRegistrationServiceUpdateUiResponseParamsForwardToCallback(callback));

        }


        @Override
        public void abort(

AbortResponse callback) {

            BackgroundFetchRegistrationServiceAbortParams _message = new BackgroundFetchRegistrationServiceAbortParams();


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    ABORT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new BackgroundFetchRegistrationServiceAbortResponseParamsForwardToCallback(callback));

        }


        @Override
        public void matchRequests(
FetchApiRequest requestToMatch, CacheQueryOptions cacheQueryOptions, boolean matchAll, 
MatchRequestsResponse callback) {

            BackgroundFetchRegistrationServiceMatchRequestsParams _message = new BackgroundFetchRegistrationServiceMatchRequestsParams();

            _message.requestToMatch = requestToMatch;

            _message.cacheQueryOptions = cacheQueryOptions;

            _message.matchAll = matchAll;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    MATCH_REQUESTS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new BackgroundFetchRegistrationServiceMatchRequestsResponseParamsForwardToCallback(callback));

        }


        @Override
        public void addRegistrationObserver(
BackgroundFetchRegistrationObserver observer) {

            BackgroundFetchRegistrationServiceAddRegistrationObserverParams _message = new BackgroundFetchRegistrationServiceAddRegistrationObserverParams();

            _message.observer = observer;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ADD_REGISTRATION_OBSERVER_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<BackgroundFetchRegistrationService> {

        Stub(com.vccorp.mojo.system.Core core, BackgroundFetchRegistrationService impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                BackgroundFetchRegistrationService_Internal.MANAGER, messageWithHeader);











                    case ADD_REGISTRATION_OBSERVER_ORDINAL: {

                        BackgroundFetchRegistrationServiceAddRegistrationObserverParams data =
                                BackgroundFetchRegistrationServiceAddRegistrationObserverParams.deserialize(messageWithHeader.getPayload());

                        getImpl().addRegistrationObserver(data.observer);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), BackgroundFetchRegistrationService_Internal.MANAGER, messageWithHeader, receiver);







                    case UPDATE_UI_ORDINAL: {

                        BackgroundFetchRegistrationServiceUpdateUiParams data =
                                BackgroundFetchRegistrationServiceUpdateUiParams.deserialize(messageWithHeader.getPayload());

                        getImpl().updateUi(data.title, data.icon, new BackgroundFetchRegistrationServiceUpdateUiResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case ABORT_ORDINAL: {

                        BackgroundFetchRegistrationServiceAbortParams.deserialize(messageWithHeader.getPayload());

                        getImpl().abort(new BackgroundFetchRegistrationServiceAbortResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case MATCH_REQUESTS_ORDINAL: {

                        BackgroundFetchRegistrationServiceMatchRequestsParams data =
                                BackgroundFetchRegistrationServiceMatchRequestsParams.deserialize(messageWithHeader.getPayload());

                        getImpl().matchRequests(data.requestToMatch, data.cacheQueryOptions, data.matchAll, new BackgroundFetchRegistrationServiceMatchRequestsResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }




                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class BackgroundFetchRegistrationServiceUpdateUiParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String title;
        public com.vccorp.skia.mojom.Bitmap icon;

        private BackgroundFetchRegistrationServiceUpdateUiParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public BackgroundFetchRegistrationServiceUpdateUiParams() {
            this(0);
        }

        public static BackgroundFetchRegistrationServiceUpdateUiParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static BackgroundFetchRegistrationServiceUpdateUiParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static BackgroundFetchRegistrationServiceUpdateUiParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            BackgroundFetchRegistrationServiceUpdateUiParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new BackgroundFetchRegistrationServiceUpdateUiParams(elementsOrVersion);
                    {
                        
                    result.title = decoder0.readString(8, true);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, true);
                    result.icon = com.vccorp.skia.mojom.Bitmap.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.title, 8, true);
            
            encoder0.encode(this.icon, 16, true);
        }
    }



    
    static final class BackgroundFetchRegistrationServiceUpdateUiResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int error;

        private BackgroundFetchRegistrationServiceUpdateUiResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public BackgroundFetchRegistrationServiceUpdateUiResponseParams() {
            this(0);
        }

        public static BackgroundFetchRegistrationServiceUpdateUiResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static BackgroundFetchRegistrationServiceUpdateUiResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static BackgroundFetchRegistrationServiceUpdateUiResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            BackgroundFetchRegistrationServiceUpdateUiResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new BackgroundFetchRegistrationServiceUpdateUiResponseParams(elementsOrVersion);
                    {
                        
                    result.error = decoder0.readInt(8);
                        BackgroundFetchError.validate(result.error);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.error, 8);
        }
    }

    static class BackgroundFetchRegistrationServiceUpdateUiResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final BackgroundFetchRegistrationService.UpdateUiResponse mCallback;

        BackgroundFetchRegistrationServiceUpdateUiResponseParamsForwardToCallback(BackgroundFetchRegistrationService.UpdateUiResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(UPDATE_UI_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                BackgroundFetchRegistrationServiceUpdateUiResponseParams response = BackgroundFetchRegistrationServiceUpdateUiResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.error);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class BackgroundFetchRegistrationServiceUpdateUiResponseParamsProxyToResponder implements BackgroundFetchRegistrationService.UpdateUiResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        BackgroundFetchRegistrationServiceUpdateUiResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer error) {
            BackgroundFetchRegistrationServiceUpdateUiResponseParams _response = new BackgroundFetchRegistrationServiceUpdateUiResponseParams();

            _response.error = error;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    UPDATE_UI_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class BackgroundFetchRegistrationServiceAbortParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private BackgroundFetchRegistrationServiceAbortParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public BackgroundFetchRegistrationServiceAbortParams() {
            this(0);
        }

        public static BackgroundFetchRegistrationServiceAbortParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static BackgroundFetchRegistrationServiceAbortParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static BackgroundFetchRegistrationServiceAbortParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            BackgroundFetchRegistrationServiceAbortParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new BackgroundFetchRegistrationServiceAbortParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class BackgroundFetchRegistrationServiceAbortResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int error;

        private BackgroundFetchRegistrationServiceAbortResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public BackgroundFetchRegistrationServiceAbortResponseParams() {
            this(0);
        }

        public static BackgroundFetchRegistrationServiceAbortResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static BackgroundFetchRegistrationServiceAbortResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static BackgroundFetchRegistrationServiceAbortResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            BackgroundFetchRegistrationServiceAbortResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new BackgroundFetchRegistrationServiceAbortResponseParams(elementsOrVersion);
                    {
                        
                    result.error = decoder0.readInt(8);
                        BackgroundFetchError.validate(result.error);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.error, 8);
        }
    }

    static class BackgroundFetchRegistrationServiceAbortResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final BackgroundFetchRegistrationService.AbortResponse mCallback;

        BackgroundFetchRegistrationServiceAbortResponseParamsForwardToCallback(BackgroundFetchRegistrationService.AbortResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(ABORT_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                BackgroundFetchRegistrationServiceAbortResponseParams response = BackgroundFetchRegistrationServiceAbortResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.error);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class BackgroundFetchRegistrationServiceAbortResponseParamsProxyToResponder implements BackgroundFetchRegistrationService.AbortResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        BackgroundFetchRegistrationServiceAbortResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer error) {
            BackgroundFetchRegistrationServiceAbortResponseParams _response = new BackgroundFetchRegistrationServiceAbortResponseParams();

            _response.error = error;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    ABORT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class BackgroundFetchRegistrationServiceMatchRequestsParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 32;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(32, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public FetchApiRequest requestToMatch;
        public CacheQueryOptions cacheQueryOptions;
        public boolean matchAll;

        private BackgroundFetchRegistrationServiceMatchRequestsParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public BackgroundFetchRegistrationServiceMatchRequestsParams() {
            this(0);
        }

        public static BackgroundFetchRegistrationServiceMatchRequestsParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static BackgroundFetchRegistrationServiceMatchRequestsParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static BackgroundFetchRegistrationServiceMatchRequestsParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            BackgroundFetchRegistrationServiceMatchRequestsParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new BackgroundFetchRegistrationServiceMatchRequestsParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, true);
                    result.requestToMatch = FetchApiRequest.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, true);
                    result.cacheQueryOptions = CacheQueryOptions.decode(decoder1);
                    }
                    {
                        
                    result.matchAll = decoder0.readBoolean(24, 0);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.requestToMatch, 8, true);
            
            encoder0.encode(this.cacheQueryOptions, 16, true);
            
            encoder0.encode(this.matchAll, 24, 0);
        }
    }



    
    static final class BackgroundFetchRegistrationServiceMatchRequestsResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public BackgroundFetchSettledFetch[] fetches;

        private BackgroundFetchRegistrationServiceMatchRequestsResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public BackgroundFetchRegistrationServiceMatchRequestsResponseParams() {
            this(0);
        }

        public static BackgroundFetchRegistrationServiceMatchRequestsResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static BackgroundFetchRegistrationServiceMatchRequestsResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static BackgroundFetchRegistrationServiceMatchRequestsResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            BackgroundFetchRegistrationServiceMatchRequestsResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new BackgroundFetchRegistrationServiceMatchRequestsResponseParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    {
                        com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        result.fetches = new BackgroundFetchSettledFetch[si1.elementsOrVersion];
                        for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                            
                            com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                            result.fetches[i1] = BackgroundFetchSettledFetch.decode(decoder2);
                        }
                    }
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            if (this.fetches == null) {
                encoder0.encodeNullPointer(8, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.fetches.length, 8, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < this.fetches.length; ++i0) {
                    
                    encoder1.encode(this.fetches[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
        }
    }

    static class BackgroundFetchRegistrationServiceMatchRequestsResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final BackgroundFetchRegistrationService.MatchRequestsResponse mCallback;

        BackgroundFetchRegistrationServiceMatchRequestsResponseParamsForwardToCallback(BackgroundFetchRegistrationService.MatchRequestsResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(MATCH_REQUESTS_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                BackgroundFetchRegistrationServiceMatchRequestsResponseParams response = BackgroundFetchRegistrationServiceMatchRequestsResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.fetches);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class BackgroundFetchRegistrationServiceMatchRequestsResponseParamsProxyToResponder implements BackgroundFetchRegistrationService.MatchRequestsResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        BackgroundFetchRegistrationServiceMatchRequestsResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(BackgroundFetchSettledFetch[] fetches) {
            BackgroundFetchRegistrationServiceMatchRequestsResponseParams _response = new BackgroundFetchRegistrationServiceMatchRequestsResponseParams();

            _response.fetches = fetches;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    MATCH_REQUESTS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class BackgroundFetchRegistrationServiceAddRegistrationObserverParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public BackgroundFetchRegistrationObserver observer;

        private BackgroundFetchRegistrationServiceAddRegistrationObserverParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public BackgroundFetchRegistrationServiceAddRegistrationObserverParams() {
            this(0);
        }

        public static BackgroundFetchRegistrationServiceAddRegistrationObserverParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static BackgroundFetchRegistrationServiceAddRegistrationObserverParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static BackgroundFetchRegistrationServiceAddRegistrationObserverParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            BackgroundFetchRegistrationServiceAddRegistrationObserverParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new BackgroundFetchRegistrationServiceAddRegistrationObserverParams(elementsOrVersion);
                    {
                        
                    result.observer = decoder0.readServiceInterface(8, false, BackgroundFetchRegistrationObserver.MANAGER);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.observer, 8, false, BackgroundFetchRegistrationObserver.MANAGER);
        }
    }



}
