
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/webauthn/authenticator.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;

public final class AuthenticatorStatus {
    private static final boolean IS_EXTENSIBLE = false;

    public static final int SUCCESS = 0;
    public static final int PENDING_REQUEST = 1; // SUCCESS + 1
    public static final int NOT_ALLOWED_ERROR = 2; // PENDING_REQUEST + 1
    public static final int INVALID_DOMAIN = 3; // NOT_ALLOWED_ERROR + 1
    public static final int CREDENTIAL_EXCLUDED = 4; // INVALID_DOMAIN + 1
    public static final int CREDENTIAL_NOT_RECOGNIZED = 5; // CREDENTIAL_EXCLUDED + 1
    public static final int NOT_IMPLEMENTED = 6; // CREDENTIAL_NOT_RECOGNIZED + 1
    public static final int NOT_FOCUSED = 7; // NOT_IMPLEMENTED + 1
    public static final int RESIDENT_CREDENTIALS_UNSUPPORTED = 8; // NOT_FOCUSED + 1
    public static final int USER_VERIFICATION_UNSUPPORTED = 9; // RESIDENT_CREDENTIALS_UNSUPPORTED + 1
    public static final int ALGORITHM_UNSUPPORTED = 10; // USER_VERIFICATION_UNSUPPORTED + 1
    public static final int EMPTY_ALLOW_CREDENTIALS = 11; // ALGORITHM_UNSUPPORTED + 1
    public static final int ANDROID_NOT_SUPPORTED_ERROR = 12; // EMPTY_ALLOW_CREDENTIALS + 1
    public static final int UNKNOWN_ERROR = 13; // ANDROID_NOT_SUPPORTED_ERROR + 1

    public static boolean isKnownValue(int value) {
        return value >= 0 && value <= 13;
    }

    public static void validate(int value) {
        if (IS_EXTENSIBLE || isKnownValue(value)) return;
        throw new DeserializationException("Invalid enum value.");
    }

    private AuthenticatorStatus() {}
}