
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/appcache/appcache.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class AppCacheResourceInfo extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 48;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(48, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public com.vccorp.url.mojom.Url url;
    public long responseSize;
    public long paddingSize;
    public boolean isMaster;
    public boolean isManifest;
    public boolean isIntercept;
    public boolean isFallback;
    public boolean isForeign;
    public boolean isExplicit;
    public long responseId;

    private AppCacheResourceInfo(int version) {
        super(STRUCT_SIZE, version);
    }

    public AppCacheResourceInfo() {
        this(0);
    }

    public static AppCacheResourceInfo deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static AppCacheResourceInfo deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static AppCacheResourceInfo decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        AppCacheResourceInfo result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new AppCacheResourceInfo(elementsOrVersion);
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                result.url = com.vccorp.url.mojom.Url.decode(decoder1);
                }
                {
                    
                result.responseSize = decoder0.readLong(16);
                }
                {
                    
                result.paddingSize = decoder0.readLong(24);
                }
                {
                    
                result.isMaster = decoder0.readBoolean(32, 0);
                }
                {
                    
                result.isManifest = decoder0.readBoolean(32, 1);
                }
                {
                    
                result.isIntercept = decoder0.readBoolean(32, 2);
                }
                {
                    
                result.isFallback = decoder0.readBoolean(32, 3);
                }
                {
                    
                result.isForeign = decoder0.readBoolean(32, 4);
                }
                {
                    
                result.isExplicit = decoder0.readBoolean(32, 5);
                }
                {
                    
                result.responseId = decoder0.readLong(40);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.url, 8, false);
        
        encoder0.encode(this.responseSize, 16);
        
        encoder0.encode(this.paddingSize, 24);
        
        encoder0.encode(this.isMaster, 32, 0);
        
        encoder0.encode(this.isManifest, 32, 1);
        
        encoder0.encode(this.isIntercept, 32, 2);
        
        encoder0.encode(this.isFallback, 32, 3);
        
        encoder0.encode(this.isForeign, 32, 4);
        
        encoder0.encode(this.isExplicit, 32, 5);
        
        encoder0.encode(this.responseId, 40);
    }
}