package com.vcc.livetools;

import android.os.Handler;
import android.os.HandlerThread;
import android.text.TextUtils;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

public class LiveTools {

    static native String getLiveViewer(String params, boolean isVideoId);

    /**
     * Get live stream viewer number by video id
     *
     * @param videoId is one a string define for video, get from ovp of sohatv
     * @return -1 if request viewer number error, otherwise return  viewer number of live stream
     */
    public static int getLiveViewerByVideoId(String videoId) {
        String response = getLiveViewer(videoId, true);
        if (TextUtils.isEmpty(response))
            return -1;
        JSONUtilParser parser = new JSONUtilParser();
        JSONObject ccuData = parser.getJSONObject(response);
        if (ccuData == null)
            return -1;
        return parser.getInteger("ccu", ccuData);
    }

    /**
     * Get live stream viewer number by video id
     *
     * @param url is url of video, get from ovp of sohatv
     * @return -1 if request viewer number error, otherwise return  viewer number of live stream
     */

    public static int getLiveViewerByUrl(String url) {
        String response = getLiveViewer(url, false);
        if (TextUtils.isEmpty(response))
            return -1;
        JSONUtilParser parser = new JSONUtilParser();
        JSONObject ccuData = parser.getJSONObject(response);
        if (ccuData == null)
            return -1;
        return parser.getInteger("ccu", ccuData);
    }

    /**
     * Created by PC0353 on 7/21/2016.
     */
    private static class JSONUtilParser {

        String getString(String name, JSONObject obj) {
            try {
                return obj.getString(name);
            } catch (Exception ex) {
                return "";
            }
        }

        int getInteger(String name, JSONObject obj) {
            try {
                return obj.getInt(name);
            } catch (Exception ex) {
                return -1;
            }
        }

        JSONObject getJSONObject(String name, JSONObject obj) {
            try {
                return obj.getJSONObject(name);
            } catch (Exception ex) {
                return null;
            }
        }

        JSONArray getJSONArray(String name, JSONObject obj) {
            try {
                return obj.getJSONArray(name);
            } catch (Exception ex) {
                return null;
            }
        }

        JSONObject getJSONObject(String data) {
            try {
                return new JSONObject(data);
            } catch (Exception ex) {
                return null;
            }
        }

        Object getObject(String name, JSONObject obj) {
            try {
                return obj.get(name);
            } catch (Exception ex) {
                return null;
            }
        }
    }
}
