/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.execchain;

import java.io.IOException;
import java.util.Locale;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.impl.execchain.ConnectionHolder;
import org.apache.http.impl.execchain.ResponseEntityProxy;
import org.apache.http.params.HttpParams;

@NotThreadSafe
class HttpResponseProxy
implements CloseableHttpResponse {
    private final HttpResponse original;
    private final ConnectionHolder connHolder;

    public HttpResponseProxy(HttpResponse httpResponse, ConnectionHolder connectionHolder) {
        this.original = httpResponse;
        this.connHolder = connectionHolder;
        ResponseEntityProxy.enchance(httpResponse, connectionHolder);
    }

    @Override
    public void close() throws IOException {
        if (this.connHolder != null) {
            this.connHolder.close();
        }
    }

    public StatusLine getStatusLine() {
        return this.original.getStatusLine();
    }

    public void setStatusLine(StatusLine statusLine) {
        this.original.setStatusLine(statusLine);
    }

    public void setStatusLine(ProtocolVersion protocolVersion, int n) {
        this.original.setStatusLine(protocolVersion, n);
    }

    public void setStatusLine(ProtocolVersion protocolVersion, int n, String string) {
        this.original.setStatusLine(protocolVersion, n, string);
    }

    public void setStatusCode(int n) throws IllegalStateException {
        this.original.setStatusCode(n);
    }

    public void setReasonPhrase(String string) throws IllegalStateException {
        this.original.setReasonPhrase(string);
    }

    public HttpEntity getEntity() {
        return this.original.getEntity();
    }

    public void setEntity(HttpEntity httpEntity) {
        this.original.setEntity(httpEntity);
    }

    public Locale getLocale() {
        return this.original.getLocale();
    }

    public void setLocale(Locale locale) {
        this.original.setLocale(locale);
    }

    public ProtocolVersion getProtocolVersion() {
        return this.original.getProtocolVersion();
    }

    public boolean containsHeader(String string) {
        return this.original.containsHeader(string);
    }

    public Header[] getHeaders(String string) {
        return this.original.getHeaders(string);
    }

    public Header getFirstHeader(String string) {
        return this.original.getFirstHeader(string);
    }

    public Header getLastHeader(String string) {
        return this.original.getLastHeader(string);
    }

    public Header[] getAllHeaders() {
        return this.original.getAllHeaders();
    }

    public void addHeader(Header header) {
        this.original.addHeader(header);
    }

    public void addHeader(String string, String string2) {
        this.original.addHeader(string, string2);
    }

    public void setHeader(Header header) {
        this.original.setHeader(header);
    }

    public void setHeader(String string, String string2) {
        this.original.setHeader(string, string2);
    }

    public void setHeaders(Header[] headerArray) {
        this.original.setHeaders(headerArray);
    }

    public void removeHeader(Header header) {
        this.original.removeHeader(header);
    }

    public void removeHeaders(String string) {
        this.original.removeHeaders(string);
    }

    public HeaderIterator headerIterator() {
        return this.original.headerIterator();
    }

    public HeaderIterator headerIterator(String string) {
        return this.original.headerIterator(string);
    }

    @Deprecated
    public HttpParams getParams() {
        return this.original.getParams();
    }

    @Deprecated
    public void setParams(HttpParams httpParams) {
        this.original.setParams(httpParams);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("HttpResponseProxy{");
        stringBuilder.append(this.original);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

