/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.io.IOException;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.http.HttpClientConnection;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.conn.ManagedHttpClientConnection;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.pool.PoolEntry;

@ThreadSafe
class CPoolEntry
extends PoolEntry<HttpRoute, ManagedHttpClientConnection> {
    private final Log log;
    private volatile boolean routeComplete;

    public CPoolEntry(Log log, String string, HttpRoute httpRoute, ManagedHttpClientConnection managedHttpClientConnection, long l, TimeUnit timeUnit) {
        super(string, (Object)httpRoute, (Object)managedHttpClientConnection, l, timeUnit);
        this.log = log;
    }

    public void markRouteComplete() {
        this.routeComplete = true;
    }

    public boolean isRouteComplete() {
        return this.routeComplete;
    }

    public void closeConnection() throws IOException {
        HttpClientConnection httpClientConnection = (HttpClientConnection)this.getConnection();
        httpClientConnection.close();
    }

    public void shutdownConnection() throws IOException {
        HttpClientConnection httpClientConnection = (HttpClientConnection)this.getConnection();
        httpClientConnection.shutdown();
    }

    public boolean isExpired(long l) {
        boolean bl = super.isExpired(l);
        if (bl && this.log.isDebugEnabled()) {
            this.log.debug((Object)("Connection " + (Object)((Object)this) + " expired @ " + new Date(this.getExpiry())));
        }
        return bl;
    }

    public boolean isClosed() {
        HttpClientConnection httpClientConnection = (HttpClientConnection)this.getConnection();
        return !httpClientConnection.isOpen();
    }

    public void close() {
        try {
            this.closeConnection();
        }
        catch (IOException iOException) {
            this.log.debug((Object)"I/O error closing connection", (Throwable)iOException);
        }
    }
}

