/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.libraries.mediaframework.exoplayerextensions;

import android.content.Context;
import android.net.Uri;
import com.google.android.exoplayer.MediaCodecAudioTrackRenderer;
import com.google.android.exoplayer.MediaCodecSelector;
import com.google.android.exoplayer.MediaCodecVideoTrackRenderer;
import com.google.android.exoplayer.SampleSource;
import com.google.android.exoplayer.TrackRenderer;
import com.google.android.exoplayer.audio.AudioCapabilities;
import com.google.android.exoplayer.extractor.Extractor;
import com.google.android.exoplayer.extractor.ExtractorSampleSource;
import com.google.android.exoplayer.text.SubtitleParser;
import com.google.android.exoplayer.text.TextRenderer;
import com.google.android.exoplayer.text.TextTrackRenderer;
import com.google.android.exoplayer.upstream.Allocator;
import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DefaultAllocator;
import com.google.android.exoplayer.upstream.DefaultBandwidthMeter;
import com.google.android.exoplayer.upstream.DefaultUriDataSource;
import com.google.android.exoplayer.upstream.TransferListener;
import com.google.android.libraries.mediaframework.exoplayerextensions.ExoplayerWrapper;

public class ExtractorRendererBuilder
implements ExoplayerWrapper.RendererBuilder {
    private static final int BUFFER_SEGMENT_SIZE = 65536;
    private static final int BUFFER_SEGMENT_COUNT = 256;
    private final Context context;
    private final String userAgent;
    private final Uri uri;
    private boolean fixedContent = false;

    public ExtractorRendererBuilder(Context context, String string, Uri uri, boolean bl) {
        this.context = context;
        this.userAgent = string;
        this.uri = uri;
    }

    @Override
    public void buildRenderers(ExoplayerWrapper exoplayerWrapper) {
        DefaultAllocator defaultAllocator = new DefaultAllocator(65536);
        DefaultBandwidthMeter defaultBandwidthMeter = new DefaultBandwidthMeter(exoplayerWrapper.getMainHandler(), null);
        DefaultUriDataSource defaultUriDataSource = new DefaultUriDataSource(this.context, (TransferListener)defaultBandwidthMeter, this.userAgent);
        ExtractorSampleSource extractorSampleSource = new ExtractorSampleSource(this.uri, (DataSource)defaultUriDataSource, (Allocator)defaultAllocator, 0x1000000, new Extractor[0]);
        MediaCodecVideoTrackRenderer mediaCodecVideoTrackRenderer = this.fixedContent ? new MediaCodecVideoTrackRenderer(this.context, (SampleSource)extractorSampleSource, MediaCodecSelector.DEFAULT, 2, 5000L, exoplayerWrapper.getMainHandler(), exoplayerWrapper, 50) : new MediaCodecVideoTrackRenderer(this.context, (SampleSource)extractorSampleSource, MediaCodecSelector.DEFAULT, 1, 5000L, exoplayerWrapper.getMainHandler(), exoplayerWrapper, 50);
        MediaCodecAudioTrackRenderer mediaCodecAudioTrackRenderer = new MediaCodecAudioTrackRenderer((SampleSource)extractorSampleSource, MediaCodecSelector.DEFAULT, null, true, exoplayerWrapper.getMainHandler(), (MediaCodecAudioTrackRenderer.EventListener)exoplayerWrapper, AudioCapabilities.getCapabilities(this.context), 3);
        TextTrackRenderer textTrackRenderer = new TextTrackRenderer((SampleSource)extractorSampleSource, (TextRenderer)exoplayerWrapper, exoplayerWrapper.getMainHandler().getLooper(), new SubtitleParser[0]);
        TrackRenderer[] trackRendererArray = new TrackRenderer[5];
        trackRendererArray[0] = mediaCodecVideoTrackRenderer;
        trackRendererArray[1] = mediaCodecAudioTrackRenderer;
        trackRendererArray[2] = textTrackRenderer;
        exoplayerWrapper.onRenderers(trackRendererArray, defaultBandwidthMeter);
    }

    @Override
    public void cancel() {
    }
}

