/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.libraries.mediaframework.exoplayerextensions;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.UUID;

public class ExoplayerUtil {
    public static final UUID WIDEVINE_UUID = new UUID(-1301668207276963122L, -6645017420763422227L);

    public static String getUserAgent(Context context) {
        String string;
        try {
            String string2 = context.getPackageName();
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(string2, 0);
            string = packageInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            string = "?";
        }
        return "ExoPlayerDemo/" + string + " (Linux;Android " + Build.VERSION.RELEASE + ") ExoPlayerLib/" + "1.5.7";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] executePost(String string, byte[] byArray, Map<String, String> map) throws MalformedURLException, IOException {
        HttpURLConnection httpURLConnection = null;
        try {
            Object object;
            httpURLConnection = (HttpURLConnection)new URL(string).openConnection();
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setDoOutput(byArray != null);
            httpURLConnection.setDoInput(true);
            if (map != null) {
                for (Map.Entry<String, String> object22 : map.entrySet()) {
                    httpURLConnection.setRequestProperty(object22.getKey(), object22.getValue());
                }
            }
            if (byArray != null) {
                object = new BufferedOutputStream(httpURLConnection.getOutputStream());
                ((OutputStream)object).write(byArray);
                ((OutputStream)object).close();
            }
            object = new BufferedInputStream(httpURLConnection.getInputStream());
            byte[] byArray2 = ExoplayerUtil.convertInputStreamToByteArray((InputStream)object);
            return byArray2;
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    private static byte[] convertInputStreamToByteArray(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray2 = new byte[1024];
        while ((n = inputStream.read(byArray2)) != -1) {
            byteArrayOutputStream.write(byArray2, 0, n);
        }
        byteArrayOutputStream.flush();
        byteArrayOutputStream.close();
        inputStream.close();
        byArray = byteArrayOutputStream.toByteArray();
        return byArray;
    }
}

