/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.libraries.mediaframework.exoplayerextensions;

import android.content.Context;
import android.os.Handler;
import com.google.android.exoplayer.DefaultLoadControl;
import com.google.android.exoplayer.MediaCodecAudioTrackRenderer;
import com.google.android.exoplayer.MediaCodecSelector;
import com.google.android.exoplayer.MediaCodecVideoTrackRenderer;
import com.google.android.exoplayer.SampleSource;
import com.google.android.exoplayer.TrackRenderer;
import com.google.android.exoplayer.audio.AudioCapabilities;
import com.google.android.exoplayer.chunk.ChunkSampleSource;
import com.google.android.exoplayer.chunk.FormatEvaluator;
import com.google.android.exoplayer.dash.DashChunkSource;
import com.google.android.exoplayer.dash.DefaultDashTrackSelector;
import com.google.android.exoplayer.dash.mpd.AdaptationSet;
import com.google.android.exoplayer.dash.mpd.MediaPresentationDescription;
import com.google.android.exoplayer.dash.mpd.MediaPresentationDescriptionParser;
import com.google.android.exoplayer.dash.mpd.Period;
import com.google.android.exoplayer.dash.mpd.UtcTimingElement;
import com.google.android.exoplayer.dash.mpd.UtcTimingElementResolver;
import com.google.android.exoplayer.drm.DrmSessionManager;
import com.google.android.exoplayer.drm.MediaDrmCallback;
import com.google.android.exoplayer.drm.StreamingDrmSessionManager;
import com.google.android.exoplayer.drm.UnsupportedDrmException;
import com.google.android.exoplayer.text.SubtitleParser;
import com.google.android.exoplayer.text.TextRenderer;
import com.google.android.exoplayer.text.TextTrackRenderer;
import com.google.android.exoplayer.upstream.DefaultAllocator;
import com.google.android.exoplayer.upstream.DefaultBandwidthMeter;
import com.google.android.exoplayer.upstream.DefaultUriDataSource;
import com.google.android.exoplayer.upstream.TransferListener;
import com.google.android.exoplayer.upstream.UriDataSource;
import com.google.android.exoplayer.util.ManifestFetcher;
import com.google.android.exoplayer.util.Util;
import com.google.android.libraries.mediaframework.exoplayerextensions.ExoplayerWrapper;
import com.vcc.playerwrappersdk.a;
import java.io.IOException;

public class DashRendererBuilder
implements ExoplayerWrapper.RendererBuilder {
    private static final String TAG = "DashRendererBuilder";
    private static final int BUFFER_SEGMENT_SIZE = 65536;
    private static final int VIDEO_BUFFER_SEGMENTS = 200;
    private static final int AUDIO_BUFFER_SEGMENTS = 54;
    private static final int TEXT_BUFFER_SEGMENTS = 2;
    private static final int LIVE_EDGE_LATENCY_MS = 30000;
    private static final int SECURITY_LEVEL_UNKNOWN = -1;
    private static final int SECURITY_LEVEL_1 = 1;
    private static final int SECURITY_LEVEL_3 = 3;
    private final Context context;
    private final String userAgent;
    private final String url;
    private final MediaDrmCallback drmCallback;
    private boolean fixedContent = false;
    private AsyncRendererBuilder currentAsyncBuilder;

    public DashRendererBuilder(Context context, String string, String string2, MediaDrmCallback mediaDrmCallback, boolean bl) {
        this.context = context;
        this.userAgent = string;
        this.url = string2;
        this.drmCallback = mediaDrmCallback;
    }

    @Override
    public void buildRenderers(ExoplayerWrapper exoplayerWrapper) {
        this.currentAsyncBuilder = new AsyncRendererBuilder(this.context, this.userAgent, this.url, this.drmCallback, exoplayerWrapper, this.fixedContent);
        this.currentAsyncBuilder.init();
    }

    @Override
    public void cancel() {
        if (this.currentAsyncBuilder != null) {
            this.currentAsyncBuilder.cancel();
            this.currentAsyncBuilder = null;
        }
    }

    private static final class AsyncRendererBuilder
    implements UtcTimingElementResolver.UtcTimingCallback,
    ManifestFetcher.ManifestCallback<MediaPresentationDescription> {
        private final Context context;
        private final String userAgent;
        private final MediaDrmCallback drmCallback;
        private final ExoplayerWrapper player;
        private final ManifestFetcher<MediaPresentationDescription> manifestFetcher;
        private final UriDataSource manifestDataSource;
        private boolean fixedContent = false;
        private boolean canceled;
        private MediaPresentationDescription manifest;
        private long elapsedRealtimeOffset;

        public AsyncRendererBuilder(Context context, String string, String string2, MediaDrmCallback mediaDrmCallback, ExoplayerWrapper exoplayerWrapper, boolean bl) {
            this.context = context;
            this.userAgent = string;
            this.drmCallback = mediaDrmCallback;
            this.player = exoplayerWrapper;
            MediaPresentationDescriptionParser mediaPresentationDescriptionParser = new MediaPresentationDescriptionParser();
            this.manifestDataSource = new DefaultUriDataSource(context, string);
            this.manifestFetcher = new ManifestFetcher<MediaPresentationDescription>(string2, this.manifestDataSource, mediaPresentationDescriptionParser);
        }

        public void init() {
            this.manifestFetcher.singleLoad(this.player.getMainHandler().getLooper(), this);
        }

        public void cancel() {
            this.canceled = true;
        }

        @Override
        public void onSingleManifest(MediaPresentationDescription mediaPresentationDescription) {
            if (this.canceled) {
                return;
            }
            this.manifest = mediaPresentationDescription;
            if (mediaPresentationDescription.dynamic && mediaPresentationDescription.utcTiming != null) {
                UtcTimingElementResolver.resolveTimingElement(this.manifestDataSource, mediaPresentationDescription.utcTiming, this.manifestFetcher.getManifestLoadCompleteTimestamp(), this);
            } else {
                this.buildRenderers();
            }
        }

        @Override
        public void onSingleManifestError(IOException iOException) {
            if (this.canceled) {
                return;
            }
            this.player.onRenderersError(iOException);
        }

        @Override
        public void onTimestampResolved(UtcTimingElement utcTimingElement, long l) {
            if (this.canceled) {
                return;
            }
            this.elapsedRealtimeOffset = l;
            this.buildRenderers();
        }

        @Override
        public void onTimestampError(UtcTimingElement utcTimingElement, IOException iOException) {
            if (this.canceled) {
                return;
            }
            a.b(DashRendererBuilder.TAG, "Failed to resolve UtcTiming element [" + utcTimingElement + "]", iOException);
            this.buildRenderers();
        }

        private void buildRenderers() {
            Object object;
            int n;
            Period period = this.manifest.getPeriod(0);
            Handler handler = this.player.getMainHandler();
            DefaultLoadControl defaultLoadControl = new DefaultLoadControl(new DefaultAllocator(65536));
            DefaultBandwidthMeter defaultBandwidthMeter = new DefaultBandwidthMeter(handler, this.player);
            boolean bl = false;
            for (n = 0; n < period.adaptationSets.size(); n += 1) {
                object = period.adaptationSets.get(n);
                if (((AdaptationSet)object).type == -1) continue;
                bl |= ((AdaptationSet)object).hasContentProtection();
            }
            n = 0;
            object = null;
            if (bl) {
                if (Util.SDK_INT < 18) {
                    this.player.onRenderersError(new UnsupportedDrmException(1));
                    return;
                }
                try {
                    object = StreamingDrmSessionManager.newWidevineInstance(this.player.getPlaybackLooper(), this.drmCallback, null, this.player.getMainHandler(), this.player);
                    n = AsyncRendererBuilder.getWidevineSecurityLevel((StreamingDrmSessionManager)object) != 1 ? 1 : 0;
                }
                catch (UnsupportedDrmException unsupportedDrmException) {
                    this.player.onRenderersError(unsupportedDrmException);
                    return;
                }
            }
            DefaultUriDataSource defaultUriDataSource = new DefaultUriDataSource(this.context, (TransferListener)defaultBandwidthMeter, this.userAgent);
            DashChunkSource dashChunkSource = new DashChunkSource(this.manifestFetcher, DefaultDashTrackSelector.newVideoInstance(this.context, true, n != 0), defaultUriDataSource, new FormatEvaluator.AdaptiveEvaluator(defaultBandwidthMeter), 30000L, this.elapsedRealtimeOffset, handler, this.player, 0);
            ChunkSampleSource chunkSampleSource = new ChunkSampleSource(dashChunkSource, defaultLoadControl, 0xC80000, handler, this.player, 0);
            MediaCodecVideoTrackRenderer mediaCodecVideoTrackRenderer = this.fixedContent ? new MediaCodecVideoTrackRenderer(this.context, (SampleSource)chunkSampleSource, MediaCodecSelector.DEFAULT, 2, 5000L, (DrmSessionManager)object, true, handler, this.player, 50) : new MediaCodecVideoTrackRenderer(this.context, (SampleSource)chunkSampleSource, MediaCodecSelector.DEFAULT, 1, 5000L, (DrmSessionManager)object, true, handler, this.player, 50);
            DefaultUriDataSource defaultUriDataSource2 = new DefaultUriDataSource(this.context, (TransferListener)defaultBandwidthMeter, this.userAgent);
            DashChunkSource dashChunkSource2 = new DashChunkSource(this.manifestFetcher, DefaultDashTrackSelector.newAudioInstance(), defaultUriDataSource2, null, 30000L, this.elapsedRealtimeOffset, handler, this.player, 1);
            ChunkSampleSource chunkSampleSource2 = new ChunkSampleSource(dashChunkSource2, defaultLoadControl, 0x360000, handler, this.player, 1);
            MediaCodecAudioTrackRenderer mediaCodecAudioTrackRenderer = new MediaCodecAudioTrackRenderer((SampleSource)chunkSampleSource2, MediaCodecSelector.DEFAULT, (DrmSessionManager)object, true, handler, (MediaCodecAudioTrackRenderer.EventListener)this.player, AudioCapabilities.getCapabilities(this.context), 3);
            DefaultUriDataSource defaultUriDataSource3 = new DefaultUriDataSource(this.context, (TransferListener)defaultBandwidthMeter, this.userAgent);
            DashChunkSource dashChunkSource3 = new DashChunkSource(this.manifestFetcher, DefaultDashTrackSelector.newTextInstance(), defaultUriDataSource3, null, 30000L, this.elapsedRealtimeOffset, handler, this.player, 2);
            ChunkSampleSource chunkSampleSource3 = new ChunkSampleSource(dashChunkSource3, defaultLoadControl, 131072, handler, this.player, 2);
            TextTrackRenderer textTrackRenderer = new TextTrackRenderer((SampleSource)chunkSampleSource3, (TextRenderer)this.player, handler.getLooper(), new SubtitleParser[0]);
            TrackRenderer[] trackRendererArray = new TrackRenderer[5];
            trackRendererArray[0] = mediaCodecVideoTrackRenderer;
            trackRendererArray[1] = mediaCodecAudioTrackRenderer;
            trackRendererArray[2] = textTrackRenderer;
            this.player.onRenderers(trackRendererArray, defaultBandwidthMeter);
        }

        private static int getWidevineSecurityLevel(StreamingDrmSessionManager streamingDrmSessionManager) {
            String string = streamingDrmSessionManager.getPropertyString("securityLevel");
            return string.equals("L1") ? 1 : (string.equals("L3") ? 3 : -1);
        }
    }
}

