/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.upstream;

import android.net.Uri;
import com.google.android.exoplayer.util.Assertions;
import java.util.Arrays;

public final class DataSpec {
    public static final int FLAG_ALLOW_GZIP = 1;
    public final Uri uri;
    public final byte[] postBody;
    public final long absoluteStreamPosition;
    public final long position;
    public final long length;
    public final String key;
    public final int flags;

    public DataSpec(Uri uri) {
        this(uri, 0);
    }

    public DataSpec(Uri uri, int n) {
        this(uri, 0L, -1L, null, n);
    }

    public DataSpec(Uri uri, long l, long l2, String string) {
        this(uri, l, l, l2, string, 0);
    }

    public DataSpec(Uri uri, long l, long l2, String string, int n) {
        this(uri, l, l, l2, string, n);
    }

    public DataSpec(Uri uri, long l, long l2, long l3, String string, int n) {
        this(uri, null, l, l2, l3, string, n);
    }

    public DataSpec(Uri uri, byte[] byArray, long l, long l2, long l3, String string, int n) {
        Assertions.checkArgument(l >= 0L);
        Assertions.checkArgument(l2 >= 0L);
        Assertions.checkArgument(l3 > 0L || l3 == -1L);
        this.uri = uri;
        this.postBody = byArray;
        this.absoluteStreamPosition = l;
        this.position = l2;
        this.length = l3;
        this.key = string;
        this.flags = n;
    }

    public String toString() {
        return "DataSpec[" + this.uri + ", " + Arrays.toString(this.postBody) + ", " + this.absoluteStreamPosition + ", " + this.position + ", " + this.length + ", " + this.key + ", " + this.flags + "]";
    }
}

