/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.text.ttml;

import android.text.Layout;
import com.google.android.exoplayer.util.Assertions;

final class TtmlStyle {
    public static final short UNSPECIFIED = -1;
    public static final short STYLE_NORMAL = 0;
    public static final short STYLE_BOLD = 1;
    public static final short STYLE_ITALIC = 2;
    public static final short STYLE_BOLD_ITALIC = 3;
    public static final short FONT_SIZE_UNIT_PIXEL = 1;
    public static final short FONT_SIZE_UNIT_EM = 2;
    public static final short FONT_SIZE_UNIT_PERCENT = 3;
    private static final short OFF = 0;
    private static final short ON = 1;
    private String fontFamily;
    private int color;
    private boolean colorSpecified;
    private int backgroundColor;
    private boolean backgroundColorSpecified;
    private short linethrough = (short)-1;
    private short underline = (short)-1;
    private short bold = (short)-1;
    private short italic = (short)-1;
    private short fontSizeUnit = (short)-1;
    private float fontSize;
    private String id;
    private TtmlStyle inheritableStyle;
    private Layout.Alignment textAlign;

    TtmlStyle() {
    }

    public short getStyle() {
        if (this.bold == -1 && this.italic == -1) {
            return -1;
        }
        short s = 0;
        if (this.bold != -1) {
            s = (short)(s + this.bold);
        }
        if (this.italic != -1) {
            s = (short)(s + this.italic);
        }
        return s;
    }

    public boolean isLinethrough() {
        return this.linethrough == 1;
    }

    public TtmlStyle setLinethrough(boolean bl) {
        Assertions.checkState(this.inheritableStyle == null);
        this.linethrough = bl ? (short)1 : 0;
        return this;
    }

    public boolean isUnderline() {
        return this.underline == 1;
    }

    public TtmlStyle setUnderline(boolean bl) {
        Assertions.checkState(this.inheritableStyle == null);
        this.underline = bl ? (short)1 : 0;
        return this;
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public TtmlStyle setFontFamily(String string) {
        Assertions.checkState(this.inheritableStyle == null);
        this.fontFamily = string;
        return this;
    }

    public int getColor() {
        return this.color;
    }

    public TtmlStyle setColor(int n) {
        Assertions.checkState(this.inheritableStyle == null);
        this.color = n;
        this.colorSpecified = true;
        return this;
    }

    public boolean hasColorSpecified() {
        return this.colorSpecified;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public TtmlStyle setBackgroundColor(int n) {
        this.backgroundColor = n;
        this.backgroundColorSpecified = true;
        return this;
    }

    public boolean hasBackgroundColorSpecified() {
        return this.backgroundColorSpecified;
    }

    public TtmlStyle setBold(boolean bl) {
        Assertions.checkState(this.inheritableStyle == null);
        this.bold = bl ? (short)1 : 0;
        return this;
    }

    public TtmlStyle setItalic(boolean bl) {
        Assertions.checkState(this.inheritableStyle == null);
        this.italic = (short)(bl ? 2 : 0);
        return this;
    }

    public TtmlStyle inherit(TtmlStyle ttmlStyle) {
        return this.inherit(ttmlStyle, false);
    }

    public TtmlStyle chain(TtmlStyle ttmlStyle) {
        return this.inherit(ttmlStyle, true);
    }

    private TtmlStyle inherit(TtmlStyle ttmlStyle, boolean bl) {
        if (ttmlStyle != null) {
            if (!this.colorSpecified && ttmlStyle.colorSpecified) {
                this.setColor(ttmlStyle.color);
            }
            if (this.bold == -1) {
                this.bold = ttmlStyle.bold;
            }
            if (this.italic == -1) {
                this.italic = ttmlStyle.italic;
            }
            if (this.fontFamily == null) {
                this.fontFamily = ttmlStyle.fontFamily;
            }
            if (this.linethrough == -1) {
                this.linethrough = ttmlStyle.linethrough;
            }
            if (this.underline == -1) {
                this.underline = ttmlStyle.underline;
            }
            if (this.textAlign == null) {
                this.textAlign = ttmlStyle.textAlign;
            }
            if (this.fontSizeUnit == -1) {
                this.fontSizeUnit = ttmlStyle.fontSizeUnit;
                this.fontSize = ttmlStyle.fontSize;
            }
            if (bl && !this.backgroundColorSpecified && ttmlStyle.backgroundColorSpecified) {
                this.setBackgroundColor(ttmlStyle.backgroundColor);
            }
        }
        return this;
    }

    public TtmlStyle setId(String string) {
        this.id = string;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public Layout.Alignment getTextAlign() {
        return this.textAlign;
    }

    public TtmlStyle setTextAlign(Layout.Alignment alignment) {
        this.textAlign = alignment;
        return this;
    }

    public TtmlStyle setFontSize(float f2) {
        this.fontSize = f2;
        return this;
    }

    public TtmlStyle setFontSizeUnit(short s) {
        this.fontSizeUnit = s;
        return this;
    }

    public short getFontSizeUnit() {
        return this.fontSizeUnit;
    }

    public float getFontSize() {
        return this.fontSize;
    }
}

