/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.text.ttml;

import android.text.SpannableStringBuilder;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.AlignmentSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.StyleSpan;
import android.text.style.TypefaceSpan;
import android.text.style.UnderlineSpan;
import com.google.android.exoplayer.text.ttml.TtmlStyle;
import java.util.Map;

final class TtmlRenderUtil {
    public static TtmlStyle resolveStyle(TtmlStyle ttmlStyle, String[] stringArray, Map<String, TtmlStyle> map) {
        if (ttmlStyle == null && stringArray == null) {
            return null;
        }
        if (ttmlStyle == null && stringArray.length == 1) {
            return map.get(stringArray[0]);
        }
        if (ttmlStyle == null && stringArray.length > 1) {
            TtmlStyle ttmlStyle2 = new TtmlStyle();
            for (int i = 0; i < stringArray.length; ++i) {
                ttmlStyle2.chain(map.get(stringArray[i]));
            }
            return ttmlStyle2;
        }
        if (ttmlStyle != null && stringArray != null && stringArray.length == 1) {
            return ttmlStyle.chain(map.get(stringArray[0]));
        }
        if (ttmlStyle != null && stringArray != null && stringArray.length > 1) {
            for (int i = 0; i < stringArray.length; ++i) {
                ttmlStyle.chain(map.get(stringArray[i]));
            }
            return ttmlStyle;
        }
        return ttmlStyle;
    }

    public static void applyStylesToSpan(SpannableStringBuilder spannableStringBuilder, int n, int n2, TtmlStyle ttmlStyle) {
        if (ttmlStyle.getStyle() != -1) {
            spannableStringBuilder.setSpan((Object)new StyleSpan((int)ttmlStyle.getStyle()), n, n2, 33);
        }
        if (ttmlStyle.isLinethrough()) {
            spannableStringBuilder.setSpan((Object)new StrikethroughSpan(), n, n2, 33);
        }
        if (ttmlStyle.isUnderline()) {
            spannableStringBuilder.setSpan((Object)new UnderlineSpan(), n, n2, 33);
        }
        if (ttmlStyle.hasColorSpecified()) {
            spannableStringBuilder.setSpan((Object)new ForegroundColorSpan(ttmlStyle.getColor()), n, n2, 33);
        }
        if (ttmlStyle.hasBackgroundColorSpecified()) {
            spannableStringBuilder.setSpan((Object)new BackgroundColorSpan(ttmlStyle.getBackgroundColor()), n, n2, 33);
        }
        if (ttmlStyle.getFontFamily() != null) {
            spannableStringBuilder.setSpan((Object)new TypefaceSpan(ttmlStyle.getFontFamily()), n, n2, 33);
        }
        if (ttmlStyle.getTextAlign() != null) {
            spannableStringBuilder.setSpan((Object)new AlignmentSpan.Standard(ttmlStyle.getTextAlign()), n, n2, 33);
        }
        if (ttmlStyle.getFontSizeUnit() != -1) {
            switch (ttmlStyle.getFontSizeUnit()) {
                case 1: {
                    spannableStringBuilder.setSpan((Object)new AbsoluteSizeSpan((int)ttmlStyle.getFontSize(), true), n, n2, 33);
                    break;
                }
                case 2: {
                    spannableStringBuilder.setSpan((Object)new RelativeSizeSpan(ttmlStyle.getFontSize()), n, n2, 33);
                    break;
                }
                case 3: {
                    spannableStringBuilder.setSpan((Object)new RelativeSizeSpan(ttmlStyle.getFontSize() / 100.0f), n, n2, 33);
                }
            }
        }
    }

    static void endParagraph(SpannableStringBuilder spannableStringBuilder) {
        int n;
        for (n = spannableStringBuilder.length() - 1; n >= 0 && spannableStringBuilder.charAt(n) == ' '; --n) {
        }
        if (n >= 0 && spannableStringBuilder.charAt(n) != '\n') {
            spannableStringBuilder.append('\n');
        }
    }

    static String applyTextElementSpacePolicy(String string) {
        String string2 = string.replaceAll("\r\n", "\n");
        string2 = string2.replaceAll(" *\n *", "\n");
        string2 = string2.replaceAll("\n", " ");
        string2 = string2.replaceAll("[ \t\\x0B\f\r]+", " ");
        return string2;
    }

    private TtmlRenderUtil() {
    }
}

