/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.text;

import android.annotation.TargetApi;
import android.graphics.Typeface;
import android.view.accessibility.CaptioningManager;
import com.google.android.exoplayer.util.Util;

public final class CaptionStyleCompat {
    public static final int EDGE_TYPE_NONE = 0;
    public static final int EDGE_TYPE_OUTLINE = 1;
    public static final int EDGE_TYPE_DROP_SHADOW = 2;
    public static final int EDGE_TYPE_RAISED = 3;
    public static final int EDGE_TYPE_DEPRESSED = 4;
    public static final int USE_TRACK_COLOR_SETTINGS = 1;
    public static final CaptionStyleCompat DEFAULT = new CaptionStyleCompat(-1, -16777216, 0, 0, -1, null);
    public final int foregroundColor;
    public final int backgroundColor;
    public final int windowColor;
    public final int edgeType;
    public final int edgeColor;
    public final Typeface typeface;

    @TargetApi(value=19)
    public static CaptionStyleCompat createFromCaptionStyle(CaptioningManager.CaptionStyle captionStyle) {
        if (Util.SDK_INT >= 21) {
            return CaptionStyleCompat.createFromCaptionStyleV21(captionStyle);
        }
        return CaptionStyleCompat.createFromCaptionStyleV19(captionStyle);
    }

    public CaptionStyleCompat(int n, int n2, int n3, int n4, int n5, Typeface typeface) {
        this.foregroundColor = n;
        this.backgroundColor = n2;
        this.windowColor = n3;
        this.edgeType = n4;
        this.edgeColor = n5;
        this.typeface = typeface;
    }

    @TargetApi(value=19)
    private static CaptionStyleCompat createFromCaptionStyleV19(CaptioningManager.CaptionStyle captionStyle) {
        return new CaptionStyleCompat(captionStyle.foregroundColor, captionStyle.backgroundColor, 0, captionStyle.edgeType, captionStyle.edgeColor, captionStyle.getTypeface());
    }

    @TargetApi(value=21)
    private static CaptionStyleCompat createFromCaptionStyleV21(CaptioningManager.CaptionStyle captionStyle) {
        return new CaptionStyleCompat(captionStyle.hasForegroundColor() ? captionStyle.foregroundColor : CaptionStyleCompat.DEFAULT.foregroundColor, captionStyle.hasBackgroundColor() ? captionStyle.backgroundColor : CaptionStyleCompat.DEFAULT.backgroundColor, captionStyle.hasWindowColor() ? captionStyle.windowColor : CaptionStyleCompat.DEFAULT.windowColor, captionStyle.hasEdgeType() ? captionStyle.edgeType : CaptionStyleCompat.DEFAULT.edgeType, captionStyle.hasEdgeColor() ? captionStyle.edgeColor : CaptionStyleCompat.DEFAULT.edgeColor, captionStyle.getTypeface());
    }
}

