/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.smoothstreaming;

import android.util.Base64;
import android.util.Pair;
import com.google.android.exoplayer.ParserException;
import com.google.android.exoplayer.extractor.mp4.PsshAtomUtil;
import com.google.android.exoplayer.smoothstreaming.SmoothStreamingManifest;
import com.google.android.exoplayer.upstream.UriLoadable;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.CodecSpecificDataUtil;
import com.google.android.exoplayer.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class SmoothStreamingManifestParser
implements UriLoadable.Parser<SmoothStreamingManifest> {
    private final XmlPullParserFactory xmlParserFactory;

    public SmoothStreamingManifestParser() {
        try {
            this.xmlParserFactory = XmlPullParserFactory.newInstance();
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new RuntimeException("Couldn't create XmlPullParserFactory instance", xmlPullParserException);
        }
    }

    @Override
    public SmoothStreamingManifest parse(String string, InputStream inputStream) throws IOException, ParserException {
        try {
            XmlPullParser xmlPullParser = this.xmlParserFactory.newPullParser();
            xmlPullParser.setInput(inputStream, null);
            SmoothStreamMediaParser smoothStreamMediaParser = new SmoothStreamMediaParser(null, string);
            return (SmoothStreamingManifest)smoothStreamMediaParser.parse(xmlPullParser);
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new ParserException(xmlPullParserException);
        }
    }

    private static class TrackElementParser
    extends ElementParser {
        public static final String TAG = "QualityLevel";
        private static final String KEY_INDEX = "Index";
        private static final String KEY_BITRATE = "Bitrate";
        private static final String KEY_CODEC_PRIVATE_DATA = "CodecPrivateData";
        private static final String KEY_SAMPLING_RATE = "SamplingRate";
        private static final String KEY_CHANNELS = "Channels";
        private static final String KEY_FOUR_CC = "FourCC";
        private static final String KEY_TYPE = "Type";
        private static final String KEY_LANGUAGE = "Language";
        private static final String KEY_MAX_WIDTH = "MaxWidth";
        private static final String KEY_MAX_HEIGHT = "MaxHeight";
        private final List<byte[]> csd = new LinkedList<byte[]>();
        private int index;
        private int bitrate;
        private String mimeType;
        private int maxWidth;
        private int maxHeight;
        private int samplingRate;
        private int channels;
        private String language;

        public TrackElementParser(ElementParser elementParser, String string) {
            super(elementParser, string, TAG);
        }

        @Override
        public void parseStartTag(XmlPullParser xmlPullParser) throws ParserException {
            Object object;
            int n = (Integer)this.getNormalizedAttribute(KEY_TYPE);
            this.index = this.parseInt(xmlPullParser, KEY_INDEX, -1);
            this.bitrate = this.parseRequiredInt(xmlPullParser, KEY_BITRATE);
            this.language = (String)this.getNormalizedAttribute(KEY_LANGUAGE);
            if (n == 1) {
                this.maxHeight = this.parseRequiredInt(xmlPullParser, KEY_MAX_HEIGHT);
                this.maxWidth = this.parseRequiredInt(xmlPullParser, KEY_MAX_WIDTH);
                this.mimeType = TrackElementParser.fourCCToMimeType(this.parseRequiredString(xmlPullParser, KEY_FOUR_CC));
            } else {
                this.maxHeight = -1;
                this.maxWidth = -1;
                object = xmlPullParser.getAttributeValue(null, KEY_FOUR_CC);
                String string = object != null ? TrackElementParser.fourCCToMimeType((String)object) : (this.mimeType = n == 0 ? "audio/mp4a-latm" : null);
            }
            if (n == 0) {
                this.samplingRate = this.parseRequiredInt(xmlPullParser, KEY_SAMPLING_RATE);
                this.channels = this.parseRequiredInt(xmlPullParser, KEY_CHANNELS);
            } else {
                this.samplingRate = -1;
                this.channels = -1;
            }
            String string = xmlPullParser.getAttributeValue(null, KEY_CODEC_PRIVATE_DATA);
            if (string != null && string.length() > 0) {
                object = Util.getBytesFromHexString(string);
                byte[][] byArray = CodecSpecificDataUtil.splitNalUnits((byte[])object);
                if (byArray == null) {
                    this.csd.add((byte[])object);
                } else {
                    for (int i = 0; i < byArray.length; ++i) {
                        this.csd.add(byArray[i]);
                    }
                }
            }
        }

        @Override
        public Object build() {
            Object object = null;
            if (!this.csd.isEmpty()) {
                object = new byte[this.csd.size()][];
                this.csd.toArray((T[])object);
            }
            return new SmoothStreamingManifest.TrackElement(this.index, this.bitrate, this.mimeType, (byte[][])object, this.maxWidth, this.maxHeight, this.samplingRate, this.channels, this.language);
        }

        private static String fourCCToMimeType(String string) {
            if (string.equalsIgnoreCase("H264") || string.equalsIgnoreCase("X264") || string.equalsIgnoreCase("AVC1") || string.equalsIgnoreCase("DAVC")) {
                return "video/avc";
            }
            if (string.equalsIgnoreCase("AAC") || string.equalsIgnoreCase("AACL") || string.equalsIgnoreCase("AACH") || string.equalsIgnoreCase("AACP")) {
                return "audio/mp4a-latm";
            }
            if (string.equalsIgnoreCase("TTML")) {
                return "application/ttml+xml";
            }
            if (string.equalsIgnoreCase("ac-3") || string.equalsIgnoreCase("dac3")) {
                return "audio/ac3";
            }
            if (string.equalsIgnoreCase("ec-3") || string.equalsIgnoreCase("dec3")) {
                return "audio/eac3";
            }
            if (string.equalsIgnoreCase("dtsc")) {
                return "audio/vnd.dts";
            }
            if (string.equalsIgnoreCase("dtsh") || string.equalsIgnoreCase("dtsl")) {
                return "audio/vnd.dts.hd";
            }
            if (string.equalsIgnoreCase("dtse")) {
                return "audio/vnd.dts.hd;profile=lbr";
            }
            if (string.equalsIgnoreCase("opus")) {
                return "audio/opus";
            }
            return null;
        }
    }

    private static class StreamElementParser
    extends ElementParser {
        public static final String TAG = "StreamIndex";
        private static final String TAG_STREAM_FRAGMENT = "c";
        private static final String KEY_TYPE = "Type";
        private static final String KEY_TYPE_AUDIO = "audio";
        private static final String KEY_TYPE_VIDEO = "video";
        private static final String KEY_TYPE_TEXT = "text";
        private static final String KEY_SUB_TYPE = "Subtype";
        private static final String KEY_NAME = "Name";
        private static final String KEY_QUALITY_LEVELS = "QualityLevels";
        private static final String KEY_URL = "Url";
        private static final String KEY_MAX_WIDTH = "MaxWidth";
        private static final String KEY_MAX_HEIGHT = "MaxHeight";
        private static final String KEY_DISPLAY_WIDTH = "DisplayWidth";
        private static final String KEY_DISPLAY_HEIGHT = "DisplayHeight";
        private static final String KEY_LANGUAGE = "Language";
        private static final String KEY_TIME_SCALE = "TimeScale";
        private static final String KEY_FRAGMENT_DURATION = "d";
        private static final String KEY_FRAGMENT_START_TIME = "t";
        private static final String KEY_FRAGMENT_REPEAT_COUNT = "r";
        private final String baseUri;
        private final List<SmoothStreamingManifest.TrackElement> tracks;
        private int type;
        private String subType;
        private long timescale;
        private String name;
        private int qualityLevels;
        private String url;
        private int maxWidth;
        private int maxHeight;
        private int displayWidth;
        private int displayHeight;
        private String language;
        private ArrayList<Long> startTimes;
        private long lastChunkDuration;

        public StreamElementParser(ElementParser elementParser, String string) {
            super(elementParser, string, TAG);
            this.baseUri = string;
            this.tracks = new LinkedList<SmoothStreamingManifest.TrackElement>();
        }

        @Override
        public boolean handleChildInline(String string) {
            return TAG_STREAM_FRAGMENT.equals(string);
        }

        @Override
        public void parseStartTag(XmlPullParser xmlPullParser) throws ParserException {
            if (TAG_STREAM_FRAGMENT.equals(xmlPullParser.getName())) {
                this.parseStreamFragmentStartTag(xmlPullParser);
            } else {
                this.parseStreamElementStartTag(xmlPullParser);
            }
        }

        private void parseStreamFragmentStartTag(XmlPullParser xmlPullParser) throws ParserException {
            int n = this.startTimes.size();
            long l = this.parseLong(xmlPullParser, KEY_FRAGMENT_START_TIME, -1L);
            if (l == -1L) {
                if (n == 0) {
                    l = 0L;
                } else if (this.lastChunkDuration != -1L) {
                    l = this.startTimes.get(n - 1) + this.lastChunkDuration;
                } else {
                    throw new ParserException("Unable to infer start time");
                }
            }
            ++n;
            this.startTimes.add(l);
            this.lastChunkDuration = this.parseLong(xmlPullParser, KEY_FRAGMENT_DURATION, -1L);
            long l2 = this.parseLong(xmlPullParser, KEY_FRAGMENT_REPEAT_COUNT, 1L);
            if (l2 > 1L && this.lastChunkDuration == -1L) {
                throw new ParserException("Repeated chunk with unspecified duration");
            }
            int n2 = 1;
            while ((long)n2 < l2) {
                ++n;
                this.startTimes.add(l + this.lastChunkDuration * (long)n2);
                ++n2;
            }
        }

        private void parseStreamElementStartTag(XmlPullParser xmlPullParser) throws ParserException {
            this.type = this.parseType(xmlPullParser);
            this.putNormalizedAttribute(KEY_TYPE, this.type);
            this.subType = this.type == 2 ? this.parseRequiredString(xmlPullParser, KEY_SUB_TYPE) : xmlPullParser.getAttributeValue(null, KEY_SUB_TYPE);
            this.name = xmlPullParser.getAttributeValue(null, KEY_NAME);
            this.qualityLevels = this.parseInt(xmlPullParser, KEY_QUALITY_LEVELS, -1);
            this.url = this.parseRequiredString(xmlPullParser, KEY_URL);
            this.maxWidth = this.parseInt(xmlPullParser, KEY_MAX_WIDTH, -1);
            this.maxHeight = this.parseInt(xmlPullParser, KEY_MAX_HEIGHT, -1);
            this.displayWidth = this.parseInt(xmlPullParser, KEY_DISPLAY_WIDTH, -1);
            this.displayHeight = this.parseInt(xmlPullParser, KEY_DISPLAY_HEIGHT, -1);
            this.language = xmlPullParser.getAttributeValue(null, KEY_LANGUAGE);
            this.putNormalizedAttribute(KEY_LANGUAGE, this.language);
            this.timescale = this.parseInt(xmlPullParser, KEY_TIME_SCALE, -1);
            if (this.timescale == -1L) {
                this.timescale = (Long)this.getNormalizedAttribute(KEY_TIME_SCALE);
            }
            this.startTimes = new ArrayList();
        }

        private int parseType(XmlPullParser xmlPullParser) throws ParserException {
            String string = xmlPullParser.getAttributeValue(null, KEY_TYPE);
            if (string != null) {
                if (KEY_TYPE_AUDIO.equalsIgnoreCase(string)) {
                    return 0;
                }
                if (KEY_TYPE_VIDEO.equalsIgnoreCase(string)) {
                    return 1;
                }
                if (KEY_TYPE_TEXT.equalsIgnoreCase(string)) {
                    return 2;
                }
                throw new ParserException("Invalid key value[" + string + "]");
            }
            throw new MissingFieldException(KEY_TYPE);
        }

        @Override
        public void addChild(Object object) {
            if (object instanceof SmoothStreamingManifest.TrackElement) {
                this.tracks.add((SmoothStreamingManifest.TrackElement)object);
            }
        }

        @Override
        public Object build() {
            SmoothStreamingManifest.TrackElement[] trackElementArray = new SmoothStreamingManifest.TrackElement[this.tracks.size()];
            this.tracks.toArray(trackElementArray);
            return new SmoothStreamingManifest.StreamElement(this.baseUri, this.url, this.type, this.subType, this.timescale, this.name, this.qualityLevels, this.maxWidth, this.maxHeight, this.displayWidth, this.displayHeight, this.language, trackElementArray, this.startTimes, this.lastChunkDuration);
        }
    }

    private static class ProtectionElementParser
    extends ElementParser {
        public static final String TAG = "Protection";
        public static final String TAG_PROTECTION_HEADER = "ProtectionHeader";
        public static final String KEY_SYSTEM_ID = "SystemID";
        private boolean inProtectionHeader;
        private UUID uuid;
        private byte[] initData;

        public ProtectionElementParser(ElementParser elementParser, String string) {
            super(elementParser, string, TAG);
        }

        @Override
        public boolean handleChildInline(String string) {
            return TAG_PROTECTION_HEADER.equals(string);
        }

        @Override
        public void parseStartTag(XmlPullParser xmlPullParser) {
            if (TAG_PROTECTION_HEADER.equals(xmlPullParser.getName())) {
                this.inProtectionHeader = true;
                String string = xmlPullParser.getAttributeValue(null, KEY_SYSTEM_ID);
                string = ProtectionElementParser.stripCurlyBraces(string);
                this.uuid = UUID.fromString(string);
            }
        }

        @Override
        public void parseText(XmlPullParser xmlPullParser) {
            if (this.inProtectionHeader) {
                this.initData = Base64.decode((String)xmlPullParser.getText(), (int)0);
            }
        }

        @Override
        public void parseEndTag(XmlPullParser xmlPullParser) {
            if (TAG_PROTECTION_HEADER.equals(xmlPullParser.getName())) {
                this.inProtectionHeader = false;
            }
        }

        @Override
        public Object build() {
            return new SmoothStreamingManifest.ProtectionElement(this.uuid, PsshAtomUtil.buildPsshAtom(this.uuid, this.initData));
        }

        private static String stripCurlyBraces(String string) {
            if (string.charAt(0) == '{' && string.charAt(string.length() - 1) == '}') {
                string = string.substring(1, string.length() - 1);
            }
            return string;
        }
    }

    private static class SmoothStreamMediaParser
    extends ElementParser {
        public static final String TAG = "SmoothStreamingMedia";
        private static final String KEY_MAJOR_VERSION = "MajorVersion";
        private static final String KEY_MINOR_VERSION = "MinorVersion";
        private static final String KEY_TIME_SCALE = "TimeScale";
        private static final String KEY_DVR_WINDOW_LENGTH = "DVRWindowLength";
        private static final String KEY_DURATION = "Duration";
        private static final String KEY_LOOKAHEAD_COUNT = "LookaheadCount";
        private static final String KEY_IS_LIVE = "IsLive";
        private int majorVersion;
        private int minorVersion;
        private long timescale;
        private long duration;
        private long dvrWindowLength;
        private int lookAheadCount = -1;
        private boolean isLive;
        private SmoothStreamingManifest.ProtectionElement protectionElement = null;
        private List<SmoothStreamingManifest.StreamElement> streamElements = new LinkedList<SmoothStreamingManifest.StreamElement>();

        public SmoothStreamMediaParser(ElementParser elementParser, String string) {
            super(elementParser, string, TAG);
        }

        @Override
        public void parseStartTag(XmlPullParser xmlPullParser) throws ParserException {
            this.majorVersion = this.parseRequiredInt(xmlPullParser, KEY_MAJOR_VERSION);
            this.minorVersion = this.parseRequiredInt(xmlPullParser, KEY_MINOR_VERSION);
            this.timescale = this.parseLong(xmlPullParser, KEY_TIME_SCALE, 10000000L);
            this.duration = this.parseRequiredLong(xmlPullParser, KEY_DURATION);
            this.dvrWindowLength = this.parseLong(xmlPullParser, KEY_DVR_WINDOW_LENGTH, 0L);
            this.lookAheadCount = this.parseInt(xmlPullParser, KEY_LOOKAHEAD_COUNT, -1);
            this.isLive = this.parseBoolean(xmlPullParser, KEY_IS_LIVE, false);
            this.putNormalizedAttribute(KEY_TIME_SCALE, this.timescale);
        }

        @Override
        public void addChild(Object object) {
            if (object instanceof SmoothStreamingManifest.StreamElement) {
                this.streamElements.add((SmoothStreamingManifest.StreamElement)object);
            } else if (object instanceof SmoothStreamingManifest.ProtectionElement) {
                Assertions.checkState(this.protectionElement == null);
                this.protectionElement = (SmoothStreamingManifest.ProtectionElement)object;
            }
        }

        @Override
        public Object build() {
            SmoothStreamingManifest.StreamElement[] streamElementArray = new SmoothStreamingManifest.StreamElement[this.streamElements.size()];
            this.streamElements.toArray(streamElementArray);
            return new SmoothStreamingManifest(this.majorVersion, this.minorVersion, this.timescale, this.duration, this.dvrWindowLength, this.lookAheadCount, this.isLive, this.protectionElement, streamElementArray);
        }
    }

    private static abstract class ElementParser {
        private final String baseUri;
        private final String tag;
        private final ElementParser parent;
        private final List<Pair<String, Object>> normalizedAttributes;

        public ElementParser(ElementParser elementParser, String string, String string2) {
            this.parent = elementParser;
            this.baseUri = string;
            this.tag = string2;
            this.normalizedAttributes = new LinkedList<Pair<String, Object>>();
        }

        public final Object parse(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException, ParserException {
            boolean bl = false;
            int n = 0;
            while (true) {
                int n2 = xmlPullParser.getEventType();
                switch (n2) {
                    case 2: {
                        String string = xmlPullParser.getName();
                        if (this.tag.equals(string)) {
                            bl = true;
                            this.parseStartTag(xmlPullParser);
                            break;
                        }
                        if (!bl) break;
                        if (n > 0) {
                            ++n;
                            break;
                        }
                        if (this.handleChildInline(string)) {
                            this.parseStartTag(xmlPullParser);
                            break;
                        }
                        ElementParser elementParser = this.newChildParser(this, string, this.baseUri);
                        if (elementParser == null) {
                            n = 1;
                            break;
                        }
                        this.addChild(elementParser.parse(xmlPullParser));
                        break;
                    }
                    case 4: {
                        if (!bl || n != 0) break;
                        this.parseText(xmlPullParser);
                        break;
                    }
                    case 3: {
                        if (!bl) break;
                        if (n > 0) {
                            --n;
                            break;
                        }
                        String string = xmlPullParser.getName();
                        this.parseEndTag(xmlPullParser);
                        if (this.handleChildInline(string)) break;
                        return this.build();
                    }
                    case 1: {
                        return null;
                    }
                }
                xmlPullParser.next();
            }
        }

        private ElementParser newChildParser(ElementParser elementParser, String string, String string2) {
            if ("QualityLevel".equals(string)) {
                return new TrackElementParser(elementParser, string2);
            }
            if ("Protection".equals(string)) {
                return new ProtectionElementParser(elementParser, string2);
            }
            if ("StreamIndex".equals(string)) {
                return new StreamElementParser(elementParser, string2);
            }
            return null;
        }

        protected final void putNormalizedAttribute(String string, Object object) {
            this.normalizedAttributes.add((Pair<String, Object>)Pair.create((Object)string, (Object)object));
        }

        protected final Object getNormalizedAttribute(String string) {
            for (int i = 0; i < this.normalizedAttributes.size(); ++i) {
                Pair<String, Object> pair = this.normalizedAttributes.get(i);
                if (!((String)pair.first).equals(string)) continue;
                return pair.second;
            }
            return this.parent == null ? null : this.parent.getNormalizedAttribute(string);
        }

        protected boolean handleChildInline(String string) {
            return false;
        }

        protected void parseStartTag(XmlPullParser xmlPullParser) throws ParserException {
        }

        protected void parseText(XmlPullParser xmlPullParser) throws ParserException {
        }

        protected void parseEndTag(XmlPullParser xmlPullParser) throws ParserException {
        }

        protected void addChild(Object object) {
        }

        protected abstract Object build();

        protected final String parseRequiredString(XmlPullParser xmlPullParser, String string) throws MissingFieldException {
            String string2 = xmlPullParser.getAttributeValue(null, string);
            if (string2 != null) {
                return string2;
            }
            throw new MissingFieldException(string);
        }

        protected final int parseInt(XmlPullParser xmlPullParser, String string, int n) throws ParserException {
            String string2 = xmlPullParser.getAttributeValue(null, string);
            if (string2 != null) {
                try {
                    return Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParserException(numberFormatException);
                }
            }
            return n;
        }

        protected final int parseRequiredInt(XmlPullParser xmlPullParser, String string) throws ParserException {
            String string2 = xmlPullParser.getAttributeValue(null, string);
            if (string2 != null) {
                try {
                    return Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParserException(numberFormatException);
                }
            }
            throw new MissingFieldException(string);
        }

        protected final long parseLong(XmlPullParser xmlPullParser, String string, long l) throws ParserException {
            String string2 = xmlPullParser.getAttributeValue(null, string);
            if (string2 != null) {
                try {
                    return Long.parseLong(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParserException(numberFormatException);
                }
            }
            return l;
        }

        protected final long parseRequiredLong(XmlPullParser xmlPullParser, String string) throws ParserException {
            String string2 = xmlPullParser.getAttributeValue(null, string);
            if (string2 != null) {
                try {
                    return Long.parseLong(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParserException(numberFormatException);
                }
            }
            throw new MissingFieldException(string);
        }

        protected final boolean parseBoolean(XmlPullParser xmlPullParser, String string, boolean bl) {
            String string2 = xmlPullParser.getAttributeValue(null, string);
            if (string2 != null) {
                return Boolean.parseBoolean(string2);
            }
            return bl;
        }
    }

    public static class MissingFieldException
    extends ParserException {
        public MissingFieldException(String string) {
            super("Missing required field: " + string);
        }
    }
}

