/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.smoothstreaming;

import android.net.Uri;
import com.google.android.exoplayer.chunk.Format;
import com.google.android.exoplayer.chunk.FormatWrapper;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.UriUtil;
import com.google.android.exoplayer.util.Util;
import java.util.List;
import java.util.UUID;

public class SmoothStreamingManifest {
    public final int majorVersion;
    public final int minorVersion;
    public final int lookAheadCount;
    public final boolean isLive;
    public final ProtectionElement protectionElement;
    public final StreamElement[] streamElements;
    public final long durationUs;
    public final long dvrWindowLengthUs;

    public SmoothStreamingManifest(int n, int n2, long l, long l2, long l3, int n3, boolean bl, ProtectionElement protectionElement, StreamElement[] streamElementArray) {
        this.majorVersion = n;
        this.minorVersion = n2;
        this.lookAheadCount = n3;
        this.isLive = bl;
        this.protectionElement = protectionElement;
        this.streamElements = streamElementArray;
        this.dvrWindowLengthUs = l3 == 0L ? -1L : Util.scaleLargeTimestamp(l3, 1000000L, l);
        this.durationUs = l2 == 0L ? -1L : Util.scaleLargeTimestamp(l2, 1000000L, l);
    }

    public static class StreamElement {
        public static final int TYPE_UNKNOWN = -1;
        public static final int TYPE_AUDIO = 0;
        public static final int TYPE_VIDEO = 1;
        public static final int TYPE_TEXT = 2;
        private static final String URL_PLACEHOLDER_START_TIME = "{start time}";
        private static final String URL_PLACEHOLDER_BITRATE = "{bitrate}";
        public final int type;
        public final String subType;
        public final long timescale;
        public final String name;
        public final int qualityLevels;
        public final int maxWidth;
        public final int maxHeight;
        public final int displayWidth;
        public final int displayHeight;
        public final String language;
        public final TrackElement[] tracks;
        public final int chunkCount;
        private final String baseUri;
        private final String chunkTemplate;
        private final List<Long> chunkStartTimes;
        private final long[] chunkStartTimesUs;
        private final long lastChunkDurationUs;

        public StreamElement(String string, String string2, int n, String string3, long l, String string4, int n2, int n3, int n4, int n5, int n6, String string5, TrackElement[] trackElementArray, List<Long> list, long l2) {
            this.baseUri = string;
            this.chunkTemplate = string2;
            this.type = n;
            this.subType = string3;
            this.timescale = l;
            this.name = string4;
            this.qualityLevels = n2;
            this.maxWidth = n3;
            this.maxHeight = n4;
            this.displayWidth = n5;
            this.displayHeight = n6;
            this.language = string5;
            this.tracks = trackElementArray;
            this.chunkCount = list.size();
            this.chunkStartTimes = list;
            this.lastChunkDurationUs = Util.scaleLargeTimestamp(l2, 1000000L, l);
            this.chunkStartTimesUs = Util.scaleLargeTimestamps(list, 1000000L, l);
        }

        public int getChunkIndex(long l) {
            return Util.binarySearchFloor(this.chunkStartTimesUs, l, true, true);
        }

        public long getStartTimeUs(int n) {
            return this.chunkStartTimesUs[n];
        }

        public long getChunkDurationUs(int n) {
            return n == this.chunkCount - 1 ? this.lastChunkDurationUs : this.chunkStartTimesUs[n + 1] - this.chunkStartTimesUs[n];
        }

        public Uri buildRequestUri(int n, int n2) {
            Assertions.checkState(this.tracks != null);
            Assertions.checkState(this.chunkStartTimes != null);
            Assertions.checkState(n2 < this.chunkStartTimes.size());
            String string = this.chunkTemplate.replace(URL_PLACEHOLDER_BITRATE, Integer.toString(this.tracks[n].format.bitrate)).replace(URL_PLACEHOLDER_START_TIME, this.chunkStartTimes.get(n2).toString());
            return UriUtil.resolveToUri(this.baseUri, string);
        }
    }

    public static class TrackElement
    implements FormatWrapper {
        public final Format format;
        public final byte[][] csd;

        public TrackElement(int n, int n2, String string, byte[][] byArray, int n3, int n4, int n5, int n6, String string2) {
            this.csd = byArray;
            this.format = new Format(String.valueOf(n), string, n3, n4, -1.0f, n6, n5, n2, string2);
        }

        @Override
        public Format getFormat() {
            return this.format;
        }
    }

    public static class ProtectionElement {
        public final UUID uuid;
        public final byte[] data;

        public ProtectionElement(UUID uUID, byte[] byArray) {
            this.uuid = uUID;
            this.data = byArray;
        }
    }
}

