/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor.webm;

import com.google.android.exoplayer.ParserException;
import com.google.android.exoplayer.extractor.ExtractorInput;
import com.google.android.exoplayer.extractor.webm.EbmlReader;
import com.google.android.exoplayer.extractor.webm.EbmlReaderOutput;
import com.google.android.exoplayer.extractor.webm.VarintReader;
import com.google.android.exoplayer.util.Assertions;
import java.io.EOFException;
import java.io.IOException;
import java.util.Stack;

final class DefaultEbmlReader
implements EbmlReader {
    private static final int ELEMENT_STATE_READ_ID = 0;
    private static final int ELEMENT_STATE_READ_CONTENT_SIZE = 1;
    private static final int ELEMENT_STATE_READ_CONTENT = 2;
    private static final int MAX_ID_BYTES = 4;
    private static final int MAX_LENGTH_BYTES = 8;
    private static final int MAX_INTEGER_ELEMENT_SIZE_BYTES = 8;
    private static final int VALID_FLOAT32_ELEMENT_SIZE_BYTES = 4;
    private static final int VALID_FLOAT64_ELEMENT_SIZE_BYTES = 8;
    private final byte[] scratch = new byte[8];
    private final Stack<MasterElement> masterElementsStack = new Stack();
    private final VarintReader varintReader = new VarintReader();
    private EbmlReaderOutput output;
    private int elementState;
    private int elementId;
    private long elementContentSize;

    DefaultEbmlReader() {
    }

    @Override
    public void init(EbmlReaderOutput ebmlReaderOutput) {
        this.output = ebmlReaderOutput;
    }

    @Override
    public void reset() {
        this.elementState = 0;
        this.masterElementsStack.clear();
        this.varintReader.reset();
    }

    @Override
    public boolean read(ExtractorInput extractorInput) throws IOException, InterruptedException {
        int n;
        Assertions.checkState(this.output != null);
        block8: while (true) {
            if (!this.masterElementsStack.isEmpty() && extractorInput.getPosition() >= this.masterElementsStack.peek().elementEndPosition) {
                this.output.endMasterElement(this.masterElementsStack.pop().elementId);
                return true;
            }
            if (this.elementState == 0) {
                long l = this.varintReader.readUnsignedVarint(extractorInput, true, false, 4);
                if (l == -2L) {
                    l = this.maybeResyncToNextLevel1Element(extractorInput);
                }
                if (l == -1L) {
                    return false;
                }
                this.elementId = (int)l;
                this.elementState = 1;
            }
            if (this.elementState == 1) {
                this.elementContentSize = this.varintReader.readUnsignedVarint(extractorInput, false, true, 8);
                this.elementState = 2;
            }
            n = this.output.getElementType(this.elementId);
            switch (n) {
                case 1: {
                    long l = extractorInput.getPosition();
                    long l2 = l + this.elementContentSize;
                    this.masterElementsStack.add(new MasterElement(this.elementId, l2));
                    this.output.startMasterElement(this.elementId, l, this.elementContentSize);
                    this.elementState = 0;
                    return true;
                }
                case 2: {
                    if (this.elementContentSize > 8L) {
                        throw new ParserException("Invalid integer size: " + this.elementContentSize);
                    }
                    this.output.integerElement(this.elementId, this.readInteger(extractorInput, (int)this.elementContentSize));
                    this.elementState = 0;
                    return true;
                }
                case 5: {
                    if (this.elementContentSize != 4L && this.elementContentSize != 8L) {
                        throw new ParserException("Invalid float size: " + this.elementContentSize);
                    }
                    this.output.floatElement(this.elementId, this.readFloat(extractorInput, (int)this.elementContentSize));
                    this.elementState = 0;
                    return true;
                }
                case 3: {
                    if (this.elementContentSize > Integer.MAX_VALUE) {
                        throw new ParserException("String element size: " + this.elementContentSize);
                    }
                    this.output.stringElement(this.elementId, this.readString(extractorInput, (int)this.elementContentSize));
                    this.elementState = 0;
                    return true;
                }
                case 4: {
                    this.output.binaryElement(this.elementId, (int)this.elementContentSize, extractorInput);
                    this.elementState = 0;
                    return true;
                }
                case 0: {
                    extractorInput.skipFully((int)this.elementContentSize);
                    this.elementState = 0;
                    continue block8;
                }
            }
            break;
        }
        throw new ParserException("Invalid element type " + n);
    }

    private long maybeResyncToNextLevel1Element(ExtractorInput extractorInput) throws EOFException, IOException, InterruptedException {
        extractorInput.resetPeekPosition();
        while (true) {
            int n;
            extractorInput.peekFully(this.scratch, 0, 4);
            int n2 = VarintReader.parseUnsignedVarintLength(this.scratch[0]);
            if (n2 != -1 && n2 <= 4 && this.output.isLevel1Element(n = (int)VarintReader.assembleVarint(this.scratch, n2, false))) {
                extractorInput.skipFully(n2);
                return n;
            }
            extractorInput.skipFully(1);
        }
    }

    private long readInteger(ExtractorInput extractorInput, int n) throws IOException, InterruptedException {
        extractorInput.readFully(this.scratch, 0, n);
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            l = l << 8 | (long)(this.scratch[i] & 0xFF);
        }
        return l;
    }

    private double readFloat(ExtractorInput extractorInput, int n) throws IOException, InterruptedException {
        long l = this.readInteger(extractorInput, n);
        double d2 = n == 4 ? (double)Float.intBitsToFloat((int)l) : Double.longBitsToDouble(l);
        return d2;
    }

    private String readString(ExtractorInput extractorInput, int n) throws IOException, InterruptedException {
        if (n == 0) {
            return "";
        }
        byte[] byArray = new byte[n];
        extractorInput.readFully(byArray, 0, n);
        return new String(byArray);
    }

    private static final class MasterElement {
        private final int elementId;
        private final long elementEndPosition;

        private MasterElement(int n, long l) {
            this.elementId = n;
            this.elementEndPosition = l;
        }
    }
}

