/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor.ts;

import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.extractor.TrackOutput;
import com.google.android.exoplayer.extractor.ts.ElementaryStreamReader;
import com.google.android.exoplayer.util.MpegAudioHeader;
import com.google.android.exoplayer.util.ParsableByteArray;

final class MpegAudioReader
extends ElementaryStreamReader {
    private static final int STATE_FINDING_HEADER = 0;
    private static final int STATE_READING_HEADER = 1;
    private static final int STATE_READING_FRAME = 2;
    private static final int HEADER_SIZE = 4;
    private final ParsableByteArray headerScratch = new ParsableByteArray(4);
    private final MpegAudioHeader header;
    private int state = 0;
    private int frameBytesRead;
    private boolean hasOutputFormat;
    private boolean lastByteWasFF;
    private long frameDurationUs;
    private int frameSize;
    private long timeUs;

    public MpegAudioReader(TrackOutput trackOutput) {
        super(trackOutput);
        this.headerScratch.data[0] = -1;
        this.header = new MpegAudioHeader();
    }

    @Override
    public void seek() {
        this.state = 0;
        this.frameBytesRead = 0;
        this.lastByteWasFF = false;
    }

    @Override
    public void packetStarted(long l, boolean bl) {
        this.timeUs = l;
    }

    @Override
    public void consume(ParsableByteArray parsableByteArray) {
        while (parsableByteArray.bytesLeft() > 0) {
            switch (this.state) {
                case 0: {
                    this.findHeader(parsableByteArray);
                    break;
                }
                case 1: {
                    this.readHeaderRemainder(parsableByteArray);
                    break;
                }
                case 2: {
                    this.readFrameRemainder(parsableByteArray);
                }
            }
        }
    }

    @Override
    public void packetFinished() {
    }

    private void findHeader(ParsableByteArray parsableByteArray) {
        byte[] byArray = parsableByteArray.data;
        int n = parsableByteArray.getPosition();
        int n2 = parsableByteArray.limit();
        for (int i = n; i < n2; ++i) {
            boolean bl = (byArray[i] & 0xFF) == 255;
            boolean bl2 = this.lastByteWasFF && (byArray[i] & 0xE0) == 224;
            this.lastByteWasFF = bl;
            if (!bl2) continue;
            parsableByteArray.setPosition(i + 1);
            this.lastByteWasFF = false;
            this.headerScratch.data[1] = byArray[i];
            this.frameBytesRead = 2;
            this.state = 1;
            return;
        }
        parsableByteArray.setPosition(n2);
    }

    private void readHeaderRemainder(ParsableByteArray parsableByteArray) {
        int n = Math.min(parsableByteArray.bytesLeft(), 4 - this.frameBytesRead);
        parsableByteArray.readBytes(this.headerScratch.data, this.frameBytesRead, n);
        this.frameBytesRead += n;
        if (this.frameBytesRead < 4) {
            return;
        }
        this.headerScratch.setPosition(0);
        boolean bl = MpegAudioHeader.populateHeader(this.headerScratch.readInt(), this.header);
        if (!bl) {
            this.frameBytesRead = 0;
            this.state = 1;
            return;
        }
        this.frameSize = this.header.frameSize;
        if (!this.hasOutputFormat) {
            this.frameDurationUs = 1000000L * (long)this.header.samplesPerFrame / (long)this.header.sampleRate;
            MediaFormat mediaFormat = MediaFormat.createAudioFormat(null, this.header.mimeType, -1, 4096, -1L, this.header.channels, this.header.sampleRate, null, null);
            this.output.format(mediaFormat);
            this.hasOutputFormat = true;
        }
        this.headerScratch.setPosition(0);
        this.output.sampleData(this.headerScratch, 4);
        this.state = 2;
    }

    private void readFrameRemainder(ParsableByteArray parsableByteArray) {
        int n = Math.min(parsableByteArray.bytesLeft(), this.frameSize - this.frameBytesRead);
        this.output.sampleData(parsableByteArray, n);
        this.frameBytesRead += n;
        if (this.frameBytesRead < this.frameSize) {
            return;
        }
        this.output.sampleMetadata(this.timeUs, 1, this.frameSize, 0, null);
        this.timeUs += this.frameDurationUs;
        this.frameBytesRead = 0;
        this.state = 0;
    }
}

