/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor.mp4;

import com.google.android.exoplayer.extractor.ExtractorInput;
import com.google.android.exoplayer.extractor.mp4.DefaultSampleValues;
import com.google.android.exoplayer.util.ParsableByteArray;
import java.io.IOException;

final class TrackFragment {
    public DefaultSampleValues header;
    public long dataPosition;
    public long auxiliaryDataPosition;
    public int length;
    public int[] sampleSizeTable;
    public int[] sampleCompositionTimeOffsetTable;
    public long[] sampleDecodingTimeTable;
    public boolean[] sampleIsSyncFrameTable;
    public boolean definesEncryptionData;
    public boolean[] sampleHasSubsampleEncryptionTable;
    public int sampleEncryptionDataLength;
    public ParsableByteArray sampleEncryptionData;
    public boolean sampleEncryptionDataNeedsFill;

    TrackFragment() {
    }

    public void reset() {
        this.length = 0;
        this.definesEncryptionData = false;
        this.sampleEncryptionDataNeedsFill = false;
    }

    public void initTables(int n) {
        this.length = n;
        if (this.sampleSizeTable == null || this.sampleSizeTable.length < this.length) {
            int n2 = n * 125 / 100;
            this.sampleSizeTable = new int[n2];
            this.sampleCompositionTimeOffsetTable = new int[n2];
            this.sampleDecodingTimeTable = new long[n2];
            this.sampleIsSyncFrameTable = new boolean[n2];
            this.sampleHasSubsampleEncryptionTable = new boolean[n2];
        }
    }

    public void initEncryptionData(int n) {
        if (this.sampleEncryptionData == null || this.sampleEncryptionData.limit() < n) {
            this.sampleEncryptionData = new ParsableByteArray(n);
        }
        this.sampleEncryptionDataLength = n;
        this.definesEncryptionData = true;
        this.sampleEncryptionDataNeedsFill = true;
    }

    public void fillEncryptionData(ExtractorInput extractorInput) throws IOException, InterruptedException {
        extractorInput.readFully(this.sampleEncryptionData.data, 0, this.sampleEncryptionDataLength);
        this.sampleEncryptionData.setPosition(0);
        this.sampleEncryptionDataNeedsFill = false;
    }

    public void fillEncryptionData(ParsableByteArray parsableByteArray) {
        parsableByteArray.readBytes(this.sampleEncryptionData.data, 0, this.sampleEncryptionDataLength);
        this.sampleEncryptionData.setPosition(0);
        this.sampleEncryptionDataNeedsFill = false;
    }

    public long getSamplePresentationTime(int n) {
        return this.sampleDecodingTimeTable[n] + (long)this.sampleCompositionTimeOffsetTable[n];
    }
}

