/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor.mp3;

import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.ParserException;
import com.google.android.exoplayer.extractor.Extractor;
import com.google.android.exoplayer.extractor.ExtractorInput;
import com.google.android.exoplayer.extractor.ExtractorOutput;
import com.google.android.exoplayer.extractor.GaplessInfo;
import com.google.android.exoplayer.extractor.PositionHolder;
import com.google.android.exoplayer.extractor.SeekMap;
import com.google.android.exoplayer.extractor.TrackOutput;
import com.google.android.exoplayer.extractor.mp3.ConstantBitrateSeeker;
import com.google.android.exoplayer.extractor.mp3.Id3Util;
import com.google.android.exoplayer.extractor.mp3.VbriSeeker;
import com.google.android.exoplayer.extractor.mp3.XingSeeker;
import com.google.android.exoplayer.util.MpegAudioHeader;
import com.google.android.exoplayer.util.ParsableByteArray;
import com.google.android.exoplayer.util.Util;
import java.io.EOFException;
import java.io.IOException;

public final class Mp3Extractor
implements Extractor {
    private static final int MAX_SYNC_BYTES = 131072;
    private static final int MAX_SNIFF_BYTES = 4096;
    private static final int HEADER_MASK = -128000;
    private static final int XING_HEADER = Util.getIntegerCodeForString("Xing");
    private static final int INFO_HEADER = Util.getIntegerCodeForString("Info");
    private static final int VBRI_HEADER = Util.getIntegerCodeForString("VBRI");
    private final long forcedFirstSampleTimestampUs;
    private final ParsableByteArray scratch;
    private final MpegAudioHeader synchronizedHeader;
    private ExtractorOutput extractorOutput;
    private TrackOutput trackOutput;
    private int synchronizedHeaderData;
    private GaplessInfo gaplessInfo;
    private Seeker seeker;
    private long basisTimeUs;
    private int samplesRead;
    private int sampleBytesRemaining;

    public Mp3Extractor() {
        this(-1L);
    }

    public Mp3Extractor(long l) {
        this.forcedFirstSampleTimestampUs = l;
        this.scratch = new ParsableByteArray(4);
        this.synchronizedHeader = new MpegAudioHeader();
        this.basisTimeUs = -1L;
    }

    @Override
    public boolean sniff(ExtractorInput extractorInput) throws IOException, InterruptedException {
        return this.synchronize(extractorInput, true);
    }

    @Override
    public void init(ExtractorOutput extractorOutput) {
        this.extractorOutput = extractorOutput;
        this.trackOutput = extractorOutput.track(0);
        extractorOutput.endTracks();
    }

    @Override
    public void seek() {
        this.synchronizedHeaderData = 0;
        this.samplesRead = 0;
        this.basisTimeUs = -1L;
        this.sampleBytesRemaining = 0;
    }

    @Override
    public void release() {
    }

    @Override
    public int read(ExtractorInput extractorInput, PositionHolder positionHolder) throws IOException, InterruptedException {
        if (this.synchronizedHeaderData == 0 && !this.synchronizeCatchingEndOfInput(extractorInput)) {
            return -1;
        }
        if (this.seeker == null) {
            this.setupSeeker(extractorInput);
            this.extractorOutput.seekMap(this.seeker);
            MediaFormat mediaFormat = MediaFormat.createAudioFormat(null, this.synchronizedHeader.mimeType, -1, 4096, this.seeker.getDurationUs(), this.synchronizedHeader.channels, this.synchronizedHeader.sampleRate, null, null);
            if (this.gaplessInfo != null) {
                mediaFormat = mediaFormat.copyWithGaplessInfo(this.gaplessInfo.encoderDelay, this.gaplessInfo.encoderPadding);
            }
            this.trackOutput.format(mediaFormat);
        }
        return this.readSample(extractorInput);
    }

    private int readSample(ExtractorInput extractorInput) throws IOException, InterruptedException {
        int n;
        if (this.sampleBytesRemaining == 0) {
            if (!this.maybeResynchronize(extractorInput)) {
                return -1;
            }
            if (this.basisTimeUs == -1L) {
                this.basisTimeUs = this.seeker.getTimeUs(extractorInput.getPosition());
                if (this.forcedFirstSampleTimestampUs != -1L) {
                    long l = this.seeker.getTimeUs(0L);
                    this.basisTimeUs += this.forcedFirstSampleTimestampUs - l;
                }
            }
            this.sampleBytesRemaining = this.synchronizedHeader.frameSize;
        }
        if ((n = this.trackOutput.sampleData(extractorInput, this.sampleBytesRemaining, true)) == -1) {
            return -1;
        }
        this.sampleBytesRemaining -= n;
        if (this.sampleBytesRemaining > 0) {
            return 0;
        }
        long l = this.basisTimeUs + (long)this.samplesRead * 1000000L / (long)this.synchronizedHeader.sampleRate;
        this.trackOutput.sampleMetadata(l, 1, this.synchronizedHeader.frameSize, 0, null);
        this.samplesRead += this.synchronizedHeader.samplesPerFrame;
        this.sampleBytesRemaining = 0;
        return 0;
    }

    private boolean maybeResynchronize(ExtractorInput extractorInput) throws IOException, InterruptedException {
        int n;
        extractorInput.resetPeekPosition();
        if (!extractorInput.peekFully(this.scratch.data, 0, 4, true)) {
            return false;
        }
        this.scratch.setPosition(0);
        int n2 = this.scratch.readInt();
        if ((n2 & 0xFFFE0C00) == (this.synchronizedHeaderData & 0xFFFE0C00) && (n = MpegAudioHeader.getFrameSize(n2)) != -1) {
            MpegAudioHeader.populateHeader(n2, this.synchronizedHeader);
            return true;
        }
        this.synchronizedHeaderData = 0;
        extractorInput.skipFully(1);
        return this.synchronizeCatchingEndOfInput(extractorInput);
    }

    private boolean synchronizeCatchingEndOfInput(ExtractorInput extractorInput) throws IOException, InterruptedException {
        try {
            return this.synchronize(extractorInput, false);
        }
        catch (EOFException eOFException) {
            return false;
        }
    }

    private boolean synchronize(ExtractorInput extractorInput, boolean bl) throws IOException, InterruptedException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        extractorInput.resetPeekPosition();
        if (extractorInput.getPosition() == 0L) {
            this.gaplessInfo = Id3Util.parseId3(extractorInput);
            n4 = (int)extractorInput.getPeekPosition();
            if (!bl) {
                extractorInput.skipFully(n4);
            }
        }
        while (true) {
            int n5;
            if (bl && n == 4096) {
                return false;
            }
            if (!bl && n == 131072) {
                throw new ParserException("Searched too many bytes.");
            }
            if (!extractorInput.peekFully(this.scratch.data, 0, 4, true)) {
                return false;
            }
            this.scratch.setPosition(0);
            int n6 = this.scratch.readInt();
            if (n3 != 0 && (n6 & 0xFFFE0C00) != (n3 & 0xFFFE0C00) || (n5 = MpegAudioHeader.getFrameSize(n6)) == -1) {
                n2 = 0;
                n3 = 0;
                ++n;
                if (bl) {
                    extractorInput.resetPeekPosition();
                    extractorInput.advancePeekPosition(n4 + n);
                    continue;
                }
                extractorInput.skipFully(1);
                continue;
            }
            if (++n2 == 1) {
                MpegAudioHeader.populateHeader(n6, this.synchronizedHeader);
                n3 = n6;
            } else if (n2 == 4) break;
            extractorInput.advancePeekPosition(n5 - 4);
        }
        if (bl) {
            extractorInput.skipFully(n4 + n);
        } else {
            extractorInput.resetPeekPosition();
        }
        this.synchronizedHeaderData = n3;
        return true;
    }

    private void setupSeeker(ExtractorInput extractorInput) throws IOException, InterruptedException {
        ParsableByteArray parsableByteArray = new ParsableByteArray(this.synchronizedHeader.frameSize);
        extractorInput.peekFully(parsableByteArray.data, 0, this.synchronizedHeader.frameSize);
        long l = extractorInput.getPosition();
        long l2 = extractorInput.getLength();
        int n = (this.synchronizedHeader.version & 1) != 0 ? (this.synchronizedHeader.channels != 1 ? 36 : 21) : (this.synchronizedHeader.channels != 1 ? 21 : 13);
        parsableByteArray.setPosition(n);
        int n2 = parsableByteArray.readInt();
        if (n2 == XING_HEADER || n2 == INFO_HEADER) {
            this.seeker = XingSeeker.create(this.synchronizedHeader, parsableByteArray, l, l2);
            if (this.seeker != null && this.gaplessInfo == null) {
                extractorInput.resetPeekPosition();
                extractorInput.advancePeekPosition(n + 141);
                extractorInput.peekFully(this.scratch.data, 0, 3);
                this.scratch.setPosition(0);
                this.gaplessInfo = GaplessInfo.createFromXingHeaderValue(this.scratch.readUnsignedInt24());
            }
            extractorInput.skipFully(this.synchronizedHeader.frameSize);
        } else {
            parsableByteArray.setPosition(36);
            n2 = parsableByteArray.readInt();
            if (n2 == VBRI_HEADER) {
                this.seeker = VbriSeeker.create(this.synchronizedHeader, parsableByteArray, l, l2);
                extractorInput.skipFully(this.synchronizedHeader.frameSize);
            }
        }
        if (this.seeker == null) {
            extractorInput.resetPeekPosition();
            extractorInput.peekFully(this.scratch.data, 0, 4);
            this.scratch.setPosition(0);
            MpegAudioHeader.populateHeader(this.scratch.readInt(), this.synchronizedHeader);
            this.seeker = new ConstantBitrateSeeker(extractorInput.getPosition(), this.synchronizedHeader.bitrate, l2);
        }
    }

    static interface Seeker
    extends SeekMap {
        public long getTimeUs(long var1);

        public long getDurationUs();
    }
}

