/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.dash.mpd;

import android.os.SystemClock;
import com.google.android.exoplayer.ParserException;
import com.google.android.exoplayer.dash.mpd.UtcTimingElement;
import com.google.android.exoplayer.upstream.Loader;
import com.google.android.exoplayer.upstream.UriDataSource;
import com.google.android.exoplayer.upstream.UriLoadable;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.CancellationException;

public final class UtcTimingElementResolver
implements Loader.Callback {
    private final UriDataSource uriDataSource;
    private final UtcTimingElement timingElement;
    private final long timingElementElapsedRealtime;
    private final UtcTimingCallback callback;
    private Loader singleUseLoader;
    private UriLoadable<Long> singleUseLoadable;

    public static void resolveTimingElement(UriDataSource uriDataSource, UtcTimingElement utcTimingElement, long l, UtcTimingCallback utcTimingCallback) {
        UtcTimingElementResolver utcTimingElementResolver = new UtcTimingElementResolver(uriDataSource, utcTimingElement, l, utcTimingCallback);
        utcTimingElementResolver.resolve();
    }

    private UtcTimingElementResolver(UriDataSource uriDataSource, UtcTimingElement utcTimingElement, long l, UtcTimingCallback utcTimingCallback) {
        this.uriDataSource = uriDataSource;
        this.timingElement = Assertions.checkNotNull(utcTimingElement);
        this.timingElementElapsedRealtime = l;
        this.callback = Assertions.checkNotNull(utcTimingCallback);
    }

    private void resolve() {
        String string = this.timingElement.schemeIdUri;
        if (Util.areEqual(string, "urn:mpeg:dash:utc:direct:2012")) {
            this.resolveDirect();
        } else if (Util.areEqual(string, "urn:mpeg:dash:utc:http-iso:2014")) {
            this.resolveHttp(new Iso8601Parser());
        } else if (Util.areEqual(string, "urn:mpeg:dash:utc:http-xsdate:2012") || Util.areEqual(string, "urn:mpeg:dash:utc:http-xsdate:2014")) {
            this.resolveHttp(new XsDateTimeParser());
        } else {
            this.callback.onTimestampError(this.timingElement, new IOException("Unsupported utc timing scheme"));
        }
    }

    private void resolveDirect() {
        try {
            long l = Util.parseXsDateTime(this.timingElement.value);
            long l2 = l - this.timingElementElapsedRealtime;
            this.callback.onTimestampResolved(this.timingElement, l2);
        }
        catch (ParseException parseException) {
            this.callback.onTimestampError(this.timingElement, new ParserException(parseException));
        }
    }

    private void resolveHttp(UriLoadable.Parser<Long> parser) {
        this.singleUseLoader = new Loader("utctiming");
        this.singleUseLoadable = new UriLoadable<Long>(this.timingElement.value, this.uriDataSource, parser);
        this.singleUseLoader.startLoading(this.singleUseLoadable, this);
    }

    @Override
    public void onLoadCanceled(Loader.Loadable loadable) {
        this.onLoadError(loadable, new IOException("Load cancelled", new CancellationException()));
    }

    @Override
    public void onLoadCompleted(Loader.Loadable loadable) {
        this.releaseLoader();
        long l = this.singleUseLoadable.getResult() - SystemClock.elapsedRealtime();
        this.callback.onTimestampResolved(this.timingElement, l);
    }

    @Override
    public void onLoadError(Loader.Loadable loadable, IOException iOException) {
        this.releaseLoader();
        this.callback.onTimestampError(this.timingElement, iOException);
    }

    private void releaseLoader() {
        this.singleUseLoader.release();
    }

    private static class Iso8601Parser
    implements UriLoadable.Parser<Long> {
        private Iso8601Parser() {
        }

        @Override
        public Long parse(String string, InputStream inputStream) throws ParserException, IOException {
            String string2 = new BufferedReader(new InputStreamReader(inputStream)).readLine();
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                return simpleDateFormat.parse(string2).getTime();
            }
            catch (ParseException parseException) {
                throw new ParserException(parseException);
            }
        }
    }

    private static class XsDateTimeParser
    implements UriLoadable.Parser<Long> {
        private XsDateTimeParser() {
        }

        @Override
        public Long parse(String string, InputStream inputStream) throws ParserException, IOException {
            String string2 = new BufferedReader(new InputStreamReader(inputStream)).readLine();
            try {
                return Util.parseXsDateTime(string2);
            }
            catch (ParseException parseException) {
                throw new ParserException(parseException);
            }
        }
    }

    public static interface UtcTimingCallback {
        public void onTimestampResolved(UtcTimingElement var1, long var2);

        public void onTimestampError(UtcTimingElement var1, IOException var2);
    }
}

