/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.dash.mpd;

import android.net.Uri;
import com.google.android.exoplayer.chunk.Format;
import com.google.android.exoplayer.chunk.FormatWrapper;
import com.google.android.exoplayer.dash.DashSegmentIndex;
import com.google.android.exoplayer.dash.mpd.DashSingleSegmentIndex;
import com.google.android.exoplayer.dash.mpd.RangedUri;
import com.google.android.exoplayer.dash.mpd.SegmentBase;

public abstract class Representation
implements FormatWrapper {
    public final String contentId;
    public final long revisionId;
    public final Format format;
    public final long presentationTimeOffsetUs;
    private final String cacheKey;
    private final RangedUri initializationUri;

    public static Representation newInstance(String string, long l, Format format, SegmentBase segmentBase) {
        return Representation.newInstance(string, l, format, segmentBase, null);
    }

    public static Representation newInstance(String string, long l, Format format, SegmentBase segmentBase, String string2) {
        if (segmentBase instanceof SegmentBase.SingleSegmentBase) {
            return new SingleSegmentRepresentation(string, l, format, (SegmentBase.SingleSegmentBase)segmentBase, string2, -1L);
        }
        if (segmentBase instanceof SegmentBase.MultiSegmentBase) {
            return new MultiSegmentRepresentation(string, l, format, (SegmentBase.MultiSegmentBase)segmentBase, string2);
        }
        throw new IllegalArgumentException("segmentBase must be of type SingleSegmentBase or MultiSegmentBase");
    }

    private Representation(String string, long l, Format format, SegmentBase segmentBase, String string2) {
        this.contentId = string;
        this.revisionId = l;
        this.format = format;
        this.cacheKey = string2 != null ? string2 : string + "." + format.id + "." + l;
        this.initializationUri = segmentBase.getInitialization(this);
        this.presentationTimeOffsetUs = segmentBase.getPresentationTimeOffsetUs();
    }

    @Override
    public Format getFormat() {
        return this.format;
    }

    public RangedUri getInitializationUri() {
        return this.initializationUri;
    }

    public abstract RangedUri getIndexUri();

    public abstract DashSegmentIndex getIndex();

    public String getCacheKey() {
        return this.cacheKey;
    }

    public static class MultiSegmentRepresentation
    extends Representation
    implements DashSegmentIndex {
        private final SegmentBase.MultiSegmentBase segmentBase;

        public MultiSegmentRepresentation(String string, long l, Format format, SegmentBase.MultiSegmentBase multiSegmentBase, String string2) {
            super(string, l, format, multiSegmentBase, string2);
            this.segmentBase = multiSegmentBase;
        }

        @Override
        public RangedUri getIndexUri() {
            return null;
        }

        @Override
        public DashSegmentIndex getIndex() {
            return this;
        }

        @Override
        public RangedUri getSegmentUrl(int n) {
            return this.segmentBase.getSegmentUrl(this, n);
        }

        @Override
        public int getSegmentNum(long l, long l2) {
            return this.segmentBase.getSegmentNum(l, l2);
        }

        @Override
        public long getTimeUs(int n) {
            return this.segmentBase.getSegmentTimeUs(n);
        }

        @Override
        public long getDurationUs(int n, long l) {
            return this.segmentBase.getSegmentDurationUs(n, l);
        }

        @Override
        public int getFirstSegmentNum() {
            return this.segmentBase.getFirstSegmentNum();
        }

        @Override
        public int getLastSegmentNum(long l) {
            return this.segmentBase.getLastSegmentNum(l);
        }

        @Override
        public boolean isExplicit() {
            return this.segmentBase.isExplicit();
        }
    }

    public static class SingleSegmentRepresentation
    extends Representation {
        public final Uri uri;
        public final long contentLength;
        private final RangedUri indexUri;
        private final DashSingleSegmentIndex segmentIndex;

        public static SingleSegmentRepresentation newInstance(String string, long l, Format format, String string2, long l2, long l3, long l4, long l5, String string3, long l6) {
            RangedUri rangedUri = new RangedUri(string2, null, l2, l3 - l2 + 1L);
            SegmentBase.SingleSegmentBase singleSegmentBase = new SegmentBase.SingleSegmentBase(rangedUri, 1L, 0L, string2, l4, l5 - l4 + 1L);
            return new SingleSegmentRepresentation(string, l, format, singleSegmentBase, string3, l6);
        }

        public SingleSegmentRepresentation(String string, long l, Format format, SegmentBase.SingleSegmentBase singleSegmentBase, String string2, long l2) {
            super(string, l, format, singleSegmentBase, string2);
            this.uri = Uri.parse((String)singleSegmentBase.uri);
            this.indexUri = singleSegmentBase.getIndex();
            this.contentLength = l2;
            this.segmentIndex = this.indexUri != null ? null : new DashSingleSegmentIndex(new RangedUri(singleSegmentBase.uri, null, 0L, l2));
        }

        @Override
        public RangedUri getIndexUri() {
            return this.indexUri;
        }

        @Override
        public DashSegmentIndex getIndex() {
            return this.segmentIndex;
        }
    }
}

