/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.chunk;

import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.chunk.Chunk;
import com.google.android.exoplayer.chunk.ChunkExtractorWrapper;
import com.google.android.exoplayer.chunk.Format;
import com.google.android.exoplayer.drm.DrmInitData;
import com.google.android.exoplayer.extractor.DefaultExtractorInput;
import com.google.android.exoplayer.extractor.ExtractorInput;
import com.google.android.exoplayer.extractor.SeekMap;
import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.util.ParsableByteArray;
import com.google.android.exoplayer.util.Util;
import java.io.IOException;

public final class InitializationChunk
extends Chunk
implements ChunkExtractorWrapper.SingleTrackOutput {
    private final ChunkExtractorWrapper extractorWrapper;
    private MediaFormat mediaFormat;
    private DrmInitData drmInitData;
    private SeekMap seekMap;
    private volatile int bytesLoaded;
    private volatile boolean loadCanceled;

    public InitializationChunk(DataSource dataSource, DataSpec dataSpec, int n, Format format, ChunkExtractorWrapper chunkExtractorWrapper) {
        this(dataSource, dataSpec, n, format, chunkExtractorWrapper, -1);
    }

    public InitializationChunk(DataSource dataSource, DataSpec dataSpec, int n, Format format, ChunkExtractorWrapper chunkExtractorWrapper, int n2) {
        super(dataSource, dataSpec, 2, n, format, n2);
        this.extractorWrapper = chunkExtractorWrapper;
    }

    @Override
    public long bytesLoaded() {
        return this.bytesLoaded;
    }

    public boolean hasFormat() {
        return this.mediaFormat != null;
    }

    public MediaFormat getFormat() {
        return this.mediaFormat;
    }

    public boolean hasDrmInitData() {
        return this.drmInitData != null;
    }

    public DrmInitData getDrmInitData() {
        return this.drmInitData;
    }

    public boolean hasSeekMap() {
        return this.seekMap != null;
    }

    public SeekMap getSeekMap() {
        return this.seekMap;
    }

    @Override
    public void seekMap(SeekMap seekMap) {
        this.seekMap = seekMap;
    }

    @Override
    public void drmInitData(DrmInitData drmInitData) {
        this.drmInitData = drmInitData;
    }

    @Override
    public void format(MediaFormat mediaFormat) {
        this.mediaFormat = mediaFormat;
    }

    @Override
    public int sampleData(ExtractorInput extractorInput, int n, boolean bl) throws IOException, InterruptedException {
        throw new IllegalStateException("Unexpected sample data in initialization chunk");
    }

    @Override
    public void sampleData(ParsableByteArray parsableByteArray, int n) {
        throw new IllegalStateException("Unexpected sample data in initialization chunk");
    }

    @Override
    public void sampleMetadata(long l, int n, int n2, int n3, byte[] byArray) {
        throw new IllegalStateException("Unexpected sample data in initialization chunk");
    }

    @Override
    public void cancelLoad() {
        this.loadCanceled = true;
    }

    @Override
    public boolean isLoadCanceled() {
        return this.loadCanceled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load() throws IOException, InterruptedException {
        DataSpec dataSpec = Util.getRemainderDataSpec(this.dataSpec, this.bytesLoaded);
        try {
            DefaultExtractorInput defaultExtractorInput = new DefaultExtractorInput(this.dataSource, dataSpec.absoluteStreamPosition, this.dataSource.open(dataSpec));
            if (this.bytesLoaded == 0) {
                this.extractorWrapper.init(this);
            }
            try {
                int n = 0;
                while (n == 0 && !this.loadCanceled) {
                    n = this.extractorWrapper.read(defaultExtractorInput);
                }
            }
            finally {
                this.bytesLoaded = (int)(defaultExtractorInput.getPosition() - this.dataSpec.absoluteStreamPosition);
            }
        }
        finally {
            this.dataSource.close();
        }
    }
}

