/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.chunk;

import com.google.android.exoplayer.chunk.Chunk;
import com.google.android.exoplayer.chunk.Format;
import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DataSpec;
import java.io.IOException;
import java.util.Arrays;

public abstract class DataChunk
extends Chunk {
    private static final int READ_GRANULARITY = 16384;
    private byte[] data;
    private int limit;
    private volatile boolean loadCanceled;

    public DataChunk(DataSource dataSource, DataSpec dataSpec, int n, int n2, Format format, int n3, byte[] byArray) {
        super(dataSource, dataSpec, n, n2, format, n3);
        this.data = byArray;
    }

    public byte[] getDataHolder() {
        return this.data;
    }

    @Override
    public long bytesLoaded() {
        return this.limit;
    }

    @Override
    public final void cancelLoad() {
        this.loadCanceled = true;
    }

    @Override
    public final boolean isLoadCanceled() {
        return this.loadCanceled;
    }

    @Override
    public final void load() throws IOException, InterruptedException {
        try {
            this.dataSource.open(this.dataSpec);
            this.limit = 0;
            int n = 0;
            while (n != -1 && !this.loadCanceled) {
                this.maybeExpandData();
                n = this.dataSource.read(this.data, this.limit, 16384);
                if (n == -1) continue;
                this.limit += n;
            }
            if (!this.loadCanceled) {
                this.consume(this.data, this.limit);
            }
        }
        finally {
            this.dataSource.close();
        }
    }

    protected abstract void consume(byte[] var1, int var2) throws IOException;

    private void maybeExpandData() {
        if (this.data == null) {
            this.data = new byte[16384];
        } else if (this.data.length < this.limit + 16384) {
            this.data = Arrays.copyOf(this.data, this.data.length + 16384);
        }
    }
}

