/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.view.Choreographer;
import android.view.WindowManager;

@TargetApi(value=16)
public final class VideoFrameReleaseTimeHelper {
    private static final long CHOREOGRAPHER_SAMPLE_DELAY_MILLIS = 500L;
    private static final long MAX_ALLOWED_DRIFT_NS = 20000000L;
    private static final long VSYNC_OFFSET_PERCENTAGE = 80L;
    private static final int MIN_FRAMES_FOR_ADJUSTMENT = 6;
    private final VSyncSampler vsyncSampler;
    private final boolean useDefaultDisplayVsync;
    private final long vsyncDurationNs;
    private final long vsyncOffsetNs;
    private long lastFramePresentationTimeUs;
    private long adjustedLastFrameTimeNs;
    private long pendingAdjustedFrameTimeNs;
    private boolean haveSync;
    private long syncUnadjustedReleaseTimeNs;
    private long syncFramePresentationTimeNs;
    private long frameCount;

    public VideoFrameReleaseTimeHelper() {
        this(-1.0f, false);
    }

    public VideoFrameReleaseTimeHelper(Context context) {
        this(VideoFrameReleaseTimeHelper.getDefaultDisplayRefreshRate(context), true);
    }

    private VideoFrameReleaseTimeHelper(float f2, boolean bl) {
        this.useDefaultDisplayVsync = bl;
        if (bl) {
            this.vsyncSampler = VSyncSampler.getInstance();
            this.vsyncDurationNs = (long)(1.0E9 / (double)f2);
            this.vsyncOffsetNs = this.vsyncDurationNs * 80L / 100L;
        } else {
            this.vsyncSampler = null;
            this.vsyncDurationNs = -1L;
            this.vsyncOffsetNs = -1L;
        }
    }

    public void enable() {
        this.haveSync = false;
        if (this.useDefaultDisplayVsync) {
            this.vsyncSampler.addObserver();
        }
    }

    public void disable() {
        if (this.useDefaultDisplayVsync) {
            this.vsyncSampler.removeObserver();
        }
    }

    public long adjustReleaseTime(long l, long l2) {
        long l3;
        long l4;
        long l5 = l4 = l * 1000L;
        long l6 = l2;
        if (this.haveSync) {
            if (l != this.lastFramePresentationTimeUs) {
                ++this.frameCount;
                this.adjustedLastFrameTimeNs = this.pendingAdjustedFrameTimeNs;
            }
            if (this.frameCount >= 6L) {
                l3 = (l4 - this.syncFramePresentationTimeNs) / this.frameCount;
                long l7 = this.adjustedLastFrameTimeNs + l3;
                if (this.isDriftTooLarge(l7, l2)) {
                    this.haveSync = false;
                } else {
                    l5 = l7;
                    l6 = this.syncUnadjustedReleaseTimeNs + l5 - this.syncFramePresentationTimeNs;
                }
            } else if (this.isDriftTooLarge(l4, l2)) {
                this.haveSync = false;
            }
        }
        if (!this.haveSync) {
            this.syncFramePresentationTimeNs = l4;
            this.syncUnadjustedReleaseTimeNs = l2;
            this.frameCount = 0L;
            this.haveSync = true;
            this.onSynced();
        }
        this.lastFramePresentationTimeUs = l;
        this.pendingAdjustedFrameTimeNs = l5;
        if (this.vsyncSampler == null || this.vsyncSampler.sampledVsyncTimeNs == 0L) {
            return l6;
        }
        l3 = VideoFrameReleaseTimeHelper.closestVsync(l6, this.vsyncSampler.sampledVsyncTimeNs, this.vsyncDurationNs);
        return l3 - this.vsyncOffsetNs;
    }

    protected void onSynced() {
    }

    private boolean isDriftTooLarge(long l, long l2) {
        long l3 = l2 - this.syncUnadjustedReleaseTimeNs;
        long l4 = l - this.syncFramePresentationTimeNs;
        return Math.abs(l3 - l4) > 20000000L;
    }

    private static long closestVsync(long l, long l2, long l3) {
        long l4;
        long l5;
        long l6 = (l - l2) / l3;
        long l7 = l2 + l3 * l6;
        if (l <= l7) {
            l5 = l7 - l3;
            l4 = l7;
        } else {
            l5 = l7;
            l4 = l7 + l3;
        }
        long l8 = l4 - l;
        long l9 = l - l5;
        return l8 < l9 ? l4 : l5;
    }

    private static float getDefaultDisplayRefreshRate(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        return windowManager.getDefaultDisplay().getRefreshRate();
    }

    private static final class VSyncSampler
    implements Handler.Callback,
    Choreographer.FrameCallback {
        public volatile long sampledVsyncTimeNs;
        private static final int CREATE_CHOREOGRAPHER = 0;
        private static final int MSG_ADD_OBSERVER = 1;
        private static final int MSG_REMOVE_OBSERVER = 2;
        private static final VSyncSampler INSTANCE = new VSyncSampler();
        private final Handler handler;
        private final HandlerThread choreographerOwnerThread = new HandlerThread("ChoreographerOwner:Handler");
        private Choreographer choreographer;
        private int observerCount;

        public static VSyncSampler getInstance() {
            return INSTANCE;
        }

        private VSyncSampler() {
            this.choreographerOwnerThread.start();
            this.handler = new Handler(this.choreographerOwnerThread.getLooper(), (Handler.Callback)this);
            this.handler.sendEmptyMessage(0);
        }

        public void addObserver() {
            this.handler.sendEmptyMessage(1);
        }

        public void removeObserver() {
            this.handler.sendEmptyMessage(2);
        }

        public void doFrame(long l) {
            this.sampledVsyncTimeNs = l;
            this.choreographer.postFrameCallbackDelayed((Choreographer.FrameCallback)this, 500L);
        }

        public boolean handleMessage(Message message) {
            switch (message.what) {
                case 0: {
                    this.createChoreographerInstanceInternal();
                    return true;
                }
                case 1: {
                    this.addObserverInternal();
                    return true;
                }
                case 2: {
                    this.removeObserverInternal();
                    return true;
                }
            }
            return false;
        }

        private void createChoreographerInstanceInternal() {
            this.choreographer = Choreographer.getInstance();
        }

        private void addObserverInternal() {
            ++this.observerCount;
            if (this.observerCount == 1) {
                this.choreographer.postFrameCallback((Choreographer.FrameCallback)this);
            }
        }

        private void removeObserverInternal() {
            --this.observerCount;
            if (this.observerCount == 0) {
                this.choreographer.removeFrameCallback((Choreographer.FrameCallback)this);
                this.sampledVsyncTimeNs = 0L;
            }
        }
    }
}

