/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer;

import com.google.android.exoplayer.ExoPlaybackException;
import com.google.android.exoplayer.ExoPlayer;
import com.google.android.exoplayer.MediaClock;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.util.Assertions;

public abstract class TrackRenderer
implements ExoPlayer.ExoPlayerComponent {
    public static final long UNKNOWN_TIME_US = -1L;
    public static final long MATCH_LONGEST_US = -2L;
    public static final long END_OF_TRACK_US = -3L;
    protected static final int STATE_RELEASED = -1;
    protected static final int STATE_UNPREPARED = 0;
    protected static final int STATE_PREPARED = 1;
    protected static final int STATE_ENABLED = 2;
    protected static final int STATE_STARTED = 3;
    private int state;

    protected MediaClock getMediaClock() {
        return null;
    }

    protected final int getState() {
        return this.state;
    }

    final int prepare(long l) throws ExoPlaybackException {
        Assertions.checkState(this.state == 0);
        this.state = this.doPrepare(l) ? 1 : 0;
        return this.state;
    }

    protected abstract boolean doPrepare(long var1) throws ExoPlaybackException;

    protected abstract int getTrackCount();

    protected abstract MediaFormat getFormat(int var1);

    final void enable(int n, long l, boolean bl) throws ExoPlaybackException {
        Assertions.checkState(this.state == 1);
        this.state = 2;
        this.onEnabled(n, l, bl);
    }

    protected void onEnabled(int n, long l, boolean bl) throws ExoPlaybackException {
    }

    final void start() throws ExoPlaybackException {
        Assertions.checkState(this.state == 2);
        this.state = 3;
        this.onStarted();
    }

    protected void onStarted() throws ExoPlaybackException {
    }

    final void stop() throws ExoPlaybackException {
        Assertions.checkState(this.state == 3);
        this.state = 2;
        this.onStopped();
    }

    protected void onStopped() throws ExoPlaybackException {
    }

    final void disable() throws ExoPlaybackException {
        Assertions.checkState(this.state == 2);
        this.state = 1;
        this.onDisabled();
    }

    protected void onDisabled() throws ExoPlaybackException {
    }

    final void release() throws ExoPlaybackException {
        Assertions.checkState(this.state != 2 && this.state != 3 && this.state != -1);
        this.state = -1;
        this.onReleased();
    }

    protected void onReleased() throws ExoPlaybackException {
    }

    protected abstract boolean isEnded();

    protected abstract boolean isReady();

    protected abstract void doSomeWork(long var1, long var3) throws ExoPlaybackException;

    protected abstract void maybeThrowError() throws ExoPlaybackException;

    protected abstract long getDurationUs();

    protected abstract long getBufferedPositionUs();

    protected abstract void seekTo(long var1) throws ExoPlaybackException;

    @Override
    public void handleMessage(int n, Object object) throws ExoPlaybackException {
    }
}

