/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.Util;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class MediaFormat {
    public static final int NO_VALUE = -1;
    public static final long OFFSET_SAMPLE_RELATIVE = Long.MAX_VALUE;
    public final String trackId;
    public final String mimeType;
    public final int bitrate;
    public final int maxInputSize;
    public final long durationUs;
    public final List<byte[]> initializationData;
    public final boolean adaptive;
    public final int width;
    public final int height;
    public final int maxWidth;
    public final int maxHeight;
    public final int rotationDegrees;
    public final float pixelWidthHeightRatio;
    public final int channelCount;
    public final int sampleRate;
    public final int encoderDelay;
    public final int encoderPadding;
    public final String language;
    public final long subsampleOffsetUs;
    private int hashCode;
    private android.media.MediaFormat frameworkMediaFormat;

    public static MediaFormat createVideoFormat(String string, String string2, int n, int n2, long l, int n3, int n4, List<byte[]> list) {
        return MediaFormat.createVideoFormat(string, string2, n, n2, l, n3, n4, list, -1, -1.0f);
    }

    public static MediaFormat createVideoFormat(String string, String string2, int n, int n2, long l, int n3, int n4, List<byte[]> list, int n5, float f2) {
        return new MediaFormat(string, string2, n, n2, l, n3, n4, n5, f2, -1, -1, null, Long.MAX_VALUE, list, false, -1, -1, -1, -1);
    }

    public static MediaFormat createAudioFormat(String string, String string2, int n, int n2, long l, int n3, int n4, List<byte[]> list, String string3) {
        return new MediaFormat(string, string2, n, n2, l, -1, -1, -1, -1.0f, n3, n4, string3, Long.MAX_VALUE, list, false, -1, -1, -1, -1);
    }

    public static MediaFormat createTextFormat(String string, String string2, int n, long l, String string3) {
        return MediaFormat.createTextFormat(string, string2, n, l, string3, Long.MAX_VALUE);
    }

    public static MediaFormat createTextFormat(String string, String string2, int n, long l, String string3, long l2) {
        return new MediaFormat(string, string2, n, -1, l, -1, -1, -1, -1.0f, -1, -1, string3, l2, null, false, -1, -1, -1, -1);
    }

    public static MediaFormat createImageFormat(String string, String string2, int n, long l, List<byte[]> list, String string3) {
        return new MediaFormat(string, string2, n, -1, l, -1, -1, -1, -1.0f, -1, -1, string3, Long.MAX_VALUE, list, false, -1, -1, -1, -1);
    }

    public static MediaFormat createFormatForMimeType(String string, String string2, int n, long l) {
        return new MediaFormat(string, string2, n, -1, l, -1, -1, -1, -1.0f, -1, -1, null, Long.MAX_VALUE, null, false, -1, -1, -1, -1);
    }

    public static MediaFormat createId3Format() {
        return MediaFormat.createFormatForMimeType(null, "application/id3", -1, -1L);
    }

    MediaFormat(String string, String string2, int n, int n2, long l, int n3, int n4, int n5, float f2, int n6, int n7, String string3, long l2, List<byte[]> list, boolean bl, int n8, int n9, int n10, int n11) {
        this.trackId = string;
        this.mimeType = Assertions.checkNotEmpty(string2);
        this.bitrate = n;
        this.maxInputSize = n2;
        this.durationUs = l;
        this.width = n3;
        this.height = n4;
        this.rotationDegrees = n5;
        this.pixelWidthHeightRatio = f2;
        this.channelCount = n6;
        this.sampleRate = n7;
        this.language = string3;
        this.subsampleOffsetUs = l2;
        this.initializationData = list == null ? Collections.emptyList() : list;
        this.adaptive = bl;
        this.maxWidth = n8;
        this.maxHeight = n9;
        this.encoderDelay = n10;
        this.encoderPadding = n11;
    }

    public MediaFormat copyWithMaxInputSize(int n) {
        return new MediaFormat(this.trackId, this.mimeType, this.bitrate, n, this.durationUs, this.width, this.height, this.rotationDegrees, this.pixelWidthHeightRatio, this.channelCount, this.sampleRate, this.language, this.subsampleOffsetUs, this.initializationData, this.adaptive, this.maxWidth, this.maxHeight, this.encoderDelay, this.encoderPadding);
    }

    public MediaFormat copyWithMaxVideoDimensions(int n, int n2) {
        return new MediaFormat(this.trackId, this.mimeType, this.bitrate, this.maxInputSize, this.durationUs, this.width, this.height, this.rotationDegrees, this.pixelWidthHeightRatio, this.channelCount, this.sampleRate, this.language, this.subsampleOffsetUs, this.initializationData, this.adaptive, n, n2, this.encoderDelay, this.encoderPadding);
    }

    public MediaFormat copyWithSubsampleOffsetUs(long l) {
        return new MediaFormat(this.trackId, this.mimeType, this.bitrate, this.maxInputSize, this.durationUs, this.width, this.height, this.rotationDegrees, this.pixelWidthHeightRatio, this.channelCount, this.sampleRate, this.language, l, this.initializationData, this.adaptive, this.maxWidth, this.maxHeight, this.encoderDelay, this.encoderPadding);
    }

    public MediaFormat copyWithDurationUs(long l) {
        return new MediaFormat(this.trackId, this.mimeType, this.bitrate, this.maxInputSize, l, this.width, this.height, this.rotationDegrees, this.pixelWidthHeightRatio, this.channelCount, this.sampleRate, this.language, this.subsampleOffsetUs, this.initializationData, this.adaptive, this.maxWidth, this.maxHeight, this.encoderDelay, this.encoderPadding);
    }

    public MediaFormat copyWithLanguage(String string) {
        return new MediaFormat(this.trackId, this.mimeType, this.bitrate, this.maxInputSize, this.durationUs, this.width, this.height, this.rotationDegrees, this.pixelWidthHeightRatio, this.channelCount, this.sampleRate, string, this.subsampleOffsetUs, this.initializationData, this.adaptive, this.maxWidth, this.maxHeight, this.encoderDelay, this.encoderPadding);
    }

    public MediaFormat copyWithFixedTrackInfo(String string, int n, int n2, int n3, String string2) {
        return new MediaFormat(string, this.mimeType, n, this.maxInputSize, this.durationUs, n2, n3, this.rotationDegrees, this.pixelWidthHeightRatio, this.channelCount, this.sampleRate, string2, this.subsampleOffsetUs, this.initializationData, this.adaptive, -1, -1, this.encoderDelay, this.encoderPadding);
    }

    public MediaFormat copyAsAdaptive(String string) {
        return new MediaFormat(string, this.mimeType, -1, -1, this.durationUs, -1, -1, -1, -1.0f, -1, -1, null, Long.MAX_VALUE, null, true, this.maxWidth, this.maxHeight, -1, -1);
    }

    public MediaFormat copyWithGaplessInfo(int n, int n2) {
        return new MediaFormat(this.trackId, this.mimeType, this.bitrate, this.maxInputSize, this.durationUs, this.width, this.height, this.rotationDegrees, this.pixelWidthHeightRatio, this.channelCount, this.sampleRate, this.language, this.subsampleOffsetUs, this.initializationData, this.adaptive, this.maxWidth, this.maxHeight, n, n2);
    }

    @SuppressLint(value={"InlinedApi"})
    @TargetApi(value=16)
    public final android.media.MediaFormat getFrameworkMediaFormatV16() {
        if (this.frameworkMediaFormat == null) {
            android.media.MediaFormat mediaFormat = new android.media.MediaFormat();
            mediaFormat.setString("mime", this.mimeType);
            MediaFormat.maybeSetStringV16(mediaFormat, "language", this.language);
            MediaFormat.maybeSetIntegerV16(mediaFormat, "max-input-size", this.maxInputSize);
            MediaFormat.maybeSetIntegerV16(mediaFormat, "width", this.width);
            MediaFormat.maybeSetIntegerV16(mediaFormat, "height", this.height);
            MediaFormat.maybeSetIntegerV16(mediaFormat, "rotation-degrees", this.rotationDegrees);
            MediaFormat.maybeSetIntegerV16(mediaFormat, "max-width", this.maxWidth);
            MediaFormat.maybeSetIntegerV16(mediaFormat, "max-height", this.maxHeight);
            MediaFormat.maybeSetIntegerV16(mediaFormat, "channel-count", this.channelCount);
            MediaFormat.maybeSetIntegerV16(mediaFormat, "sample-rate", this.sampleRate);
            MediaFormat.maybeSetIntegerV16(mediaFormat, "encoder-delay", this.encoderDelay);
            MediaFormat.maybeSetIntegerV16(mediaFormat, "encoder-padding", this.encoderPadding);
            for (int i = 0; i < this.initializationData.size(); ++i) {
                mediaFormat.setByteBuffer("csd-" + i, ByteBuffer.wrap(this.initializationData.get(i)));
            }
            if (this.durationUs != -1L) {
                mediaFormat.setLong("durationUs", this.durationUs);
            }
            this.frameworkMediaFormat = mediaFormat;
        }
        return this.frameworkMediaFormat;
    }

    @Deprecated
    @TargetApi(value=16)
    final void setFrameworkFormatV16(android.media.MediaFormat mediaFormat) {
        this.frameworkMediaFormat = mediaFormat;
    }

    public String toString() {
        return "MediaFormat(" + this.trackId + ", " + this.mimeType + ", " + this.bitrate + ", " + this.maxInputSize + ", " + this.width + ", " + this.height + ", " + this.rotationDegrees + ", " + this.pixelWidthHeightRatio + ", " + this.channelCount + ", " + this.sampleRate + ", " + this.language + ", " + this.durationUs + ", " + this.adaptive + ", " + this.maxWidth + ", " + this.maxHeight + ", " + this.encoderDelay + ", " + this.encoderPadding + ")";
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int n = 17;
            n = 31 * n + (this.trackId == null ? 0 : this.trackId.hashCode());
            n = 31 * n + (this.mimeType == null ? 0 : this.mimeType.hashCode());
            n = 31 * n + this.bitrate;
            n = 31 * n + this.maxInputSize;
            n = 31 * n + this.width;
            n = 31 * n + this.height;
            n = 31 * n + this.rotationDegrees;
            n = 31 * n + Float.floatToRawIntBits(this.pixelWidthHeightRatio);
            n = 31 * n + (int)this.durationUs;
            n = 31 * n + (this.adaptive ? 1231 : 1237);
            n = 31 * n + this.maxWidth;
            n = 31 * n + this.maxHeight;
            n = 31 * n + this.encoderDelay;
            n = 31 * n + this.encoderPadding;
            n = 31 * n + this.channelCount;
            n = 31 * n + this.sampleRate;
            n = 31 * n + (this.language == null ? 0 : this.language.hashCode());
            for (int i = 0; i < this.initializationData.size(); ++i) {
                n = 31 * n + Arrays.hashCode(this.initializationData.get(i));
            }
            this.hashCode = n;
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MediaFormat mediaFormat = (MediaFormat)object;
        if (!(this.adaptive == mediaFormat.adaptive && this.bitrate == mediaFormat.bitrate && this.maxInputSize == mediaFormat.maxInputSize && this.width == mediaFormat.width && this.height == mediaFormat.height && this.rotationDegrees == mediaFormat.rotationDegrees && this.pixelWidthHeightRatio == mediaFormat.pixelWidthHeightRatio && this.maxWidth == mediaFormat.maxWidth && this.maxHeight == mediaFormat.maxHeight && this.encoderDelay == mediaFormat.encoderDelay && this.encoderPadding == mediaFormat.encoderPadding && this.channelCount == mediaFormat.channelCount && this.sampleRate == mediaFormat.sampleRate && Util.areEqual(this.trackId, mediaFormat.trackId) && Util.areEqual(this.language, mediaFormat.language) && Util.areEqual(this.mimeType, mediaFormat.mimeType) && this.initializationData.size() == mediaFormat.initializationData.size())) {
            return false;
        }
        for (int i = 0; i < this.initializationData.size(); ++i) {
            if (Arrays.equals(this.initializationData.get(i), mediaFormat.initializationData.get(i))) continue;
            return false;
        }
        return true;
    }

    @TargetApi(value=16)
    private static final void maybeSetStringV16(android.media.MediaFormat mediaFormat, String string, String string2) {
        if (string2 != null) {
            mediaFormat.setString(string, string2);
        }
    }

    @TargetApi(value=16)
    private static final void maybeSetIntegerV16(android.media.MediaFormat mediaFormat, String string, int n) {
        if (n != -1) {
            mediaFormat.setInteger(string, n);
        }
    }
}

