/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaCrypto;
import android.os.Handler;
import android.os.SystemClock;
import com.google.android.exoplayer.CodecCounters;
import com.google.android.exoplayer.DecoderInfo;
import com.google.android.exoplayer.ExoPlaybackException;
import com.google.android.exoplayer.MediaCodecSelector;
import com.google.android.exoplayer.MediaCodecUtil;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.MediaFormatHolder;
import com.google.android.exoplayer.SampleHolder;
import com.google.android.exoplayer.SampleSource;
import com.google.android.exoplayer.SampleSourceTrackRenderer;
import com.google.android.exoplayer.drm.DrmInitData;
import com.google.android.exoplayer.drm.DrmSessionManager;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.NalUnitUtil;
import com.google.android.exoplayer.util.TraceUtil;
import com.google.android.exoplayer.util.Util;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

@TargetApi(value=16)
public abstract class MediaCodecTrackRenderer
extends SampleSourceTrackRenderer {
    protected static final int SOURCE_STATE_NOT_READY = 0;
    protected static final int SOURCE_STATE_READY = 1;
    protected static final int SOURCE_STATE_READY_READ_MAY_FAIL = 2;
    private static final long MAX_CODEC_HOTSWAP_TIME_MS = 1000L;
    private static final int RECONFIGURATION_STATE_NONE = 0;
    private static final int RECONFIGURATION_STATE_WRITE_PENDING = 1;
    private static final int RECONFIGURATION_STATE_QUEUE_PENDING = 2;
    private static final int REINITIALIZATION_STATE_NONE = 0;
    private static final int REINITIALIZATION_STATE_SIGNAL_END_OF_STREAM = 1;
    private static final int REINITIALIZATION_STATE_WAIT_END_OF_STREAM = 2;
    public final CodecCounters codecCounters;
    private final MediaCodecSelector mediaCodecSelector;
    private final DrmSessionManager drmSessionManager;
    private final boolean playClearSamplesWithoutKeys;
    private final SampleHolder sampleHolder;
    private final MediaFormatHolder formatHolder;
    private final List<Long> decodeOnlyPresentationTimestamps;
    private final MediaCodec.BufferInfo outputBufferInfo;
    private final EventListener eventListener;
    private final boolean deviceNeedsAutoFrcWorkaround;
    protected final Handler eventHandler;
    private MediaFormat format;
    private DrmInitData drmInitData;
    private MediaCodec codec;
    private boolean codecIsAdaptive;
    private boolean codecNeedsDiscardToSpsWorkaround;
    private boolean codecNeedsFlushWorkaround;
    private boolean codecNeedsEosPropagationWorkaround;
    private boolean codecNeedsEosFlushWorkaround;
    private boolean codecNeedsMonoChannelCountWorkaround;
    private ByteBuffer[] inputBuffers;
    private ByteBuffer[] outputBuffers;
    private long codecHotswapTimeMs;
    private int inputIndex;
    private int outputIndex;
    private boolean openedDrmSession;
    private boolean codecReconfigured;
    private int codecReconfigurationState;
    private int codecReinitializationState;
    private boolean codecReceivedBuffers;
    private boolean codecReceivedEos;
    private int sourceState;
    private boolean inputStreamEnded;
    private boolean outputStreamEnded;
    private boolean waitingForKeys;
    private boolean waitingForFirstSyncFrame;

    public MediaCodecTrackRenderer(SampleSource sampleSource, MediaCodecSelector mediaCodecSelector, DrmSessionManager drmSessionManager, boolean bl, Handler handler, EventListener eventListener) {
        this(new SampleSource[]{sampleSource}, mediaCodecSelector, drmSessionManager, bl, handler, eventListener);
    }

    public MediaCodecTrackRenderer(SampleSource[] sampleSourceArray, MediaCodecSelector mediaCodecSelector, DrmSessionManager drmSessionManager, boolean bl, Handler handler, EventListener eventListener) {
        super(sampleSourceArray);
        Assertions.checkState(Util.SDK_INT >= 16);
        this.mediaCodecSelector = Assertions.checkNotNull(mediaCodecSelector);
        this.drmSessionManager = drmSessionManager;
        this.playClearSamplesWithoutKeys = bl;
        this.eventHandler = handler;
        this.eventListener = eventListener;
        this.deviceNeedsAutoFrcWorkaround = MediaCodecTrackRenderer.deviceNeedsAutoFrcWorkaround();
        this.codecCounters = new CodecCounters();
        this.sampleHolder = new SampleHolder(0);
        this.formatHolder = new MediaFormatHolder();
        this.decodeOnlyPresentationTimestamps = new ArrayList<Long>();
        this.outputBufferInfo = new MediaCodec.BufferInfo();
        this.codecReconfigurationState = 0;
        this.codecReinitializationState = 0;
    }

    @Override
    protected final boolean handlesTrack(MediaFormat mediaFormat) throws MediaCodecUtil.DecoderQueryException {
        return this.handlesTrack(this.mediaCodecSelector, mediaFormat);
    }

    protected abstract boolean handlesTrack(MediaCodecSelector var1, MediaFormat var2) throws MediaCodecUtil.DecoderQueryException;

    protected DecoderInfo getDecoderInfo(MediaCodecSelector mediaCodecSelector, String string, boolean bl) throws MediaCodecUtil.DecoderQueryException {
        return mediaCodecSelector.getDecoderInfo(string, bl);
    }

    protected abstract void configureCodec(MediaCodec var1, boolean var2, android.media.MediaFormat var3, MediaCrypto var4);

    protected final void maybeInitCodec() throws ExoPlaybackException {
        if (!this.shouldInitCodec()) {
            return;
        }
        String string = this.format.mimeType;
        MediaCrypto mediaCrypto = null;
        boolean bl = false;
        if (this.drmInitData != null) {
            int n;
            if (this.drmSessionManager == null) {
                throw new ExoPlaybackException("Media requires a DrmSessionManager");
            }
            if (!this.openedDrmSession) {
                this.drmSessionManager.open(this.drmInitData);
                this.openedDrmSession = true;
            }
            if ((n = this.drmSessionManager.getState()) == 0) {
                throw new ExoPlaybackException(this.drmSessionManager.getError());
            }
            if (n == 3 || n == 4) {
                mediaCrypto = this.drmSessionManager.getMediaCrypto();
                bl = this.drmSessionManager.requiresSecureDecoderComponent(string);
            } else {
                return;
            }
        }
        DecoderInfo decoderInfo = null;
        try {
            decoderInfo = this.getDecoderInfo(this.mediaCodecSelector, string, bl);
        }
        catch (MediaCodecUtil.DecoderQueryException decoderQueryException) {
            this.notifyAndThrowDecoderInitError(new DecoderInitializationException(this.format, (Throwable)decoderQueryException, bl, -49998));
        }
        if (decoderInfo == null) {
            this.notifyAndThrowDecoderInitError(new DecoderInitializationException(this.format, null, bl, -49999));
        }
        String string2 = decoderInfo.name;
        this.codecIsAdaptive = decoderInfo.adaptive;
        this.codecNeedsDiscardToSpsWorkaround = MediaCodecTrackRenderer.codecNeedsDiscardToSpsWorkaround(string2, this.format);
        this.codecNeedsFlushWorkaround = MediaCodecTrackRenderer.codecNeedsFlushWorkaround(string2);
        this.codecNeedsEosPropagationWorkaround = MediaCodecTrackRenderer.codecNeedsEosPropagationWorkaround(string2);
        this.codecNeedsEosFlushWorkaround = MediaCodecTrackRenderer.codecNeedsEosFlushWorkaround(string2);
        this.codecNeedsMonoChannelCountWorkaround = MediaCodecTrackRenderer.codecNeedsMonoChannelCountWorkaround(string2, this.format);
        try {
            long l = SystemClock.elapsedRealtime();
            TraceUtil.beginSection("createByCodecName(" + string2 + ")");
            this.codec = MediaCodec.createByCodecName((String)string2);
            TraceUtil.endSection();
            TraceUtil.beginSection("configureCodec");
            this.configureCodec(this.codec, decoderInfo.adaptive, this.getFrameworkMediaFormat(this.format), mediaCrypto);
            TraceUtil.endSection();
            TraceUtil.beginSection("codec.start()");
            this.codec.start();
            TraceUtil.endSection();
            long l2 = SystemClock.elapsedRealtime();
            this.notifyDecoderInitialized(string2, l2, l2 - l);
            this.inputBuffers = this.codec.getInputBuffers();
            this.outputBuffers = this.codec.getOutputBuffers();
        }
        catch (Exception exception) {
            this.notifyAndThrowDecoderInitError(new DecoderInitializationException(this.format, (Throwable)exception, bl, string2));
        }
        this.codecHotswapTimeMs = this.getState() == 3 ? SystemClock.elapsedRealtime() : -1L;
        this.inputIndex = -1;
        this.outputIndex = -1;
        this.waitingForFirstSyncFrame = true;
        ++this.codecCounters.codecInitCount;
    }

    private void notifyAndThrowDecoderInitError(DecoderInitializationException decoderInitializationException) throws ExoPlaybackException {
        this.notifyDecoderInitializationError(decoderInitializationException);
        throw new ExoPlaybackException(decoderInitializationException);
    }

    protected boolean shouldInitCodec() {
        return this.codec == null && this.format != null;
    }

    protected final boolean codecInitialized() {
        return this.codec != null;
    }

    protected final boolean haveFormat() {
        return this.format != null;
    }

    @Override
    protected void onDisabled() throws ExoPlaybackException {
        this.format = null;
        this.drmInitData = null;
        try {
            this.releaseCodec();
        }
        finally {
            try {
                if (this.openedDrmSession) {
                    this.drmSessionManager.close();
                    this.openedDrmSession = false;
                }
            }
            finally {
                super.onDisabled();
            }
        }
    }

    protected void releaseCodec() {
        if (this.codec != null) {
            this.codecHotswapTimeMs = -1L;
            this.inputIndex = -1;
            this.outputIndex = -1;
            this.waitingForKeys = false;
            this.decodeOnlyPresentationTimestamps.clear();
            this.inputBuffers = null;
            this.outputBuffers = null;
            this.codecReconfigured = false;
            this.codecReceivedBuffers = false;
            this.codecIsAdaptive = false;
            this.codecNeedsDiscardToSpsWorkaround = false;
            this.codecNeedsFlushWorkaround = false;
            this.codecNeedsEosPropagationWorkaround = false;
            this.codecNeedsEosFlushWorkaround = false;
            this.codecNeedsMonoChannelCountWorkaround = false;
            this.codecReceivedEos = false;
            this.codecReconfigurationState = 0;
            this.codecReinitializationState = 0;
            ++this.codecCounters.codecReleaseCount;
            try {
                this.codec.stop();
            }
            finally {
                try {
                    this.codec.release();
                }
                finally {
                    this.codec = null;
                }
            }
        }
    }

    @Override
    protected void onDiscontinuity(long l) throws ExoPlaybackException {
        this.sourceState = 0;
        this.inputStreamEnded = false;
        this.outputStreamEnded = false;
        if (this.codec != null) {
            this.flushCodec();
        }
    }

    @Override
    protected void onStarted() {
    }

    @Override
    protected void onStopped() {
    }

    @Override
    protected void doSomeWork(long l, long l2, boolean bl) throws ExoPlaybackException {
        int n = bl ? (this.sourceState == 0 ? 1 : this.sourceState) : (this.sourceState = 0);
        if (this.format == null) {
            this.readFormat(l);
        }
        this.maybeInitCodec();
        if (this.codec != null) {
            TraceUtil.beginSection("drainAndFeed");
            while (this.drainOutputBuffer(l, l2)) {
            }
            if (this.feedInputBuffer(l, true)) {
                while (this.feedInputBuffer(l, false)) {
                }
            }
            TraceUtil.endSection();
        }
        this.codecCounters.ensureUpdated();
    }

    private void readFormat(long l) throws ExoPlaybackException {
        int n = this.readSource(l, this.formatHolder, null);
        if (n == -4) {
            this.onInputFormatChanged(this.formatHolder);
        }
    }

    private void flushCodec() throws ExoPlaybackException {
        this.codecHotswapTimeMs = -1L;
        this.inputIndex = -1;
        this.outputIndex = -1;
        this.waitingForFirstSyncFrame = true;
        this.waitingForKeys = false;
        this.decodeOnlyPresentationTimestamps.clear();
        if (this.codecNeedsFlushWorkaround || this.codecNeedsEosFlushWorkaround && this.codecReceivedEos) {
            this.releaseCodec();
            this.maybeInitCodec();
        } else if (this.codecReinitializationState != 0) {
            this.releaseCodec();
            this.maybeInitCodec();
        } else {
            this.codec.flush();
            this.codecReceivedBuffers = false;
        }
        if (this.codecReconfigured && this.format != null) {
            this.codecReconfigurationState = 1;
        }
    }

    private boolean feedInputBuffer(long l, boolean bl) throws ExoPlaybackException {
        int n;
        int n2;
        if (this.inputStreamEnded || this.codecReinitializationState == 2) {
            return false;
        }
        if (this.inputIndex < 0) {
            this.inputIndex = this.codec.dequeueInputBuffer(0L);
            if (this.inputIndex < 0) {
                return false;
            }
            this.sampleHolder.data = this.inputBuffers[this.inputIndex];
            this.sampleHolder.clearData();
        }
        if (this.codecReinitializationState == 1) {
            if (!this.codecNeedsEosPropagationWorkaround) {
                this.codecReceivedEos = true;
                this.codec.queueInputBuffer(this.inputIndex, 0, 0, 0L, 4);
                this.inputIndex = -1;
            }
            this.codecReinitializationState = 2;
            return false;
        }
        if (this.waitingForKeys) {
            n2 = -3;
        } else {
            if (this.codecReconfigurationState == 1) {
                for (n = 0; n < this.format.initializationData.size(); n += 1) {
                    byte[] byArray = this.format.initializationData.get(n);
                    this.sampleHolder.data.put(byArray);
                }
                this.codecReconfigurationState = 2;
            }
            n2 = this.readSource(l, this.formatHolder, this.sampleHolder);
            if (bl && this.sourceState == 1 && n2 == -2) {
                this.sourceState = 2;
            }
        }
        if (n2 == -2) {
            return false;
        }
        if (n2 == -4) {
            if (this.codecReconfigurationState == 2) {
                this.sampleHolder.clearData();
                this.codecReconfigurationState = 1;
            }
            this.onInputFormatChanged(this.formatHolder);
            return true;
        }
        if (n2 == -1) {
            if (this.codecReconfigurationState == 2) {
                this.sampleHolder.clearData();
                this.codecReconfigurationState = 1;
            }
            this.inputStreamEnded = true;
            if (!this.codecReceivedBuffers) {
                this.processEndOfStream();
                return false;
            }
            try {
                if (!this.codecNeedsEosPropagationWorkaround) {
                    this.codecReceivedEos = true;
                    this.codec.queueInputBuffer(this.inputIndex, 0, 0, 0L, 4);
                    this.inputIndex = -1;
                }
            }
            catch (MediaCodec.CryptoException cryptoException) {
                this.notifyCryptoError(cryptoException);
                throw new ExoPlaybackException(cryptoException);
            }
            return false;
        }
        if (this.waitingForFirstSyncFrame) {
            if (!this.sampleHolder.isSyncFrame()) {
                this.sampleHolder.clearData();
                if (this.codecReconfigurationState == 2) {
                    this.codecReconfigurationState = 1;
                }
                return true;
            }
            this.waitingForFirstSyncFrame = false;
        }
        n = this.sampleHolder.isEncrypted() ? 1 : 0;
        this.waitingForKeys = this.shouldWaitForKeys(n != 0);
        if (this.waitingForKeys) {
            return false;
        }
        if (this.codecNeedsDiscardToSpsWorkaround && !n) {
            NalUnitUtil.discardToSps(this.sampleHolder.data);
            if (this.sampleHolder.data.position() == 0) {
                return true;
            }
            this.codecNeedsDiscardToSpsWorkaround = false;
        }
        try {
            int n3 = this.sampleHolder.data.position();
            int n4 = n3 - this.sampleHolder.size;
            long l2 = this.sampleHolder.timeUs;
            if (this.sampleHolder.isDecodeOnly()) {
                this.decodeOnlyPresentationTimestamps.add(l2);
            }
            this.onQueuedInputBuffer(l2, this.sampleHolder.data, n3, n != 0);
            if (n) {
                MediaCodec.CryptoInfo cryptoInfo = MediaCodecTrackRenderer.getFrameworkCryptoInfo(this.sampleHolder, n4);
                this.codec.queueSecureInputBuffer(this.inputIndex, 0, cryptoInfo, l2, 0);
            } else {
                this.codec.queueInputBuffer(this.inputIndex, 0, n3, l2, 0);
            }
            this.inputIndex = -1;
            this.codecReceivedBuffers = true;
            this.codecReconfigurationState = 0;
            ++this.codecCounters.inputBufferCount;
        }
        catch (MediaCodec.CryptoException cryptoException) {
            this.notifyCryptoError(cryptoException);
            throw new ExoPlaybackException(cryptoException);
        }
        return true;
    }

    private static MediaCodec.CryptoInfo getFrameworkCryptoInfo(SampleHolder sampleHolder, int n) {
        MediaCodec.CryptoInfo cryptoInfo = sampleHolder.cryptoInfo.getFrameworkCryptoInfoV16();
        if (n == 0) {
            return cryptoInfo;
        }
        if (cryptoInfo.numBytesOfClearData == null) {
            cryptoInfo.numBytesOfClearData = new int[1];
        }
        cryptoInfo.numBytesOfClearData[0] = cryptoInfo.numBytesOfClearData[0] + n;
        return cryptoInfo;
    }

    private android.media.MediaFormat getFrameworkMediaFormat(MediaFormat mediaFormat) {
        android.media.MediaFormat mediaFormat2 = mediaFormat.getFrameworkMediaFormatV16();
        if (this.deviceNeedsAutoFrcWorkaround) {
            mediaFormat2.setInteger("auto-frc", 0);
        }
        return mediaFormat2;
    }

    private boolean shouldWaitForKeys(boolean bl) throws ExoPlaybackException {
        if (!this.openedDrmSession) {
            return false;
        }
        int n = this.drmSessionManager.getState();
        if (n == 0) {
            throw new ExoPlaybackException(this.drmSessionManager.getError());
        }
        return n != 4 && (bl || !this.playClearSamplesWithoutKeys);
    }

    protected void onInputFormatChanged(MediaFormatHolder mediaFormatHolder) throws ExoPlaybackException {
        MediaFormat mediaFormat = this.format;
        this.format = mediaFormatHolder.format;
        this.drmInitData = mediaFormatHolder.drmInitData;
        if (this.codec != null && this.canReconfigureCodec(this.codec, this.codecIsAdaptive, mediaFormat, this.format)) {
            this.codecReconfigured = true;
            this.codecReconfigurationState = 1;
        } else if (this.codecReceivedBuffers) {
            this.codecReinitializationState = 1;
        } else {
            this.releaseCodec();
            this.maybeInitCodec();
        }
    }

    protected void onOutputFormatChanged(android.media.MediaFormat mediaFormat) throws ExoPlaybackException {
    }

    protected void onOutputStreamEnded() {
    }

    protected void onQueuedInputBuffer(long l, ByteBuffer byteBuffer, int n, boolean bl) {
    }

    protected void onProcessedOutputBuffer(long l) {
    }

    protected boolean canReconfigureCodec(MediaCodec mediaCodec, boolean bl, MediaFormat mediaFormat, MediaFormat mediaFormat2) {
        return false;
    }

    @Override
    protected boolean isEnded() {
        return this.outputStreamEnded;
    }

    @Override
    protected boolean isReady() {
        return this.format != null && !this.waitingForKeys && (this.sourceState != 0 || this.outputIndex >= 0 || this.isWithinHotswapPeriod());
    }

    protected final int getSourceState() {
        return this.sourceState;
    }

    private boolean isWithinHotswapPeriod() {
        return SystemClock.elapsedRealtime() < this.codecHotswapTimeMs + 1000L;
    }

    protected long getDequeueOutputBufferTimeoutUs() {
        return 0L;
    }

    private boolean drainOutputBuffer(long l, long l2) throws ExoPlaybackException {
        if (this.outputStreamEnded) {
            return false;
        }
        if (this.outputIndex < 0) {
            this.outputIndex = this.codec.dequeueOutputBuffer(this.outputBufferInfo, this.getDequeueOutputBufferTimeoutUs());
        }
        if (this.outputIndex == -2) {
            this.processOutputFormat();
            return true;
        }
        if (this.outputIndex == -3) {
            this.outputBuffers = this.codec.getOutputBuffers();
            ++this.codecCounters.outputBuffersChangedCount;
            return true;
        }
        if (this.outputIndex < 0) {
            if (this.codecNeedsEosPropagationWorkaround && (this.inputStreamEnded || this.codecReinitializationState == 2)) {
                this.processEndOfStream();
                return true;
            }
            return false;
        }
        if ((this.outputBufferInfo.flags & 4) != 0) {
            this.processEndOfStream();
            return false;
        }
        int n = this.getDecodeOnlyIndex(this.outputBufferInfo.presentationTimeUs);
        if (this.processOutputBuffer(l, l2, this.codec, this.outputBuffers[this.outputIndex], this.outputBufferInfo, this.outputIndex, n != -1)) {
            this.onProcessedOutputBuffer(this.outputBufferInfo.presentationTimeUs);
            if (n != -1) {
                this.decodeOnlyPresentationTimestamps.remove(n);
            }
            this.outputIndex = -1;
            return true;
        }
        return false;
    }

    private void processOutputFormat() throws ExoPlaybackException {
        android.media.MediaFormat mediaFormat = this.codec.getOutputFormat();
        if (this.codecNeedsMonoChannelCountWorkaround) {
            mediaFormat.setInteger("channel-count", 1);
        }
        this.onOutputFormatChanged(mediaFormat);
        ++this.codecCounters.outputFormatChangedCount;
    }

    protected abstract boolean processOutputBuffer(long var1, long var3, MediaCodec var5, ByteBuffer var6, MediaCodec.BufferInfo var7, int var8, boolean var9) throws ExoPlaybackException;

    private void processEndOfStream() throws ExoPlaybackException {
        if (this.codecReinitializationState == 2) {
            this.releaseCodec();
            this.maybeInitCodec();
        } else {
            this.outputStreamEnded = true;
            this.onOutputStreamEnded();
        }
    }

    private void notifyDecoderInitializationError(final DecoderInitializationException decoderInitializationException) {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    MediaCodecTrackRenderer.this.eventListener.onDecoderInitializationError(decoderInitializationException);
                }
            });
        }
    }

    private void notifyCryptoError(final MediaCodec.CryptoException cryptoException) {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    MediaCodecTrackRenderer.this.eventListener.onCryptoError(cryptoException);
                }
            });
        }
    }

    private void notifyDecoderInitialized(final String string, final long l, final long l2) {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    MediaCodecTrackRenderer.this.eventListener.onDecoderInitialized(string, l, l2);
                }
            });
        }
    }

    private int getDecodeOnlyIndex(long l) {
        int n = this.decodeOnlyPresentationTimestamps.size();
        for (int i = 0; i < n; ++i) {
            if (this.decodeOnlyPresentationTimestamps.get(i) != l) continue;
            return i;
        }
        return -1;
    }

    private static boolean codecNeedsFlushWorkaround(String string) {
        return Util.SDK_INT < 18 || Util.SDK_INT == 18 && ("OMX.SEC.avc.dec".equals(string) || "OMX.SEC.avc.dec.secure".equals(string)) || Util.SDK_INT == 19 && Util.MODEL.startsWith("SM-G800") && ("OMX.Exynos.avc.dec".equals(string) || "OMX.Exynos.avc.dec.secure".equals(string));
    }

    private static boolean codecNeedsDiscardToSpsWorkaround(String string, MediaFormat mediaFormat) {
        return Util.SDK_INT < 21 && mediaFormat.initializationData.isEmpty() && "OMX.MTK.VIDEO.DECODER.AVC".equals(string);
    }

    private static boolean codecNeedsEosPropagationWorkaround(String string) {
        return Util.SDK_INT <= 17 && "OMX.rk.video_decoder.avc".equals(string);
    }

    private static boolean codecNeedsEosFlushWorkaround(String string) {
        return Util.SDK_INT <= 23 && "OMX.google.vorbis.decoder".equals(string);
    }

    private static boolean codecNeedsMonoChannelCountWorkaround(String string, MediaFormat mediaFormat) {
        return Util.SDK_INT <= 18 && mediaFormat.channelCount == 1 && "OMX.MTK.AUDIO.DECODER.MP3".equals(string);
    }

    private static boolean deviceNeedsAutoFrcWorkaround() {
        return Util.SDK_INT <= 22 && "foster".equals(Util.DEVICE) && "NVIDIA".equals(Util.MANUFACTURER);
    }

    public static class DecoderInitializationException
    extends Exception {
        private static final int CUSTOM_ERROR_CODE_BASE = -50000;
        private static final int NO_SUITABLE_DECODER_ERROR = -49999;
        private static final int DECODER_QUERY_ERROR = -49998;
        public final String mimeType;
        public final boolean secureDecoderRequired;
        public final String decoderName;
        public final String diagnosticInfo;

        public DecoderInitializationException(MediaFormat mediaFormat, Throwable throwable, boolean bl, int n) {
            super("Decoder init failed: [" + n + "], " + mediaFormat, throwable);
            this.mimeType = mediaFormat.mimeType;
            this.secureDecoderRequired = bl;
            this.decoderName = null;
            this.diagnosticInfo = DecoderInitializationException.buildCustomDiagnosticInfo(n);
        }

        public DecoderInitializationException(MediaFormat mediaFormat, Throwable throwable, boolean bl, String string) {
            super("Decoder init failed: " + string + ", " + mediaFormat, throwable);
            this.mimeType = mediaFormat.mimeType;
            this.secureDecoderRequired = bl;
            this.decoderName = string;
            this.diagnosticInfo = Util.SDK_INT >= 21 ? DecoderInitializationException.getDiagnosticInfoV21(throwable) : null;
        }

        @TargetApi(value=21)
        private static String getDiagnosticInfoV21(Throwable throwable) {
            if (throwable instanceof MediaCodec.CodecException) {
                return ((MediaCodec.CodecException)throwable).getDiagnosticInfo();
            }
            return null;
        }

        private static String buildCustomDiagnosticInfo(int n) {
            String string = n < 0 ? "neg_" : "";
            return "com.google.android.exoplayer.MediaCodecTrackRenderer_" + string + Math.abs(n);
        }
    }

    public static interface EventListener {
        public void onDecoderInitializationError(DecoderInitializationException var1);

        public void onCryptoError(MediaCodec.CryptoException var1);

        public void onDecoderInitialized(String var1, long var2, long var4);
    }
}

