package com.vcc.playerwrappersdk.controllers;

/**
 * Created by TAKASHI20 on 9/9/2016.
 */

import com.vcc.playerwrappersdk.entities.CCUData;
import com.vcc.playerwrappersdk.entities.PlayResponse;
import com.vcc.playerwrappersdk.entities.TimeLive;
import com.vcc.playerwrappersdk.entities.VerifyResponse;

import java.security.cert.CertificateException;
import java.util.concurrent.TimeUnit;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

import okhttp3.ConnectionPool;
import okhttp3.OkHttpClient;
import retrofit2.Call;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;
import retrofit2.http.GET;
import retrofit2.http.Query;
import retrofit2.http.Url;

/**
 * Created by Admin on 8/22/2016.
 * Class owned by upstream_android at package ${PACKAGE_NAME}
 */
public class APITransaction {

    //region Builder retrofit
    public static final int TIME_OUT = 10;

    public static IGetTimeLive builderGetTime() {
        Retrofit.Builder builder = new Retrofit.Builder();

        OkHttpClient okHttpClient = new OkHttpClient.Builder()
                .connectTimeout(TIME_OUT, TimeUnit.SECONDS)
                .readTimeout(TIME_OUT, TimeUnit.SECONDS)
                .connectionPool(new ConnectionPool(0, TIME_OUT, TimeUnit.SECONDS))
                .build();

        Retrofit retrofit = builder
                .baseUrl("http://vpapi.sohatv.vn/video/")
                .client(okHttpClient)
                .addConverterFactory(GsonConverterFactory.create())
                .build();

        return retrofit.create(IGetTimeLive.class);
    }

    public  static ILoadOriginURL builderParseLinkJSON(String baseURL) {
        Retrofit.Builder builder = new Retrofit.Builder();

        OkHttpClient okHttpClient = new OkHttpClient.Builder()
                .connectTimeout(TIME_OUT, TimeUnit.SECONDS)
                .readTimeout(TIME_OUT, TimeUnit.SECONDS)
                .connectionPool(new ConnectionPool(0, TIME_OUT, TimeUnit.SECONDS))
                .build();

        Retrofit retrofit = builder
                .baseUrl(baseURL)
                .client(okHttpClient)
                .addConverterFactory(GsonConverterFactory.create())
                .build();

        return retrofit.create(ILoadOriginURL.class);
    }

    public static ILoadOriginURL builderJSONWithCustomUrl() {
        Retrofit.Builder builder = new Retrofit.Builder();
//
//        OkHttpClient okHttpClient = new OkHttpClient.Builder()
//                .connectTimeout(TIME_OUT, TimeUnit.SECONDS)
//                .readTimeout(TIME_OUT, TimeUnit.SECONDS)
//                .connectionPool(new ConnectionPool(0, TIME_OUT, TimeUnit.SECONDS))
//                .build();

        Retrofit retrofit = builder
                .baseUrl("https://mdc.vietid.net/")
                .client(getUnsafeOkHttpClient())
                .addConverterFactory(GsonConverterFactory.create())
                .build();

        return retrofit.create(ILoadOriginURL.class);
    }

    public static OkHttpClient getUnsafeOkHttpClient() {
        try {
            // Create a trust manager that does not validate certificate chains
            final TrustManager[] trustAllCerts = new TrustManager[]{
                    new X509TrustManager() {
                        @Override
                        public void checkClientTrusted(java.security.cert.X509Certificate[] chain, String authType) throws CertificateException {
                        }

                        @Override
                        public void checkServerTrusted(java.security.cert.X509Certificate[] chain, String authType) throws CertificateException {
                        }

                        @Override
                        public java.security.cert.X509Certificate[] getAcceptedIssuers() {
                            return new java.security.cert.X509Certificate[]{};
                        }
                    }
            };

            // Install the all-trusting trust manager
            final SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustAllCerts, new java.security.SecureRandom());

            // Create an ssl socket factory with our all-trusting manager
            final SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();

            OkHttpClient.Builder builder = new OkHttpClient.Builder();
            builder.sslSocketFactory(sslSocketFactory, (X509TrustManager) trustAllCerts[0]);
            builder.hostnameVerifier(new HostnameVerifier() {
                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });

            builder.connectTimeout(TIME_OUT, TimeUnit.SECONDS)
                    .readTimeout(TIME_OUT, TimeUnit.SECONDS)
                    .connectionPool(new ConnectionPool(0, TIME_OUT, TimeUnit.SECONDS));

            return builder.build();
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    //endregion

    public interface ILoadOriginURL {
        @GET
        Call<PlayResponse> getLinkPlayVideo(@Url String url,
                                            @Query("device_id") String deviceId);

        @GET
        Call<VerifyResponse> verifySDK(@Url String url);

        @GET
        Call<CCUData> getCCU(@Url String url);
    }

    interface IGetTimeLive {
        @GET("getLiveTime")
        Call<TimeLive> getTimeLive(@Query("url") String urlVideo);
    }
}