/*
 * Decompiled with CFR 0.152.
 */
package com.vaynberg.wicket.select2;

import com.vaynberg.wicket.select2.AbstractSelect2Choice;
import com.vaynberg.wicket.select2.ChoiceProvider;
import com.vaynberg.wicket.select2.JQuery;
import com.vaynberg.wicket.select2.json.JsonBuilder;
import java.util.Collections;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.string.Strings;
import org.json.JSONException;

public class Select2Choice<T>
extends AbstractSelect2Choice<T, T> {
    public Select2Choice(String id, IModel<T> model, ChoiceProvider<T> provider) {
        super(id, model, provider);
    }

    public Select2Choice(String id, IModel<T> model) {
        super(id, model);
    }

    public Select2Choice(String id) {
        super(id);
    }

    protected void convertInput() {
        String input = this.getWebRequest().getRequestParameters().getParameterValue(this.getInputName()).toString();
        if (Strings.isEmpty((CharSequence)input)) {
            this.setConvertedInput(null);
        } else {
            this.setConvertedInput(this.getProvider().toChoices(Collections.singleton(input)).iterator().next());
        }
    }

    @Override
    protected void renderInitializationScript(IHeaderResponse response) {
        Object value;
        if (this.hasRawInput()) {
            this.convertInput();
            value = this.getConvertedInput();
        } else {
            value = this.getModelObject();
        }
        if (value != null) {
            JsonBuilder selection = new JsonBuilder();
            try {
                selection.object();
                this.getProvider().toJson(value, selection);
                selection.endObject();
            }
            catch (JSONException e) {
                throw new RuntimeException("Error converting model object to Json", e);
            }
            response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)JQuery.execute("$('#%s').select2('data', %s);", this.getMarkupId(), selection.toJson())));
        }
    }
}

