/*
 * Decompiled with CFR 0.152.
 */
package com.mxchip.jmdns;

import android.content.Context;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import com.mxchip.jmdns.JmdnsListener;
import com.mxchip.utils.EasyLinkTXTRecordUtil;
import java.net.InetAddress;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import javax.jmdns.ServiceTypeListener;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JmdnsAPI {
    public static final String TAG = "EasylinkAPI";
    private final Context mContext;
    private boolean isStarted = false;
    private JmDNS jmdns = null;
    public InetAddress intf = null;
    private WifiManager wm = null;
    private WifiManager.MulticastLock lock = null;
    private SampleListener sl = null;
    private ServiceInfo sInfo = null;
    JmdnsListener mdnsListener;
    String mFindDeviceJsonString;
    private JSONArray array;
    private String arraytmp = "";

    public JmdnsAPI(Context context) {
        this.mContext = context;
    }

    public void startMdnsService(final String serviceInfo, final JmdnsListener mJmdnsListener) {
        this.isStarted = true;
        this.array = new JSONArray();
        this.mdnsListener = mJmdnsListener;
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (JmdnsAPI.this.isStarted) {
                        if (JmdnsAPI.this.intf != null && JmdnsAPI.this.jmdns != null) {
                            JmdnsAPI.this.startDeviceSearch(serviceInfo, mJmdnsListener);
                            Thread.sleep(3000L);
                            continue;
                        }
                        if (JmdnsAPI.this.intf == null) {
                            JmdnsAPI.this.intf = JmdnsAPI.this.getLocalIpAddress();
                        }
                        if (JmdnsAPI.this.jmdns != null) continue;
                        JmdnsAPI.this.jmdns = JmDNS.create(JmdnsAPI.this.intf);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        thread.start();
    }

    public InetAddress getLocalIpAddress() throws Exception {
        if (this.wm == null) {
            this.wm = (WifiManager)this.mContext.getSystemService("wifi");
        }
        WifiInfo wifiinfo = this.wm.getConnectionInfo();
        int intaddr = wifiinfo.getIpAddress();
        byte[] byteaddr = new byte[]{(byte)(intaddr & 0xFF), (byte)(intaddr >> 8 & 0xFF), (byte)(intaddr >> 16 & 0xFF), (byte)(intaddr >> 24 & 0xFF)};
        InetAddress addr = InetAddress.getByAddress(byteaddr);
        return addr;
    }

    private void startDeviceSearch(String serviceInfo, JmdnsListener mJmdnsListener) {
        try {
            if (this.wm == null) {
                this.wm = (WifiManager)this.mContext.getSystemService("wifi");
            }
            this.lock = this.wm.createMulticastLock("mylock");
            this.lock.setReferenceCounted(true);
            this.lock.acquire();
            this.sl = new SampleListener(serviceInfo, mJmdnsListener);
            this.jmdns.addServiceListener(serviceInfo, this.sl);
            this.mdnsListener.onJmdnsFind(this.array);
            this.array = new JSONArray();
            this.arraytmp = "";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stopMdnsService() {
        this.isStarted = false;
    }

    class SampleListener
    implements ServiceListener,
    ServiceTypeListener {
        String serviceInfo;

        public SampleListener(String serviceInfo, JmdnsListener mJmdnsListener) {
            this.serviceInfo = serviceInfo;
        }

        @Override
        public void serviceAdded(ServiceEvent event) {
            JmdnsAPI.this.sInfo = JmdnsAPI.this.jmdns.getServiceInfo(this.serviceInfo, event.getName());
            if (JmdnsAPI.this.sInfo != null) {
                String macbind = EasyLinkTXTRecordUtil.setBinding(JmdnsAPI.this.sInfo.getTextString());
                String hardwareID = EasyLinkTXTRecordUtil.sethardwareID(JmdnsAPI.this.sInfo.getTextString());
                String ipString = EasyLinkTXTRecordUtil.setDeviceIP("" + JmdnsAPI.this.sInfo.getAddress());
                String macString = EasyLinkTXTRecordUtil.setDeviceMac(JmdnsAPI.this.sInfo.getTextString());
                String allinfo = EasyLinkTXTRecordUtil.setAllInfo(JmdnsAPI.this.sInfo.getTextString());
                JmdnsAPI.this.mFindDeviceJsonString = "{\"deviceName\":\"" + JmdnsAPI.this.sInfo.getName() + "\",\"deviceMac\":\"" + macString + "\",\"deviceIP\":\"" + ipString + "\",\"deviceMacbind\":\"" + macbind + "\",\"hardwareID\":\"" + hardwareID + "\",\"allInfo\":\"" + allinfo + "\",\"devicePort\":\"" + JmdnsAPI.this.sInfo.getPort() + "\"}";
                try {
                    if (-1 == JmdnsAPI.this.arraytmp.indexOf(macString)) {
                        JSONObject city = new JSONObject(JmdnsAPI.this.mFindDeviceJsonString);
                        JmdnsAPI.this.array.put((Object)city);
                        JmdnsAPI jmdnsAPI = JmdnsAPI.this;
                        jmdnsAPI.arraytmp = String.valueOf(jmdnsAPI.arraytmp) + macString + ",";
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public void serviceRemoved(ServiceEvent event) {
        }

        @Override
        public void serviceResolved(ServiceEvent event) {
        }

        @Override
        public void serviceTypeAdded(ServiceEvent event) {
        }
    }
}

