/*
 * Decompiled with CFR 0.152.
 */
package com.mxchip.easylink;

import android.content.Context;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.util.Log;
import com.mxchip.easylink.EasyServer;
import com.mxchip.easylink.FTCListener;
import com.mxchip.easylink_plus.EasyLink_plus;
import com.mxchip.helper.Helper;
import java.net.NetworkInterface;
import java.net.SocketException;

public class EasyLinkAPI {
    public static final String TAG = "EasylinkAPI";
    public static final int mPort = 8000;
    private static EasyServer mEasyServer;
    private final Context mContext;
    private WifiManager mWifiManager;
    private WifiInfo mWifiInfo;
    private EasyLink_plus mEasylinkPlus;
    private FTCListener mFTCListener;
    private Context ctx;

    public EasyLinkAPI(Context context) {
        this.mContext = context;
    }

    public String getSSID() {
        this.mWifiManager = (WifiManager)this.mContext.getSystemService("wifi");
        this.mWifiInfo = this.mWifiManager.getConnectionInfo();
        return this.mWifiInfo.getSSID().replaceAll("\"", "");
    }

    public void startEasyLink_FTC(Context context, String ssid, String password, FTCListener ftcl) {
        this.mFTCListener = ftcl;
        this.startEasylink(context, ssid, password);
        try {
            mEasyServer = new EasyServer(8000);
            mEasyServer.start(ftcl);
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)e.getMessage());
        }
    }

    public void stopFTC() {
        this.mFTCListener = null;
        if (mEasyServer != null) {
            mEasyServer.stop();
        }
    }

    public void stopEasyLink() {
        if (this.mEasylinkPlus != null) {
            this.mEasylinkPlus = EasyLink_plus.getInstence(this.ctx);
            this.mEasylinkPlus.stopTransmitting();
        }
    }

    protected void startEasylink(Context context, String ssid, String password) {
        int ip;
        if (ssid == "") {
            ip = this.getNormalIP();
            ssid = this.getSSID();
            password = "react&flux";
        } else {
            ip = ssid == "!AP" ? EasyLinkAPI.getAPIP() : this.getNormalIP();
        }
        this.ctx = context;
        this.mEasylinkPlus = EasyLink_plus.getInstence(context);
        try {
            NetworkInterface intf = NetworkInterface.getByName("wlan0");
            if (intf.getMTU() < 1500) {
                this.mEasylinkPlus.setSmallMtu(true);
                this.mFTCListener.isSmallMTU(intf.getMTU());
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        try {
            this.mEasylinkPlus.transmitSettings(ssid, password, ip);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private byte[] getUserInfo(int ip) {
        byte[] userinfo = new byte[5];
        userinfo[0] = 35;
        String s = String.format("%08x", ip);
        System.arraycopy(Helper.hexStringToBytes(s), 0, userinfo, 1, 4);
        return userinfo;
    }

    public int getNormalIP() {
        this.mWifiManager = (WifiManager)this.mContext.getSystemService("wifi");
        this.mWifiInfo = this.mWifiManager.getConnectionInfo();
        return this.mWifiInfo.getIpAddress();
    }

    public static int getAPIP() {
        return EasyLinkAPI.ip2int("192.168.43.1");
    }

    public static int getTestIP() {
        return EasyLinkAPI.ip2int("192.168.199.163");
    }

    private String int2ip(int ipval) {
        return String.format("%d.%d.%d.%d", ipval & 0xFF, ipval >> 8 & 0xFF, ipval >> 16 & 0xFF, ipval >> 24 & 0xFF);
    }

    public static int ip2int(String ipAddress) {
        String[] ipAddressInArray = ipAddress.split("\\.");
        long result = 0L;
        int i = 0;
        while (i < ipAddressInArray.length) {
            int power = i;
            int ip = Integer.parseInt(ipAddressInArray[i]);
            result = (long)((double)result + (double)ip * Math.pow(256.0, power));
            ++i;
        }
        return (int)result;
    }
}

