/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.ui;

import android.content.Context;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.LinearSmoothScroller;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.flexbox.FlexboxLayoutManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0001*\u00020\u0002\u001a\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0002H\u0002\u001a\f\u0010\u0006\u001a\u00020\u0005*\u00020\u0002H\u0002\u001a\n\u0010\u0007\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\b\u001a\u00020\u0001*\u00020\u0002\u001a2\u0010\t\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\n\u001a\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\u00052\u0014\b\u0002\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00010\r\u001a\n\u0010\u000f\u001a\u00020\u0001*\u00020\u0002\u00a8\u0006\u0010"}, d2={"scrollToTop", "", "Landroidx/recyclerview/widget/RecyclerView;", "scrollToBottom", "firstVisibleItemPosition", "", "itemCount", "scrollBefore", "scrollNext", "smoothScrollTo", "position", "scrollDuration", "onTargetFound", "Lkotlin/Function1;", "Landroid/view/View;", "allowNestedVerticalScrolling", "ui_release"})
public final class AndroidRecyclerViewExtensionsKt {
    public static final void scrollToTop(@NotNull RecyclerView $this$scrollToTop) {
        Intrinsics.checkNotNullParameter((Object)$this$scrollToTop, (String)"<this>");
        AndroidRecyclerViewExtensionsKt.smoothScrollTo$default($this$scrollToTop, 0, 0, null, 6, null);
    }

    public static final void scrollToBottom(@NotNull RecyclerView $this$scrollToBottom) {
        Intrinsics.checkNotNullParameter((Object)$this$scrollToBottom, (String)"<this>");
        AndroidRecyclerViewExtensionsKt.smoothScrollTo$default($this$scrollToBottom, Math.max(0, AndroidRecyclerViewExtensionsKt.itemCount($this$scrollToBottom) - 1), 0, null, 6, null);
    }

    private static final int firstVisibleItemPosition(RecyclerView $this$firstVisibleItemPosition) {
        int n;
        RecyclerView.LayoutManager layoutManager = $this$firstVisibleItemPosition.getLayoutManager();
        if (layoutManager instanceof LinearLayoutManager) {
            n = ((LinearLayoutManager)layoutManager).findFirstVisibleItemPosition();
        } else if (layoutManager instanceof FlexboxLayoutManager) {
            n = ((FlexboxLayoutManager)layoutManager).findFirstVisibleItemPosition();
        } else {
            throw new IllegalStateException(("Unsupported Layout Manager " + layoutManager).toString());
        }
        return n;
    }

    private static final int itemCount(RecyclerView $this$itemCount) {
        RecyclerView.Adapter adapter = $this$itemCount.getAdapter();
        return adapter != null ? adapter.getItemCount() : 0;
    }

    public static final void scrollBefore(@NotNull RecyclerView $this$scrollBefore) {
        Intrinsics.checkNotNullParameter((Object)$this$scrollBefore, (String)"<this>");
        AndroidRecyclerViewExtensionsKt.smoothScrollTo$default($this$scrollBefore, Math.max(0, AndroidRecyclerViewExtensionsKt.firstVisibleItemPosition($this$scrollBefore) - 1), 0, null, 6, null);
    }

    public static final void scrollNext(@NotNull RecyclerView $this$scrollNext) {
        Intrinsics.checkNotNullParameter((Object)$this$scrollNext, (String)"<this>");
        AndroidRecyclerViewExtensionsKt.smoothScrollTo$default($this$scrollNext, Math.min(AndroidRecyclerViewExtensionsKt.itemCount($this$scrollNext), AndroidRecyclerViewExtensionsKt.firstVisibleItemPosition($this$scrollNext) + 1), 0, null, 6, null);
    }

    public static final void smoothScrollTo(@NotNull RecyclerView $this$smoothScrollTo, int position, int scrollDuration, @NotNull Function1<? super View, Unit> onTargetFound) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$this$smoothScrollTo, (String)"<this>");
            Intrinsics.checkNotNullParameter(onTargetFound, (String)"onTargetFound");
            Context context = $this$smoothScrollTo.getContext();
            RecyclerView.SmoothScroller smoothScroller2 = (RecyclerView.SmoothScroller)new LinearSmoothScroller(onTargetFound, scrollDuration, $this$smoothScrollTo, context){
                final /* synthetic */ Function1<View, Unit> $onTargetFound;
                final /* synthetic */ int $scrollDuration;
                final /* synthetic */ RecyclerView $this_smoothScrollTo;
                {
                    this.$onTargetFound = $onTargetFound;
                    this.$scrollDuration = $scrollDuration;
                    this.$this_smoothScrollTo = $receiver;
                    super($super_call_param$1);
                }

                protected int getVerticalSnapPreference() {
                    return -1;
                }

                protected void onTargetFound(View targetView, RecyclerView.State state, RecyclerView.SmoothScroller.Action action) {
                    Intrinsics.checkNotNullParameter((Object)targetView, (String)"targetView");
                    Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                    Intrinsics.checkNotNullParameter((Object)action, (String)"action");
                    super.onTargetFound(targetView, state, action);
                    this.$onTargetFound.invoke((Object)targetView);
                }

                protected float calculateSpeedPerPixel(DisplayMetrics displayMetrics) {
                    return (float)this.$scrollDuration / (float)this.$this_smoothScrollTo.computeVerticalScrollRange();
                }
            };
            smoothScroller2.setTargetPosition(position);
            RecyclerView.LayoutManager layoutManager = $this$smoothScrollTo.getLayoutManager();
            if (layoutManager == null) break block0;
            layoutManager.startSmoothScroll(smoothScroller2);
        }
    }

    public static /* synthetic */ void smoothScrollTo$default(RecyclerView recyclerView, int n, int n2, Function1 function1, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 300;
        }
        if ((n3 & 4) != 0) {
            function1 = AndroidRecyclerViewExtensionsKt::smoothScrollTo$lambda$0;
        }
        AndroidRecyclerViewExtensionsKt.smoothScrollTo(recyclerView, n, n2, (Function1<? super View, Unit>)function1);
    }

    public static final void allowNestedVerticalScrolling(@NotNull RecyclerView $this$allowNestedVerticalScrolling) {
        Intrinsics.checkNotNullParameter((Object)$this$allowNestedVerticalScrolling, (String)"<this>");
        $this$allowNestedVerticalScrolling.addOnItemTouchListener(new RecyclerView.OnItemTouchListener(){

            public boolean onInterceptTouchEvent(RecyclerView rv, MotionEvent e) {
                Intrinsics.checkNotNullParameter((Object)rv, (String)"rv");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getAction() == 2) {
                    rv.getParent().requestDisallowInterceptTouchEvent(true);
                }
                return false;
            }

            public void onTouchEvent(RecyclerView rv, MotionEvent e) {
                Intrinsics.checkNotNullParameter((Object)rv, (String)"rv");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }

            public void onRequestDisallowInterceptTouchEvent(boolean disallowIntercept) {
            }
        });
    }

    private static final Unit smoothScrollTo$lambda$0(View it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }
}

