/*
 * Copyright (C) 2016 - Niklas Baudy, Ruben Gees, Mario Đanić and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package com.vanniktech.emoji.emoji;

public final class CacheKey {
  private final int x;
  private final int y;

  public CacheKey(final int x, final int y) {
    this.x = x;
    this.y = y;
  }

  @Override public boolean equals(final Object o) {
    return o instanceof CacheKey
        && x == ((CacheKey) o).x
        && y == ((CacheKey) o).y;
  }

  @Override public int hashCode() {
    return (x << 16) ^ y;
  }
}
