/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji.emoji;

import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class Emoji
implements Serializable {
    private static final long serialVersionUID = 3L;
    @NonNull
    private final String unicode;
    @DrawableRes
    private final int resource;
    @NonNull
    private final List<Emoji> variants;
    @Nullable
    private Emoji base;

    public Emoji(@NonNull int[] codePoints, @DrawableRes int resource) {
        this(codePoints, resource, new Emoji[0]);
    }

    public Emoji(int codePoint, @DrawableRes int resource) {
        this(codePoint, resource, new Emoji[0]);
    }

    public Emoji(int codePoint, @DrawableRes int resource, Emoji ... variants) {
        this(new int[]{codePoint}, resource, variants);
    }

    public Emoji(@NonNull int[] codePoints, @DrawableRes int resource, Emoji ... variants) {
        this.unicode = new String(codePoints, 0, codePoints.length);
        this.resource = resource;
        this.variants = Arrays.asList(variants);
        for (Emoji variant : variants) {
            variant.base = this;
        }
    }

    @NonNull
    public String getUnicode() {
        return this.unicode;
    }

    @DrawableRes
    public int getResource() {
        return this.resource;
    }

    @NonNull
    public List<Emoji> getVariants() {
        return new ArrayList<Emoji>(this.variants);
    }

    @NonNull
    public Emoji getBase() {
        Emoji result = this;
        while (result.base != null) {
            result = result.base;
        }
        return result;
    }

    public int getLength() {
        return this.unicode.length();
    }

    public boolean hasVariants() {
        return !this.variants.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Emoji emoji = (Emoji)o;
        return this.resource == emoji.resource && this.unicode.equals(emoji.unicode) && this.variants.equals(emoji.variants);
    }

    public int hashCode() {
        int result = this.unicode.hashCode();
        result = 31 * result + this.resource;
        result = 31 * result + this.variants.hashCode();
        return result;
    }
}

