/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.PopupWindow;

final class Utils {
    static final int DONT_UPDATE_FLAG = -1;

    @TargetApi(value=16)
    static void removeOnGlobalLayoutListener(View v, ViewTreeObserver.OnGlobalLayoutListener listener) {
        if (Build.VERSION.SDK_INT < 16) {
            v.getViewTreeObserver().removeGlobalOnLayoutListener(listener);
        } else {
            v.getViewTreeObserver().removeOnGlobalLayoutListener(listener);
        }
    }

    @NonNull
    static <T> T checkNotNull(@Nullable T reference, String message) {
        if (reference == null) {
            throw new IllegalArgumentException(message);
        }
        return reference;
    }

    static int dpToPx(@NonNull Context context, float dp) {
        return (int)(dp * context.getResources().getDisplayMetrics().density);
    }

    static int screenHeight(@NonNull Activity context) {
        Point size = new Point();
        context.getWindowManager().getDefaultDisplay().getSize(size);
        return size.y;
    }

    @NonNull
    static Point locationOnScreen(@NonNull View view) {
        int[] location = new int[2];
        view.getLocationOnScreen(location);
        return new Point(location[0], location[1]);
    }

    @NonNull
    static Rect windowVisibleDisplayFrame(@NonNull Activity context) {
        Rect result = new Rect();
        context.getWindow().getDecorView().getWindowVisibleDisplayFrame(result);
        return result;
    }

    static Activity asActivity(@NonNull Context context) {
        Context result = context;
        while (result instanceof ContextWrapper) {
            if (result instanceof Activity) {
                return (Activity)context;
            }
            result = ((ContextWrapper)context).getBaseContext();
        }
        throw new IllegalArgumentException("The passed Context is not an Activity.");
    }

    static void fixPopupLocation(final @NonNull PopupWindow popupWindow, final @NonNull Point desiredLocation) {
        popupWindow.getContentView().post(new Runnable(){

            @Override
            public void run() {
                Point actualLocation = Utils.locationOnScreen(popupWindow.getContentView());
                if (actualLocation.x != desiredLocation.x || actualLocation.y != desiredLocation.y) {
                    int differenceX = actualLocation.x - desiredLocation.x;
                    int differenceY = actualLocation.y - desiredLocation.y;
                    int fixedOffsetX = actualLocation.x > desiredLocation.x ? desiredLocation.x - differenceX : desiredLocation.x + differenceX;
                    int fixedOffsetY = actualLocation.y > desiredLocation.y ? desiredLocation.y - differenceY : desiredLocation.y + differenceY;
                    popupWindow.update(fixedOffsetX, fixedOffsetY, -1, -1);
                }
            }
        });
    }

    private Utils() {
        throw new AssertionError((Object)"No instances.");
    }
}

