/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.text.style.ImageSpan;

final class EmojiSpan
extends ImageSpan {
    private final float size;

    EmojiSpan(Context context, int drawableRes, float size) {
        super(context, drawableRes);
        this.size = size;
    }

    public Drawable getDrawable() {
        Drawable result = super.getDrawable();
        result.setBounds(0, 0, (int)this.size, (int)this.size);
        return result;
    }

    public int getSize(Paint paint, CharSequence text, int start, int end, Paint.FontMetricsInt fontMetrics) {
        if (fontMetrics != null) {
            Paint.FontMetrics paintFontMetrics = paint.getFontMetrics();
            float fontHeight = paintFontMetrics.descent - paintFontMetrics.ascent;
            float centerY = paintFontMetrics.ascent + fontHeight / 2.0f;
            fontMetrics.top = fontMetrics.ascent = (int)(centerY - this.size / 2.0f);
            fontMetrics.descent = fontMetrics.bottom = (int)(centerY + this.size / 2.0f);
        }
        return (int)this.size;
    }

    public void draw(Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, Paint paint) {
        Drawable drawable = this.getDrawable();
        Paint.FontMetrics paintFontMetrics = paint.getFontMetrics();
        float fontHeight = paintFontMetrics.descent - paintFontMetrics.ascent;
        float centerY = (float)y + paintFontMetrics.descent - fontHeight / 2.0f;
        float transitionY = centerY - this.size / 2.0f;
        canvas.save();
        canvas.translate(x, transitionY);
        drawable.draw(canvas);
        canvas.restore();
    }
}

