/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Paint;
import android.support.annotation.CallSuper;
import android.support.annotation.DimenRes;
import android.support.annotation.Px;
import android.support.v7.widget.AppCompatEditText;
import android.text.Spannable;
import android.util.AttributeSet;
import android.view.KeyEvent;
import com.vanniktech.emoji.EmojiManager;
import com.vanniktech.emoji.R;
import com.vanniktech.emoji.emoji.Emoji;

public class EmojiEditText
extends AppCompatEditText {
    private float emojiSize;

    public EmojiEditText(Context context) {
        this(context, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EmojiEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        if (!this.isInEditMode()) {
            EmojiManager.getInstance().verifyInstalled();
        }
        Paint.FontMetrics fontMetrics = this.getPaint().getFontMetrics();
        float defaultEmojiSize = fontMetrics.descent - fontMetrics.ascent;
        if (attrs == null) {
            this.emojiSize = defaultEmojiSize;
        } else {
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.EmojiEditText);
            try {
                this.emojiSize = a.getDimension(R.styleable.EmojiEditText_emojiSize, defaultEmojiSize);
            }
            finally {
                a.recycle();
            }
        }
        this.setText((CharSequence)this.getText());
    }

    @CallSuper
    protected void onTextChanged(CharSequence text, int start, int lengthBefore, int lengthAfter) {
        EmojiManager.replaceWithImages(this.getContext(), (Spannable)this.getText(), this.emojiSize);
    }

    @CallSuper
    public void backspace() {
        KeyEvent event = new KeyEvent(0L, 0L, 0, 67, 0, 0, 0, 0, 6);
        this.dispatchKeyEvent(event);
    }

    @CallSuper
    public void input(Emoji emoji) {
        if (emoji != null) {
            int start = this.getSelectionStart();
            int end = this.getSelectionEnd();
            if (start < 0) {
                this.append(emoji.getUnicode());
            } else {
                this.getText().replace(Math.min(start, end), Math.max(start, end), (CharSequence)emoji.getUnicode(), 0, emoji.getUnicode().length());
            }
        }
    }

    public final void setEmojiSize(@Px int pixels) {
        this.setEmojiSize(pixels, true);
    }

    public final void setEmojiSize(@Px int pixels, boolean shouldInvalidate) {
        this.emojiSize = pixels;
        if (shouldInvalidate) {
            this.setText((CharSequence)this.getText());
        }
    }

    public final void setEmojiSizeRes(@DimenRes int res) {
        this.setEmojiSizeRes(res, true);
    }

    public final void setEmojiSizeRes(@DimenRes int res, boolean shouldInvalidate) {
        this.setEmojiSize(this.getResources().getDimensionPixelSize(res), shouldInvalidate);
    }
}

