/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji.emoji;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.v4.util.SparseArrayCompat;
import com.vanniktech.emoji.emoji.Emoji;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class EmojiTree {
    private EmojiNode root = new EmojiNode(null);

    public void add(@NonNull Emoji emoji) {
        String unicode = emoji.getUnicode();
        EmojiNode current = this.root;
        for (int i = 0; i < unicode.length() - 1; ++i) {
            current = current.appendOrGet(unicode.charAt(i));
        }
        current.appendLast(unicode.charAt(unicode.length() - 1), emoji);
    }

    @Nullable
    public Emoji findEmoji(@NonNull CharSequence candidate) {
        EmojiNode current = this.root;
        Emoji result = null;
        for (int i = 0; i < candidate.length() && (current = current.getChild(candidate.charAt(i))) != null; ++i) {
            if (current.getEmoji() == null) continue;
            result = current.getEmoji();
        }
        return result;
    }

    public boolean isEmpty() {
        return this.root.children.size() <= 0;
    }

    public void clear() {
        this.root = new EmojiNode(null);
    }

    static class EmojiNode {
        final SparseArrayCompat<EmojiNode> children = new SparseArrayCompat();
        private Emoji emoji;

        EmojiNode(@Nullable Emoji emoji) {
            this.emoji = emoji;
        }

        @Nullable
        EmojiNode getChild(char child) {
            return (EmojiNode)this.children.get((int)child);
        }

        @Nullable
        Emoji getEmoji() {
            return this.emoji;
        }

        void setEmoji(@NonNull Emoji emoji) {
            this.emoji = emoji;
        }

        @NonNull
        EmojiNode appendOrGet(char child) {
            EmojiNode existing = (EmojiNode)this.children.get((int)child);
            if (existing == null) {
                existing = new EmojiNode(null);
                this.children.put((int)child, (Object)existing);
            }
            return existing;
        }

        void appendLast(char child, @NonNull Emoji newEmoji) {
            EmojiNode existing = (EmojiNode)this.children.get((int)child);
            if (existing == null) {
                existing = new EmojiNode(newEmoji);
                this.children.put((int)child, (Object)existing);
            } else {
                existing.setEmoji(newEmoji);
            }
        }
    }
}

