/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.vanniktech.emoji.EmojiProvider;
import com.vanniktech.emoji.Utils;
import com.vanniktech.emoji.emoji.Emoji;
import com.vanniktech.emoji.emoji.EmojiCategory;
import com.vanniktech.emoji.emoji.EmojiTree;

public final class EmojiManager {
    private static final EmojiManager INSTANCE = new EmojiManager();
    private EmojiCategory[] categories;
    private final EmojiTree emojiTree = new EmojiTree();

    private EmojiManager() {
    }

    static EmojiManager getInstance() {
        return INSTANCE;
    }

    public static void install(@NonNull EmojiProvider provider) {
        EmojiManager.INSTANCE.categories = Utils.checkNotNull(provider.getCategories(), "categories == null");
        EmojiManager.INSTANCE.emojiTree.clear();
        for (int i = 0; i < EmojiManager.INSTANCE.categories.length; ++i) {
            Emoji[] emojis = Utils.checkNotNull(EmojiManager.INSTANCE.categories[i].getEmojis(), "emojies == null");
            for (int j = 0; j < emojis.length; ++j) {
                EmojiManager.INSTANCE.emojiTree.add(emojis[j]);
            }
        }
    }

    EmojiCategory[] getCategories() {
        this.verifyInstalled();
        return this.categories;
    }

    @Nullable
    Emoji findEmoji(@NonNull CharSequence candiate) {
        this.verifyInstalled();
        return this.emojiTree.findEmoji(candiate);
    }

    void verifyInstalled() {
        if (this.categories == null) {
            throw new IllegalStateException("Please install an EmojiProvider through the EmojiManager.install() method first.");
        }
    }
}

