/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import com.vanniktech.emoji.ImageDownloaderTask;
import com.vanniktech.emoji.R;
import com.vanniktech.emoji.Utils;
import com.vanniktech.emoji.emoji.Emoji;
import com.vanniktech.emoji.listeners.OnEmojiClickedListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

final class EmojiArrayAdapter
extends ArrayAdapter<Emoji> {
    @Nullable
    final OnEmojiClickedListener listener;

    EmojiArrayAdapter(@NonNull Context context, @NonNull Emoji[] emojis, @Nullable OnEmojiClickedListener listener) {
        super(context, 0, EmojiArrayAdapter.filter(emojis));
        this.listener = listener;
    }

    private static List<Emoji> filter(Emoji[] emojis) {
        ArrayList<Emoji> result = new ArrayList<Emoji>(emojis.length);
        for (Emoji emoji : emojis) {
            if (emoji.isSkinToned()) continue;
            result.add(emoji);
        }
        return result;
    }

    @NonNull
    public View getView(final int position, View convertView, @NonNull ViewGroup parent) {
        ImageView image = (ImageView)convertView;
        if (image == null) {
            image = (ImageView)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.emoji_item, parent, false);
        }
        image.setImageDrawable(null);
        image.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (EmojiArrayAdapter.this.listener != null) {
                    EmojiArrayAdapter.this.listener.onEmojiClicked((Emoji)EmojiArrayAdapter.this.getItem(position));
                }
            }
        });
        ImageDownloaderTask task = (ImageDownloaderTask)((Object)image.getTag());
        if (task != null) {
            task.cancel(true);
        }
        task = new ImageDownloaderTask(image);
        image.setTag((Object)task);
        Emoji emoji = (Emoji)Utils.checkNotNull(this.getItem(position), "emoji == null");
        task.execute(new Integer[]{emoji.getResource()});
        return image;
    }

    void updateEmojis(Collection<Emoji> emojis) {
        this.clear();
        this.addAll(emojis);
        this.notifyDataSetChanged();
    }
}

