/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji.internal;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.Point;
import android.graphics.Rect;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.widget.EditText;
import android.widget.PopupWindow;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.core.content.ContextCompat;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\nJ\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0015\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ\u001d\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u0014J\u0015\u0010\u0015\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u0016J\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000eH\u0002J\u0015\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b\u001cJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0006\u001a\u00020\u000eH\u0002J\u0015\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b J\u001d\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b&J)\u0010'\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010(\u001a\u00020\u00052\b\b\u0001\u0010)\u001a\u00020\u0005H\u0001\u00a2\u0006\u0002\b*\u00a8\u0006+"}, d2={"Lcom/vanniktech/emoji/internal/Utils;", "", "<init>", "()V", "dpToPx", "", "context", "Landroid/content/Context;", "dp", "", "dpToPx$emoji_release", "getOrientation", "getProperWidth", "activity", "Landroid/app/Activity;", "getProperWidth$emoji_release", "shouldOverrideRegularCondition", "", "editText", "Landroid/widget/EditText;", "shouldOverrideRegularCondition$emoji_release", "getProperHeight", "getProperHeight$emoji_release", "getScreenWidth", "locationOnScreen", "Landroid/graphics/Point;", "view", "Landroid/view/View;", "locationOnScreen$emoji_release", "windowVisibleDisplayFrame", "Landroid/graphics/Rect;", "asActivity", "asActivity$emoji_release", "fixPopupLocation", "", "popupWindow", "Landroid/widget/PopupWindow;", "desiredLocation", "fixPopupLocation$emoji_release", "resolveColor", "resource", "fallback", "resolveColor$emoji_release", "emoji_release"})
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();

    private Utils() {
    }

    public final int dpToPx$emoji_release(@NotNull Context context, float dp) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return MathKt.roundToInt((float)(TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)context.getResources().getDisplayMetrics()) + 0.5f));
    }

    private final int getOrientation(Context context) {
        return context.getResources().getConfiguration().orientation;
    }

    public final int getProperWidth$emoji_release(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Rect rect = this.windowVisibleDisplayFrame(activity);
        return this.getOrientation((Context)activity) == 1 ? rect.right : this.getScreenWidth(activity);
    }

    public final boolean shouldOverrideRegularCondition$emoji_release(@NotNull Context context, @NotNull EditText editText) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)editText, (String)"editText");
        return (editText.getImeOptions() & 0x10000000) == 0 ? this.getOrientation(context) == 2 : false;
    }

    public final int getProperHeight$emoji_release(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        return this.windowVisibleDisplayFrame((Activity)activity).bottom;
    }

    private final int getScreenWidth(Activity context) {
        return this.dpToPx$emoji_release((Context)context, context.getResources().getConfiguration().screenWidthDp);
    }

    @NotNull
    public final Point locationOnScreen$emoji_release(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        int[] location = new int[2];
        view.getLocationOnScreen(location);
        return new Point(location[0], location[1]);
    }

    private final Rect windowVisibleDisplayFrame(Activity context) {
        Rect result = new Rect();
        context.getWindow().getDecorView().getWindowVisibleDisplayFrame(result);
        return result;
    }

    @NotNull
    public final Activity asActivity$emoji_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Context result = context;
        while (result instanceof ContextWrapper) {
            if (result instanceof Activity) {
                return (Activity)result;
            }
            result = ((ContextWrapper)result).getBaseContext();
        }
        throw new IllegalStateException("The passed Context is not an Activity.".toString());
    }

    public final void fixPopupLocation$emoji_release(@NotNull PopupWindow popupWindow, @NotNull Point desiredLocation) {
        Intrinsics.checkNotNullParameter((Object)popupWindow, (String)"popupWindow");
        Intrinsics.checkNotNullParameter((Object)desiredLocation, (String)"desiredLocation");
        popupWindow.getContentView().post(() -> Utils.fixPopupLocation$lambda$0(popupWindow, desiredLocation));
    }

    @ColorInt
    public final int resolveColor$emoji_release(@NotNull Context context, @AttrRes int resource, @ColorRes int fallback) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        TypedValue value = new TypedValue();
        context.getTheme().resolveAttribute(resource, value, true);
        int resolvedColor = value.resourceId != 0 ? ContextCompat.getColor((Context)context, (int)value.resourceId) : value.data;
        return resolvedColor != 0 ? resolvedColor : ContextCompat.getColor((Context)context, (int)fallback);
    }

    private static final void fixPopupLocation$lambda$0(PopupWindow $popupWindow, Point $desiredLocation) {
        Intrinsics.checkNotNullParameter((Object)$popupWindow, (String)"$popupWindow");
        Intrinsics.checkNotNullParameter((Object)$desiredLocation, (String)"$desiredLocation");
        View view = $popupWindow.getContentView();
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"getContentView(...)");
        Point actualLocation = INSTANCE.locationOnScreen$emoji_release(view);
        if (actualLocation.x != $desiredLocation.x || actualLocation.y != $desiredLocation.y) {
            int differenceX = actualLocation.x - $desiredLocation.x;
            int differenceY = actualLocation.y - $desiredLocation.y;
            int fixedOffsetX = actualLocation.x > $desiredLocation.x ? $desiredLocation.x - differenceX : $desiredLocation.x + differenceX;
            int fixedOffsetY = actualLocation.y > $desiredLocation.y ? $desiredLocation.y - differenceY : $desiredLocation.y + differenceY;
            $popupWindow.update(fixedOffsetX, fixedOffsetY, -1, -1);
        }
    }
}

