/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji.internal;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import androidx.viewpager.widget.PagerAdapter;
import com.vanniktech.emoji.EmojiCategory;
import com.vanniktech.emoji.EmojiManager;
import com.vanniktech.emoji.EmojiTheming;
import com.vanniktech.emoji.internal.CategoryGridView;
import com.vanniktech.emoji.internal.EmojiGridView;
import com.vanniktech.emoji.internal.EmojiPagerDelegate;
import com.vanniktech.emoji.internal.RecentEmojiGridView;
import com.vanniktech.emoji.recent.NoRecentEmoji;
import com.vanniktech.emoji.recent.RecentEmoji;
import com.vanniktech.emoji.variant.VariantEmoji;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000  2\u00020\u0001:\u0001 B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0011H\u0016J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u0014H\u0016J\u0018\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0014H\u0016J\u0006\u0010\u001e\u001a\u00020\u0011J\u0006\u0010\u001f\u001a\u00020\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/vanniktech/emoji/internal/EmojiPagerAdapter;", "Landroidx/viewpager/widget/PagerAdapter;", "delegate", "Lcom/vanniktech/emoji/internal/EmojiPagerDelegate;", "recentEmoji", "Lcom/vanniktech/emoji/recent/RecentEmoji;", "variantManager", "Lcom/vanniktech/emoji/variant/VariantEmoji;", "theming", "Lcom/vanniktech/emoji/EmojiTheming;", "<init>", "(Lcom/vanniktech/emoji/internal/EmojiPagerDelegate;Lcom/vanniktech/emoji/recent/RecentEmoji;Lcom/vanniktech/emoji/variant/VariantEmoji;Lcom/vanniktech/emoji/EmojiTheming;)V", "recentEmojiGridView", "Lcom/vanniktech/emoji/internal/RecentEmojiGridView;", "hasRecentEmoji", "", "recentAdapterItemCount", "", "getCount", "instantiateItem", "", "pager", "Landroid/view/ViewGroup;", "position", "destroyItem", "", "view", "isViewFromObject", "Landroid/view/View;", "object", "numberOfRecentEmojis", "invalidateRecentEmojis", "Companion", "emoji_release"})
public final class EmojiPagerAdapter
extends PagerAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EmojiPagerDelegate delegate;
    @NotNull
    private final RecentEmoji recentEmoji;
    @NotNull
    private final VariantEmoji variantManager;
    @NotNull
    private final EmojiTheming theming;
    @Nullable
    private RecentEmojiGridView recentEmojiGridView;
    private static final int RECENT_POSITION = 0;

    public EmojiPagerAdapter(@NotNull EmojiPagerDelegate delegate, @NotNull RecentEmoji recentEmoji, @NotNull VariantEmoji variantManager, @NotNull EmojiTheming theming) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)recentEmoji, (String)"recentEmoji");
        Intrinsics.checkNotNullParameter((Object)variantManager, (String)"variantManager");
        Intrinsics.checkNotNullParameter((Object)theming, (String)"theming");
        this.delegate = delegate;
        this.recentEmoji = recentEmoji;
        this.variantManager = variantManager;
        this.theming = theming;
    }

    public final boolean hasRecentEmoji() {
        return !(this.recentEmoji instanceof NoRecentEmoji);
    }

    public final int recentAdapterItemCount() {
        return this.hasRecentEmoji() ? 1 : 0;
    }

    public int getCount() {
        return EmojiManager.INSTANCE.categories$emoji_release().length + this.recentAdapterItemCount();
    }

    @NotNull
    public Object instantiateItem(@NotNull ViewGroup pager, int position) {
        EmojiGridView emojiGridView;
        Intrinsics.checkNotNullParameter((Object)pager, (String)"pager");
        if (this.hasRecentEmoji() && position == 0) {
            RecentEmojiGridView view;
            Context context = pager.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            this.recentEmojiGridView = view = new RecentEmojiGridView(context, null, 2, null).init(this.delegate, this.delegate, this.theming, this.recentEmoji);
            emojiGridView = view;
        } else {
            EmojiCategory category = EmojiManager.INSTANCE.categories$emoji_release()[position - this.recentAdapterItemCount()];
            Context context = pager.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            emojiGridView = new CategoryGridView(context, null, 2, null).init(this.delegate, this.delegate, this.theming, category, this.variantManager);
        }
        EmojiGridView newView = emojiGridView;
        pager.addView((View)newView);
        return newView;
    }

    public void destroyItem(@NotNull ViewGroup pager, int position, @NotNull Object view) {
        Intrinsics.checkNotNullParameter((Object)pager, (String)"pager");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        pager.removeView((View)view);
        if (this.hasRecentEmoji() && position == 0) {
            this.recentEmojiGridView = null;
        }
    }

    public boolean isViewFromObject(@NotNull View view, @NotNull Object object) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)object, (String)"object");
        return view == object;
    }

    public final int numberOfRecentEmojis() {
        return this.recentEmoji.getRecentEmojis().size();
    }

    public final void invalidateRecentEmojis() {
        block0: {
            RecentEmojiGridView recentEmojiGridView = this.recentEmojiGridView;
            if (recentEmojiGridView == null) break block0;
            recentEmojiGridView.invalidateEmojis();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/vanniktech/emoji/internal/EmojiPagerAdapter$Companion;", "", "<init>", "()V", "RECENT_POSITION", "", "emoji_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

