/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji.internal;

import android.content.Context;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.Px;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import com.vanniktech.emoji.EmojiTheming;
import com.vanniktech.emoji.R;
import com.vanniktech.emoji.internal.DiffUtilHelper;
import com.vanniktech.emoji.internal.EmojiSearchDialogDelegate;
import com.vanniktech.emoji.internal.EmojiViewHolder;
import com.vanniktech.emoji.search.SearchEmojiResult;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nH\u0016J\u0018\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\nH\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\nH\u0016J\b\u0010\u0019\u001a\u00020\nH\u0016J%\u0010\u001a\u001a\u00020\u00172\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\n\b\u0001\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u001cR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\u0004\u0018\u00010\n8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/vanniktech/emoji/internal/EmojiAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lcom/vanniktech/emoji/internal/EmojiViewHolder;", "theming", "Lcom/vanniktech/emoji/EmojiTheming;", "emojiSearchDialogDelegate", "Lcom/vanniktech/emoji/internal/EmojiSearchDialogDelegate;", "<init>", "(Lcom/vanniktech/emoji/EmojiTheming;Lcom/vanniktech/emoji/internal/EmojiSearchDialogDelegate;)V", "marginStart", "", "Ljava/lang/Integer;", "items", "", "Lcom/vanniktech/emoji/search/SearchEmojiResult;", "getItemId", "", "position", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "onBindViewHolder", "", "holder", "getItemCount", "update", "new", "(Ljava/util/List;Ljava/lang/Integer;)V", "emoji_release"})
public final class EmojiAdapter
extends RecyclerView.Adapter<EmojiViewHolder> {
    @NotNull
    private final EmojiTheming theming;
    @Nullable
    private final EmojiSearchDialogDelegate emojiSearchDialogDelegate;
    @Px
    @Nullable
    private Integer marginStart;
    @NotNull
    private List<SearchEmojiResult> items;

    public EmojiAdapter(@NotNull EmojiTheming theming, @Nullable EmojiSearchDialogDelegate emojiSearchDialogDelegate) {
        Intrinsics.checkNotNullParameter((Object)theming, (String)"theming");
        this.theming = theming;
        this.emojiSearchDialogDelegate = emojiSearchDialogDelegate;
        this.items = CollectionsKt.emptyList();
        this.setHasStableIds(true);
    }

    public long getItemId(int position) {
        return this.items.get((int)position).emoji.hashCode();
    }

    @NotNull
    public EmojiViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return new EmojiViewHolder(parent);
    }

    /*
     * WARNING - void declaration
     */
    public void onBindViewHolder(@NotNull EmojiViewHolder holder, int position) {
        void $this$onBindViewHolder_u24lambda_u240;
        SpannableString spannableString;
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        Context context = holder.getTextView().getContext();
        SearchEmojiResult item = this.items.get(position);
        holder.getTextView().setTextColor(this.theming.textColor);
        holder.getTextView().setText(item.emoji.getUnicode());
        ViewGroup.LayoutParams layoutParams = holder.getTextView().getLayoutParams();
        Intrinsics.checkNotNull((Object)layoutParams, (String)"null cannot be cast to non-null type android.widget.LinearLayout.LayoutParams");
        Integer n = this.marginStart;
        ((LinearLayout.LayoutParams)layoutParams).setMarginStart(n != null ? n.intValue() : context.getResources().getDimensionPixelSize(R.dimen.emoji_search_spacing));
        String shortCode = item.shortcode;
        SpannableString spannableString2 = spannableString = new SpannableString((CharSequence)shortCode);
        TextView textView = holder.getShortCodes();
        boolean bl = false;
        $this$onBindViewHolder_u24lambda_u240.setSpan((Object)new ForegroundColorSpan(this.theming.textSecondaryColor), 0, shortCode.length(), 0);
        $this$onBindViewHolder_u24lambda_u240.setSpan((Object)new ForegroundColorSpan(this.theming.secondaryColor), item.range.getFirst(), item.range.getLast() + 1, 0);
        textView.setText((CharSequence)spannableString);
        holder.itemView.setOnClickListener(arg_0 -> EmojiAdapter.onBindViewHolder$lambda$1(this, item, arg_0));
    }

    public int getItemCount() {
        return this.items.size();
    }

    public final void update(@NotNull List<SearchEmojiResult> list, @Px @Nullable Integer marginStart) {
        Intrinsics.checkNotNullParameter(list, (String)"new");
        ArrayList old = new ArrayList(this.items);
        this.items = list;
        this.marginStart = marginStart;
        DiffUtil.calculateDiff((DiffUtil.Callback)new DiffUtilHelper<SearchEmojiResult>(old, this.items, EmojiAdapter::update$lambda$2)).dispatchUpdatesTo((RecyclerView.Adapter)this);
    }

    private static final void onBindViewHolder$lambda$1(EmojiAdapter this$0, SearchEmojiResult $item, View it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$item, (String)"$item");
            EmojiSearchDialogDelegate emojiSearchDialogDelegate = this$0.emojiSearchDialogDelegate;
            if (emojiSearchDialogDelegate == null) break block0;
            emojiSearchDialogDelegate.onSearchEmojiClick($item.emoji);
        }
    }

    private static final int update$lambda$2(SearchEmojiResult it) {
        return it.hashCode();
    }
}

