/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.wscdn.client;

import javax.xml.bind.annotation.XmlTransient;

public class AddonInfo {
    private String groupId;
    private String artifactId;
    private String version;

    public AddonInfo() {
    }

    public AddonInfo(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @XmlTransient
    public String toFullMavenId() {
        return this.groupId + "." + this.artifactId + "-" + this.version;
    }

    public String toMavenPomSnippet() {
        StringBuilder b = new StringBuilder();
        b.append("<dependency><groupId>");
        b.append(this.getGroupId());
        b.append("</groupId><artifactId>");
        b.append(this.getArtifactId());
        b.append("</artifactId><version>");
        b.append(this.getVersion());
        b.append("</version></dependency>");
        return b.toString();
    }

    public String toString() {
        return "{groupId=" + this.groupId + ", artifactId=" + this.artifactId + ", version=" + this.version + '}';
    }

    public int hashCode() {
        int hash = 5;
        hash = 41 * hash + AddonInfo.hashCode(this.groupId);
        hash = 41 * hash + AddonInfo.hashCode(this.artifactId);
        hash = 41 * hash + AddonInfo.hashCode(this.version);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AddonInfo other = (AddonInfo)obj;
        if (!AddonInfo.equals(this.groupId, other.groupId)) {
            return false;
        }
        if (!AddonInfo.equals(this.artifactId, other.artifactId)) {
            return false;
        }
        return AddonInfo.equals(this.version, other.version);
    }

    private static int hashCode(Object o) {
        return o != null ? o.hashCode() : 0;
    }

    private static boolean equals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }
}

