/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.upload;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasEnabled;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.shared.HasThemeVariant;
import com.vaadin.flow.component.shared.SlotUtils;
import com.vaadin.flow.component.upload.AllFinishedEvent;
import com.vaadin.flow.component.upload.FailedEvent;
import com.vaadin.flow.component.upload.FileRejectedEvent;
import com.vaadin.flow.component.upload.FileRemovedEvent;
import com.vaadin.flow.component.upload.FinishedEvent;
import com.vaadin.flow.component.upload.MultiFileReceiver;
import com.vaadin.flow.component.upload.NoInputStreamEvent;
import com.vaadin.flow.component.upload.NoOutputStreamEvent;
import com.vaadin.flow.component.upload.ProgressUpdateEvent;
import com.vaadin.flow.component.upload.Receiver;
import com.vaadin.flow.component.upload.StartedEvent;
import com.vaadin.flow.component.upload.SucceededEvent;
import com.vaadin.flow.component.upload.UploadI18N;
import com.vaadin.flow.component.upload.UploadVariant;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.streams.UploadCompleteEvent;
import com.vaadin.flow.internal.streams.UploadStartEvent;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.NoInputStreamException;
import com.vaadin.flow.server.NoOutputStreamException;
import com.vaadin.flow.server.StreamReceiver;
import com.vaadin.flow.server.StreamResourceRegistry;
import com.vaadin.flow.server.StreamVariable;
import com.vaadin.flow.server.streams.ElementRequestHandler;
import com.vaadin.flow.server.streams.UploadEvent;
import com.vaadin.flow.server.streams.UploadHandler;
import com.vaadin.flow.shared.Registration;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.BaseJsonNode;
import tools.jackson.databind.node.ObjectNode;

@Tag(value="vaadin-upload")
@NpmPackage(value="@vaadin/upload", version="25.0.0-beta5")
@JsModule(value="@vaadin/upload/src/vaadin-upload.js")
public class Upload
extends Component
implements HasEnabled,
HasSize,
HasStyle,
HasThemeVariant<UploadVariant> {
    private StreamVariable streamVariable;
    private volatile boolean interrupted = false;
    private int activeUploads = 0;
    private boolean uploading;
    private UploadI18N i18n;
    private Component uploadButton;
    private Component defaultUploadButton;
    private Component dropLabel;
    private Component defaultDropLabel;
    private Component dropLabelIcon;
    private Component defaultDropLabelIcon;
    private Receiver receiver;

    public Upload() {
        String eventDetailError = "event.detail.error";
        String eventDetailFileName = "event.detail.file.name";
        this.getElement().addEventListener("file-reject", (DomEventListener & Serializable)event -> {
            String detailError = event.getEventData().get("event.detail.error").asString();
            String detailFileName = event.getEventData().get("event.detail.file.name").asString();
            this.fireEvent(new FileRejectedEvent(this, detailError, detailFileName));
        }).addEventData("event.detail.error").addEventData("event.detail.file.name");
        this.getElement().addEventListener("file-remove", (DomEventListener & Serializable)event -> {
            String detailFileName = event.getEventData().get("event.detail.file.name").asString();
            this.fireEvent(new FileRemovedEvent(this, detailFileName));
        }).addEventData("event.detail.file.name");
        this.getElement().addEventListener("upload-abort", (DomEventListener & Serializable)event -> this.interruptUpload());
        this.setUploadHandler(new FailFastUploadHandler());
        String elementFiles = "element.files";
        DomEventListener & Serializable allFinishedListener = (DomEventListener & Serializable)e -> {
            ArrayNode files = (ArrayNode)e.getEventData().get("element.files");
            boolean isUploading = IntStream.range(0, files.size()).anyMatch(index -> {
                String KEY = "uploading";
                JsonNode object = files.get(index);
                return object.has("uploading") && object.get("uploading").booleanValue();
            });
            if (this.uploading && !isUploading) {
                this.fireAllFinish();
            }
            this.uploading = isUploading;
        };
        this.getElement().addEventListener("upload-start", (DomEventListener & Serializable)e -> {
            this.uploading = true;
        });
        this.getElement().addEventListener("upload-success", (DomEventListener)allFinishedListener).addEventData("element.files");
        this.getElement().addEventListener("upload-error", (DomEventListener)allFinishedListener).addEventData("element.files");
        this.getElement().addEventListener("upload-abort", (DomEventListener)allFinishedListener).addEventData("element.files");
        this.defaultUploadButton = new Button();
        this.defaultUploadButton.getElement().setProperty("_isDefault", true);
        this.setUploadButton(this.defaultUploadButton);
        this.defaultDropLabel = new Span();
        this.defaultDropLabel.getElement().setProperty("_isDefault", true);
        this.setDropLabel(this.defaultDropLabel);
        this.defaultDropLabelIcon = new UploadIcon();
        this.setDropLabelIcon(this.defaultDropLabelIcon);
    }

    @Deprecated(since="24.8", forRemoval=true)
    public Upload(Receiver receiver) {
        this();
        this.setReceiver(receiver);
    }

    public Upload(UploadHandler handler) {
        this();
        this.setUploadHandler(handler);
    }

    public Upload(UploadHandler handler, String targetName) {
        this();
        this.setUploadHandler(handler, targetName);
    }

    public Registration addAllFinishedListener(ComponentEventListener<AllFinishedEvent> listener) {
        return this.addListener(AllFinishedEvent.class, listener);
    }

    StreamVariable getStreamVariable() {
        if (this.streamVariable == null) {
            this.streamVariable = new DefaultStreamVariable(this);
        }
        return this.streamVariable;
    }

    public void setMaxFiles(int maxFiles) {
        this.getElement().setProperty("maxFiles", (double)maxFiles);
        this.getElement().executeJs("this.maxFiles = $0", new Object[]{maxFiles});
    }

    public int getMaxFiles() {
        return (int)this.getElement().getProperty("maxFiles", 0.0);
    }

    private void removeMaxFiles() {
        this.getElement().removeProperty("maxFiles");
        this.getElement().executeJs("this.maxFiles = Infinity", new Object[0]);
    }

    public void setMaxFileSize(int maxFileSize) {
        this.getElement().setProperty("maxFileSize", (double)maxFileSize);
    }

    public int getMaxFileSize() {
        return (int)this.getElement().getProperty("maxFileSize", 0.0);
    }

    public void setAutoUpload(boolean autoUpload) {
        this.getElement().setProperty("noAuto", !autoUpload);
    }

    public boolean isAutoUpload() {
        return !this.getElement().getProperty("noAuto", false);
    }

    public void setDropAllowed(boolean dropAllowed) {
        this.getElement().setProperty("nodrop", !dropAllowed);
    }

    public boolean isDropAllowed() {
        return !this.getElement().getProperty("nodrop", false);
    }

    public void setAcceptedFileTypes(String ... acceptedFileTypes) {
        String accepted = "";
        if (acceptedFileTypes != null) {
            accepted = String.join((CharSequence)",", acceptedFileTypes);
        }
        this.getElement().setProperty("accept", accepted);
    }

    public List<String> getAcceptedFileTypes() {
        String accepted = this.getElement().getProperty("accept");
        if (accepted == null) {
            return Collections.emptyList();
        }
        return List.of(accepted.split(","));
    }

    public void setUploadButton(Component button) {
        this.uploadButton = button != null ? button : this.defaultUploadButton;
        SlotUtils.setSlot((HasElement)this, (String)"add-button", (Component[])new Component[]{this.uploadButton});
    }

    public Component getUploadButton() {
        return this.uploadButton;
    }

    public void setDropLabel(Component label) {
        this.dropLabel = label != null ? label : this.defaultDropLabel;
        SlotUtils.setSlot((HasElement)this, (String)"drop-label", (Component[])new Component[]{this.dropLabel});
    }

    public Component getDropLabel() {
        return this.dropLabel;
    }

    public void setDropLabelIcon(Component icon) {
        this.dropLabelIcon = icon != null ? icon : this.defaultDropLabelIcon;
        SlotUtils.setSlot((HasElement)this, (String)"drop-label-icon", (Component[])new Component[]{this.dropLabelIcon});
    }

    public Component getDropLabelIcon() {
        return this.dropLabelIcon;
    }

    private void startUpload() {
        if (!this.isEnabled()) {
            throw new IllegalStateException("Cannot start upload because the Upload component is disabled");
        }
        if (this.getMaxFiles() != 0 && this.getMaxFiles() <= this.activeUploads) {
            throw new IllegalStateException("Maximum supported amount of uploads already started");
        }
        ++this.activeUploads;
    }

    public void interruptUpload() {
        if (this.isUploading()) {
            this.interrupted = true;
        }
    }

    private void endUpload() {
        --this.activeUploads;
        if (this.activeUploads == 0) {
            this.interrupted = false;
        }
    }

    public boolean isUploading() {
        return this.activeUploads > 0;
    }

    private void fireStarted(String filename, String mimeType, long contentLength) {
        this.fireEvent(new StartedEvent(this, filename, mimeType, contentLength));
    }

    private void fireUploadInterrupted(String filename, String mimeType, long length) {
        this.fireEvent(new FailedEvent(this, filename, mimeType, length));
    }

    private void fireNoInputStream(String filename, String mimeType, long length) {
        this.fireEvent(new NoInputStreamEvent(this, filename, mimeType, length));
    }

    private void fireNoOutputStream(String filename, String mimeType, long length) {
        this.fireEvent(new NoOutputStreamEvent(this, filename, mimeType, length));
    }

    private void fireUploadInterrupted(String filename, String mimeType, long length, Exception e) {
        this.fireEvent(new FailedEvent(this, filename, mimeType, length, e));
    }

    private void fireUploadSuccess(String filename, String mimeType, long length) {
        this.fireEvent(new SucceededEvent(this, filename, mimeType, length));
    }

    private void fireUploadFinish(String filename, String mimeType, long length) {
        this.fireEvent(new FinishedEvent(this, filename, mimeType, length));
    }

    private void fireAllFinish() {
        this.fireEvent(new AllFinishedEvent(this));
    }

    @Deprecated(since="24.4")
    protected void fireUpdateProgress(long totalBytes, long contentLength) {
        this.fireEvent(new ProgressUpdateEvent(this, totalBytes, contentLength, null));
    }

    protected void fireUpdateProgress(long totalBytes, long contentLength, String fileName) {
        this.fireEvent(new ProgressUpdateEvent(this, totalBytes, contentLength, fileName));
    }

    @Deprecated(since="24.8", forRemoval=true)
    public Registration addProgressListener(ComponentEventListener<ProgressUpdateEvent> listener) {
        return this.addListener(ProgressUpdateEvent.class, listener);
    }

    @Deprecated(since="24.8", forRemoval=true)
    public Registration addFailedListener(ComponentEventListener<FailedEvent> listener) {
        return this.addListener(FailedEvent.class, listener);
    }

    @Deprecated(since="24.8", forRemoval=true)
    public Registration addFinishedListener(ComponentEventListener<FinishedEvent> listener) {
        return this.addListener(FinishedEvent.class, listener);
    }

    @Deprecated(since="24.8", forRemoval=true)
    public Registration addStartedListener(ComponentEventListener<StartedEvent> listener) {
        return this.addListener(StartedEvent.class, listener);
    }

    @Deprecated(since="24.8", forRemoval=true)
    public Registration addSucceededListener(ComponentEventListener<SucceededEvent> listener) {
        return this.addListener(SucceededEvent.class, listener);
    }

    public Registration addFileRejectedListener(ComponentEventListener<FileRejectedEvent> listener) {
        return this.addListener(FileRejectedEvent.class, listener);
    }

    public Registration addFileRemovedListener(ComponentEventListener<FileRemovedEvent> listener) {
        return this.addListener(FileRemovedEvent.class, listener);
    }

    @Deprecated(since="24.8", forRemoval=true)
    public Receiver getReceiver() {
        return this.receiver;
    }

    @Deprecated(since="24.8", forRemoval=true)
    public void setReceiver(Receiver receiver) {
        Receiver oldReceiver = this.receiver;
        this.receiver = receiver;
        if (this.isMultiFileReceiver(receiver)) {
            if (oldReceiver != null && !this.isMultiFileReceiver(oldReceiver)) {
                this.removeMaxFiles();
            }
        } else {
            this.setMaxFiles(1);
        }
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> this.getElement().setAttribute("target", (AbstractStreamResource)new StreamReceiver(this.getElement().getNode(), "upload", this.getStreamVariable())));
    }

    public void setUploadHandler(UploadHandler handler) {
        this.setUploadHandler(handler, "upload");
    }

    public void setUploadHandler(UploadHandler handler, final String targetName) {
        Objects.requireNonNull(handler, "UploadHandler cannot be null");
        Objects.requireNonNull(targetName, "The target name cannot be null");
        if (targetName.isBlank()) {
            throw new IllegalArgumentException("The target name cannot be blank");
        }
        StreamResourceRegistry.ElementStreamResource elementStreamResource = new StreamResourceRegistry.ElementStreamResource((ElementRequestHandler)handler, this.getElement()){

            public String getName() {
                return targetName;
            }
        };
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> this.getElement().setAttribute("target", (AbstractStreamResource)elementStreamResource));
        if (!this.hasListener(UploadStartEvent.class) && !(handler instanceof FailFastUploadHandler)) {
            this.addListener(UploadStartEvent.class, (ComponentEventListener & Serializable)event -> this.startUpload());
            this.addListener(UploadCompleteEvent.class, (ComponentEventListener & Serializable)event -> this.endUpload());
        }
        this.receiver = null;
    }

    private boolean isMultiFileReceiver(Receiver receiver) {
        return receiver instanceof MultiFileReceiver;
    }

    public void setI18n(UploadI18N i18n) {
        this.i18n = Objects.requireNonNull(i18n, "The i18n properties object should not be null");
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> {
            if (i18n == this.i18n) {
                this.setI18nWithJS();
            }
        });
    }

    private void setI18nWithJS() {
        ObjectNode i18nJson = JacksonUtils.beanToJson((Object)this.i18n);
        this.getElement().executeJs("const dropFiles = Object.assign({}, this.i18n.dropFiles, $0.dropFiles);const addFiles = Object.assign({}, this.i18n.addFiles, $0.addFiles);const error = Object.assign({}, this.i18n.error, $0.error);const uploadingStatus = Object.assign({}, this.i18n.uploading.status, $0.uploading && $0.uploading.status);const uploadingRemainingTime = Object.assign({}, this.i18n.uploading.remainingTime, $0.uploading && $0.uploading.remainingTime);const uploadingError = Object.assign({}, this.i18n.uploading.error, $0.uploading && $0.uploading.error);const uploading = {status: uploadingStatus,  remainingTime: uploadingRemainingTime,  error: uploadingError};const units = $0.units || this.i18n.units;this.i18n = Object.assign({}, this.i18n, $0, {  addFiles: addFiles,  dropFiles: dropFiles,  uploading: uploading, units: units});", new Object[]{i18nJson});
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.i18n != null) {
            this.setI18nWithJS();
        }
    }

    void runBeforeClientResponse(SerializableConsumer<UI> command) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> command.accept(ui)));
    }

    public UploadI18N getI18n() {
        return this.i18n;
    }

    public void clearFileList() {
        this.getElement().setPropertyJson("files", (BaseJsonNode)JacksonUtils.createArrayNode());
    }

    private static final class FailFastUploadHandler
    implements UploadHandler {
        private FailFastUploadHandler() {
        }

        public void handleUploadRequest(UploadEvent event) {
            throw new IllegalStateException("Upload cannot be performed without a upload handler set. Please firstly set the upload handler implementation with upload.setUploadHandler()");
        }
    }

    @Tag(value="vaadin-upload-icon")
    static class UploadIcon
    extends Component {
    }

    private static class DefaultStreamVariable
    implements StreamVariable {
        private Deque<StreamVariable.StreamingStartEvent> lastStartedEvent = new ArrayDeque<StreamVariable.StreamingStartEvent>();
        private final Upload upload;

        public DefaultStreamVariable(Upload upload) {
            this.upload = upload;
        }

        public boolean listenProgress() {
            return this.upload.getEventBus().hasListener(ProgressUpdateEvent.class);
        }

        public void onProgress(StreamVariable.StreamingProgressEvent event) {
            this.upload.fireUpdateProgress(event.getBytesReceived(), event.getContentLength(), event.getFileName());
        }

        public boolean isInterrupted() {
            return this.upload.interrupted;
        }

        public OutputStream getOutputStream() {
            if (this.upload.getReceiver() == null) {
                throw new IllegalStateException("Upload cannot be performed without a receiver set. Please firstly set the receiver implementation with upload.setReceiver");
            }
            StreamVariable.StreamingStartEvent event = this.lastStartedEvent.pop();
            OutputStream receiveUpload = this.upload.getReceiver().receiveUpload(event.getFileName(), event.getMimeType());
            return receiveUpload;
        }

        public void streamingStarted(StreamVariable.StreamingStartEvent event) {
            this.upload.startUpload();
            try {
                this.upload.fireStarted(event.getFileName(), event.getMimeType(), event.getContentLength());
            }
            finally {
                this.lastStartedEvent.addLast(event);
            }
        }

        public void streamingFinished(StreamVariable.StreamingEndEvent event) {
            try {
                this.upload.fireUploadSuccess(event.getFileName(), event.getMimeType(), event.getContentLength());
            }
            finally {
                this.upload.endUpload();
                this.upload.fireUploadFinish(event.getFileName(), event.getMimeType(), event.getContentLength());
            }
        }

        public void streamingFailed(StreamVariable.StreamingErrorEvent event) {
            try {
                Exception exception = event.getException();
                if (exception instanceof NoInputStreamException) {
                    this.upload.fireNoInputStream(event.getFileName(), event.getMimeType(), 0L);
                } else if (exception instanceof NoOutputStreamException) {
                    this.upload.fireNoOutputStream(event.getFileName(), event.getMimeType(), 0L);
                } else {
                    this.upload.fireUploadInterrupted(event.getFileName(), event.getMimeType(), event.getBytesReceived(), exception);
                }
            }
            finally {
                this.upload.endUpload();
                this.upload.fireUploadFinish(event.getFileName(), event.getMimeType(), event.getContentLength());
            }
        }
    }
}

