/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.upload;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.upload.AllFinishedEvent;
import com.vaadin.flow.component.upload.FailedEvent;
import com.vaadin.flow.component.upload.FileRejectedEvent;
import com.vaadin.flow.component.upload.FinishedEvent;
import com.vaadin.flow.component.upload.GeneratedVaadinUpload;
import com.vaadin.flow.component.upload.MultiFileReceiver;
import com.vaadin.flow.component.upload.NoInputStreamEvent;
import com.vaadin.flow.component.upload.NoOutputStreamEvent;
import com.vaadin.flow.component.upload.ProgressUpdateEvent;
import com.vaadin.flow.component.upload.Receiver;
import com.vaadin.flow.component.upload.StartedEvent;
import com.vaadin.flow.component.upload.SucceededEvent;
import com.vaadin.flow.component.upload.UploadI18N;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.JsonSerializer;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.NoInputStreamException;
import com.vaadin.flow.server.NoOutputStreamException;
import com.vaadin.flow.server.StreamReceiver;
import com.vaadin.flow.server.StreamVariable;
import com.vaadin.flow.shared.Registration;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonNull;
import elemental.json.JsonObject;
import elemental.json.JsonType;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class Upload
extends GeneratedVaadinUpload<Upload>
implements HasSize {
    private StreamVariable streamVariable;
    private boolean interrupted = false;
    private int activeUploads = 0;
    private boolean uploading;
    private UploadI18N i18n;
    private Receiver receiver;

    public Upload() {
        this.addUploadErrorListener((ComponentEventListener & Serializable)event -> {});
        this.addUploadSuccessListener((ComponentEventListener & Serializable)event -> {});
        this.addFileRejectListener((ComponentEventListener & Serializable)event -> this.fireEvent(new FileRejectedEvent(this, event.getDetailError())));
        this.addUploadAbortListener((ComponentEventListener & Serializable)event -> this.interruptUpload());
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> this.getElement().setAttribute("target", (AbstractStreamResource)new StreamReceiver(this.getElement().getNode(), "upload", this.getStreamVariable())));
        String elementFiles = "element.files";
        DomEventListener & Serializable allFinishedListener = (DomEventListener & Serializable)e -> {
            JsonArray files = e.getEventData().getArray("element.files");
            boolean isUploading = IntStream.range(0, files.length()).anyMatch(index -> {
                String KEY = "uploading";
                JsonObject object = files.getObject(index);
                return object.hasKey("uploading") && object.getBoolean("uploading");
            });
            if (this.uploading && !isUploading) {
                this.fireAllFinish();
            }
            this.uploading = isUploading;
        };
        this.addUploadStartListener((ComponentEventListener & Serializable)e -> {
            this.uploading = true;
        });
        this.getElement().addEventListener("upload-success", (DomEventListener)allFinishedListener).addEventData("element.files");
        this.getElement().addEventListener("upload-error", (DomEventListener)allFinishedListener).addEventData("element.files");
        this.getElement().addEventListener("upload-abort", (DomEventListener)allFinishedListener).addEventData("element.files");
    }

    public Upload(Receiver receiver) {
        this();
        this.setReceiver(receiver);
    }

    public Registration addAllFinishedListener(ComponentEventListener<AllFinishedEvent> listener) {
        return this.addListener(AllFinishedEvent.class, listener);
    }

    private StreamVariable getStreamVariable() {
        if (this.streamVariable == null) {
            this.streamVariable = new DefaultStreamVariable(this);
        }
        return this.streamVariable;
    }

    public void setMaxFiles(int maxFiles) {
        super.setMaxFiles(maxFiles);
    }

    public int getMaxFiles() {
        return (int)this.getMaxFilesDouble();
    }

    public void setMaxFileSize(int maxFileSize) {
        super.setMaxFileSize(maxFileSize);
    }

    public int getMaxFileSize() {
        return (int)this.getMaxFileSizeDouble();
    }

    public void setAutoUpload(boolean autoUpload) {
        this.setNoAuto(!autoUpload);
    }

    public boolean isAutoUpload() {
        return !this.isNoAutoBoolean();
    }

    public void setDropAllowed(boolean dropAllowed) {
        this.setNodrop(!dropAllowed);
    }

    public boolean isDropAllowed() {
        return !this.isNodropBoolean();
    }

    public void setAcceptedFileTypes(String ... acceptedFileTypes) {
        String accepted = "";
        if (acceptedFileTypes != null) {
            accepted = String.join((CharSequence)",", acceptedFileTypes);
        }
        this.setAccept(accepted);
    }

    public List<String> getAcceptedFileTypes() {
        String accepted = this.getAcceptString();
        if (accepted == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(accepted.split(","));
    }

    public void setUploadButton(Component uploadButton) {
        this.removeElementsAtSlot("add-button");
        if (uploadButton != null) {
            this.addToAddButton(uploadButton);
        }
    }

    public Component getUploadButton() {
        return this.getComponentAtSlot("add-button");
    }

    public void setDropLabel(Component dropLabel) {
        this.removeElementsAtSlot("drop-label");
        if (dropLabel != null) {
            this.addToDropLabel(dropLabel);
        }
    }

    public Component getDropLabel() {
        return this.getComponentAtSlot("drop-label");
    }

    public void setDropLabelIcon(Component dropLabelIcon) {
        this.removeElementsAtSlot("drop-label-icon");
        if (dropLabelIcon != null) {
            this.addToDropLabelIcon(dropLabelIcon);
        }
    }

    public Component getDropLabelIcon() {
        return this.getComponentAtSlot("drop-label-icon");
    }

    private void removeElementsAtSlot(String slot) {
        this.getElement().getChildren().filter(child -> slot.equals(child.getAttribute("slot"))).collect(Collectors.toList()).forEach(Element::removeFromParent);
    }

    private Component getComponentAtSlot(String slot) {
        return this.getElement().getChildren().filter(child -> slot.equals(child.getAttribute("slot"))).filter(child -> child.getComponent().isPresent()).map(child -> (Component)child.getComponent().get()).findFirst().orElse(null);
    }

    private void startUpload() {
        if (this.getMaxFiles() != 0 && this.getMaxFiles() <= this.activeUploads) {
            throw new IllegalStateException("Maximum supported amount of uploads already started");
        }
        ++this.activeUploads;
    }

    public void interruptUpload() {
        if (this.isUploading()) {
            this.interrupted = true;
        }
    }

    private void endUpload() {
        --this.activeUploads;
        this.interrupted = false;
    }

    public boolean isUploading() {
        return this.activeUploads > 0;
    }

    private void fireStarted(String filename, String mimeType, long contentLength) {
        this.fireEvent(new StartedEvent(this, filename, mimeType, contentLength));
    }

    private void fireUploadInterrupted(String filename, String mimeType, long length) {
        this.fireEvent(new FailedEvent(this, filename, mimeType, length));
    }

    private void fireNoInputStream(String filename, String mimeType, long length) {
        this.fireEvent(new NoInputStreamEvent(this, filename, mimeType, length));
    }

    private void fireNoOutputStream(String filename, String mimeType, long length) {
        this.fireEvent(new NoOutputStreamEvent(this, filename, mimeType, length));
    }

    private void fireUploadInterrupted(String filename, String mimeType, long length, Exception e) {
        this.fireEvent(new FailedEvent(this, filename, mimeType, length, e));
    }

    private void fireUploadSuccess(String filename, String mimeType, long length) {
        this.fireEvent(new SucceededEvent(this, filename, mimeType, length));
    }

    private void fireUploadFinish(String filename, String mimeType, long length) {
        this.fireEvent(new FinishedEvent(this, filename, mimeType, length));
    }

    private void fireAllFinish() {
        this.fireEvent(new AllFinishedEvent(this));
    }

    protected void fireUpdateProgress(long totalBytes, long contentLength) {
        this.fireEvent(new ProgressUpdateEvent(this, totalBytes, contentLength));
    }

    public Registration addProgressListener(ComponentEventListener<ProgressUpdateEvent> listener) {
        return this.addListener(ProgressUpdateEvent.class, listener);
    }

    public Registration addFailedListener(ComponentEventListener<FailedEvent> listener) {
        return this.addListener(FailedEvent.class, listener);
    }

    public Registration addFinishedListener(ComponentEventListener<FinishedEvent> listener) {
        return this.addListener(FinishedEvent.class, listener);
    }

    public Registration addStartedListener(ComponentEventListener<StartedEvent> listener) {
        return this.addListener(StartedEvent.class, listener);
    }

    public Registration addSucceededListener(ComponentEventListener<SucceededEvent> listener) {
        return this.addListener(SucceededEvent.class, listener);
    }

    public Registration addFileRejectedListener(ComponentEventListener<FileRejectedEvent> listener) {
        return this.addListener(FileRejectedEvent.class, listener);
    }

    public Receiver getReceiver() {
        return this.receiver;
    }

    public void setReceiver(Receiver receiver) {
        this.receiver = receiver;
        if (!(receiver instanceof MultiFileReceiver)) {
            this.setMaxFiles(1);
        } else {
            this.getElement().removeAttribute("maxFiles");
        }
    }

    public void setI18n(UploadI18N i18n) {
        Objects.requireNonNull(i18n, "The I18N properties object should not be null");
        this.i18n = i18n;
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> {
            if (i18n == this.i18n) {
                this.setI18nWithJS();
            }
        });
    }

    private void setI18nWithJS() {
        JsonObject i18nJson = (JsonObject)JsonSerializer.toJson((Object)this.i18n);
        this.deeplyRemoveNullValuesFromJsonObject(i18nJson);
        this.getElement().executeJs("const dropFiles = Object.assign({}, this.i18n.dropFiles, $0.dropFiles);const addFiles = Object.assign({}, this.i18n.addFiles, $0.addFiles);const error = Object.assign({}, this.i18n.error, $0.error);const uploadingStatus = Object.assign({}, this.i18n.uploading.status, $0.uploading && $0.uploading.status);const uploadingRemainingTime = Object.assign({}, this.i18n.uploading.remainingTime, $0.uploading && $0.uploading.remainingTime);const uploadingError = Object.assign({}, this.i18n.uploading.error, $0.uploading && $0.uploading.error);const uploading = {status: uploadingStatus,  remainingTime: uploadingRemainingTime,  error: uploadingError};const units = $0.units || this.i18n.units;this.i18n = Object.assign({}, this.i18n, $0, {  addFiles: addFiles,  dropFiles: dropFiles,  uploading: uploading, units: units});", new Serializable[]{i18nJson});
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.i18n != null) {
            this.setI18nWithJS();
        }
    }

    private void deeplyRemoveNullValuesFromJsonObject(JsonObject jsonObject) {
        for (String key : jsonObject.keys()) {
            if (jsonObject.get(key).getType() == JsonType.OBJECT) {
                this.deeplyRemoveNullValuesFromJsonObject((JsonObject)jsonObject.get(key));
                continue;
            }
            if (jsonObject.get(key).getType() != JsonType.NULL) continue;
            jsonObject.remove(key);
        }
    }

    void runBeforeClientResponse(SerializableConsumer<UI> command) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> command.accept(ui)));
    }

    public UploadI18N getI18n() {
        return this.i18n;
    }

    private String getStringObject(String propertyName, String subName) {
        String result = null;
        JsonObject json = (JsonObject)this.getElement().getPropertyRaw(propertyName);
        if (json != null && json.hasKey(subName) && !(json.get(subName) instanceof JsonNull)) {
            result = json.getString(subName);
        }
        return result;
    }

    private String getStringObject(String propertyName, String object, String subName) {
        String result = null;
        JsonObject json = (JsonObject)this.getElement().getPropertyRaw(propertyName);
        if (json != null && json.hasKey(object) && !(json.get(object) instanceof JsonNull) && (json = json.getObject(object)) != null && json.hasKey(subName) && !(json.get(subName) instanceof JsonNull)) {
            result = json.getString(subName);
        }
        return result;
    }

    public void clearFileList() {
        this.setFiles(Json.createArray());
    }

    private static class DefaultStreamVariable
    implements StreamVariable {
        private Deque<StreamVariable.StreamingStartEvent> lastStartedEvent = new ArrayDeque<StreamVariable.StreamingStartEvent>();
        private final Upload upload;

        public DefaultStreamVariable(Upload upload) {
            this.upload = upload;
        }

        public boolean listenProgress() {
            return this.upload.getEventBus().hasListener(ProgressUpdateEvent.class);
        }

        public void onProgress(StreamVariable.StreamingProgressEvent event) {
            this.upload.fireUpdateProgress(event.getBytesReceived(), event.getContentLength());
        }

        public boolean isInterrupted() {
            return this.upload.interrupted;
        }

        public OutputStream getOutputStream() {
            if (this.upload.getReceiver() == null) {
                throw new IllegalStateException("Upload cannot be performed without a receiver set. Please firstly set the receiver implementation with upload.setReceiver");
            }
            StreamVariable.StreamingStartEvent event = this.lastStartedEvent.pop();
            OutputStream receiveUpload = this.upload.getReceiver().receiveUpload(event.getFileName(), event.getMimeType());
            return receiveUpload;
        }

        public void streamingStarted(StreamVariable.StreamingStartEvent event) {
            this.upload.startUpload();
            try {
                this.upload.fireStarted(event.getFileName(), event.getMimeType(), event.getContentLength());
            }
            finally {
                this.lastStartedEvent.addLast(event);
            }
        }

        public void streamingFinished(StreamVariable.StreamingEndEvent event) {
            try {
                this.upload.fireUploadSuccess(event.getFileName(), event.getMimeType(), event.getContentLength());
            }
            finally {
                this.upload.endUpload();
                this.upload.fireUploadFinish(event.getFileName(), event.getMimeType(), event.getContentLength());
            }
        }

        public void streamingFailed(StreamVariable.StreamingErrorEvent event) {
            try {
                Exception exception = event.getException();
                if (exception instanceof NoInputStreamException) {
                    this.upload.fireNoInputStream(event.getFileName(), event.getMimeType(), 0L);
                } else if (exception instanceof NoOutputStreamException) {
                    this.upload.fireNoOutputStream(event.getFileName(), event.getMimeType(), 0L);
                } else {
                    this.upload.fireUploadInterrupted(event.getFileName(), event.getMimeType(), event.getBytesReceived(), exception);
                }
            }
            finally {
                this.upload.endUpload();
                this.upload.fireUploadFinish(event.getFileName(), event.getMimeType(), event.getContentLength());
            }
        }
    }
}

